/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.swt.builder;

import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.action.IAction;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ActionManager;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ActionNotFoundException;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.CalculatorControler;
import jp.gr.java_conf.dev240k.mixedcalc.ui.CalculatorUIControler;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcLoggerUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcUI;
import jp.gr.java_conf.dev240k.mixedcalc.ui.MixedCalcUIUtil;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.ActionButtonModel;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.ControlModel;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.CustomControlModel;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.DummyControlModel;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.LoadFailedControlModel;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.model.event.ActionButtonSelectionListener;
import jp.gr.java_conf.dev240k.mixedcalc.ui.ssuif.swt.SWTControlUtil;
import jp.gr.java_conf.dev240k.util.loader.ExtensionInstantiationException;
import jp.gr.java_conf.dev240k.util.loader.PluginManager;
import jp.gr.java_conf.dev240k.util.ssuif.model.IMultipleSpanModel;
import jp.gr.java_conf.dev240k.util.ssuif.model.event.ISelectionListener;
import jp.gr.java_conf.dev240k.util.ssuif.swt.AbstractControlBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GeneralControlBuilder
extends AbstractControlBuilder {
    ActionManager actionManager = null;

    private ActionManager getActionManager() {
        if (this.actionManager == null) {
            CalculatorUIControler controler = (CalculatorUIControler)((Object)super.getControler());
            this.actionManager = new ActionManager((PluginManager)controler.getMixedCalcPluginManager(), (CalculatorControler)controler);
        }
        return this.actionManager;
    }

    private Object createActionButtonModel(ControlModel controlModel) {
        IAction action;
        if (MixedCalcLoggerUtil.isDebugEnabled(((Object)((Object)this)).getClass())) {
            MixedCalcLoggerUtil.debug(((Object)((Object)this)).getClass(), "create action button model.");
            MixedCalcLoggerUtil.debug(((Object)((Object)this)).getClass(), "id: " + controlModel.getPluginId());
        }
        ActionButtonModel actionButtonModel = new ActionButtonModel(controlModel);
        ActionManager actionManager = this.getActionManager();
        try {
            action = actionManager.getAction(controlModel.getPluginId());
        }
        catch (ActionNotFoundException e) {
            String[] args = new String[]{controlModel.getPluginId(), "jp.gr.java_conf.dev240k.mixedcalc.lib.action"};
            MixedCalcLoggerUtil.warn(((Object)((Object)this)).getClass(), MixedCalcUIUtil.getMessage("message.warn.PluginNotFound", args), e);
            return new LoadFailedControlModel((IMultipleSpanModel)controlModel);
        }
        catch (ExtensionInstantiationException e) {
            String[] args = new String[]{controlModel.getPluginId(), "jp.gr.java_conf.dev240k.mixedcalc.lib.action"};
            MixedCalcLoggerUtil.warn(((Object)((Object)this)).getClass(), MixedCalcUIUtil.getMessage("message.warn.PluginNotFound", args), e);
            return new LoadFailedControlModel((IMultipleSpanModel)controlModel);
        }
        if (action != null) {
            CalculatorUIControler controler = (CalculatorUIControler)((Object)super.getControler());
            ActionButtonSelectionListener listener = new ActionButtonSelectionListener(controler, action);
            actionButtonModel.addSelectionListener((ISelectionListener)listener);
            actionButtonModel.setText(action.getMnemonic());
        }
        return actionButtonModel;
    }

    public Control createControl(Object model, Composite parent) {
        Control control;
        ControlModel controlModel = (ControlModel)((Object)model);
        Object concreteModel = null;
        if ("jp.gr.java_conf.dev240k.mixedcalc.lib.action".equals(controlModel.getExtensionPoint())) {
            concreteModel = this.createActionButtonModel(controlModel);
        } else if (MixedCalcUI.EXTENSION_POINT_ID_CUSTOM_CONTROL.equals(controlModel.getExtensionPoint())) {
            concreteModel = new CustomControlModel(controlModel);
        } else if (MixedCalcUI.EXTENSION_POINT_ID_DUMMY_CONTROL.equals(controlModel.getExtensionPoint())) {
            concreteModel = new DummyControlModel((IMultipleSpanModel)controlModel);
        }
        if (concreteModel == null) {
            MixedCalcLoggerUtil.warn(((Object)((Object)this)).getClass(), MixedCalcUIUtil.getMessage("message.warn.CannotCreateControl"));
            concreteModel = new LoadFailedControlModel((IMultipleSpanModel)controlModel);
        }
        if ((control = super.createChildControl(concreteModel, parent)) == null) {
            MixedCalcLoggerUtil.warn(((Object)((Object)this)).getClass(), MixedCalcUIUtil.getMessage("message.warn.CannotCreateControl"));
            concreteModel = new LoadFailedControlModel((IMultipleSpanModel)controlModel);
            control = super.createChildControl(concreteModel, parent);
        }
        SWTControlUtil.addFontStyle(control, 1);
        return control;
    }
}

