/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.ui;

import jp.gr.java_conf.dev240k.mixedcalc.ui.eclipse.MixedCalcPlugin;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class MixedCalcLoggerUtil {
    private MixedCalcLoggerUtil() {
    }

    public static void configure(ClassLoader loader, String fileName) {
        LoggerUtil.configure((ClassLoader)loader, (String)fileName);
    }

    public static boolean isTraceEnabled(Class clazz) {
        return LoggerUtil.isTraceEnabled((Class)clazz);
    }

    public static void trace(Class clazz, String msg) {
        LoggerUtil.trace((Class)clazz, (String)msg);
    }

    public static boolean isDebugEnabled(Class clazz) {
        return LoggerUtil.isDebugEnabled((Class)clazz);
    }

    public static void debug(Class clazz, String msg) {
        LoggerUtil.debug((Class)clazz, (String)msg);
    }

    public static boolean isInfoEnabled(Class clazz) {
        return LoggerUtil.isInfoEnabled((Class)clazz);
    }

    public static void info(Class clazz, String msg) {
        LoggerUtil.info((Class)clazz, (String)msg);
    }

    public static void warn(Class clazz, String msg) {
        LoggerUtil.warn((Class)clazz, (String)msg);
        Status status = new Status(2, MixedCalcPlugin.getPluginId(), msg);
        MixedCalcPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void warn(Class clazz, String msg, Throwable e) {
        LoggerUtil.warn((Class)clazz, (String)msg, (Throwable)e);
        Status status = new Status(2, MixedCalcPlugin.getPluginId(), msg, e);
        MixedCalcPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void error(Class clazz, String msg) {
        LoggerUtil.error((Class)clazz, (String)msg);
        Status status = new Status(4, MixedCalcPlugin.getPluginId(), msg);
        MixedCalcPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void error(Class clazz, String msg, Throwable e) {
        LoggerUtil.error((Class)clazz, (String)msg, (Throwable)e);
        Status status = new Status(4, MixedCalcPlugin.getPluginId(), msg, e);
        MixedCalcPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void fatal(Class clazz, String msg) {
        LoggerUtil.fatal((Class)clazz, (String)msg);
        Status status = new Status(4, MixedCalcPlugin.getPluginId(), msg);
        MixedCalcPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void fatal(Class clazz, String msg, Throwable e) {
        LoggerUtil.fatal((Class)clazz, (String)msg, (Throwable)e);
        Status status = new Status(4, MixedCalcPlugin.getPluginId(), msg, e);
        MixedCalcPlugin.getDefault().getLog().log((IStatus)status);
    }

    private static void openErrorDialog(IStatus status) {
        Shell shell = MixedCalcPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
    }

    public static void openInfoDialog(String msg) {
        Status status = new Status(1, MixedCalcPlugin.getPluginId(), msg);
        MixedCalcLoggerUtil.openErrorDialog((IStatus)status);
    }

    public static void openInfoDialog(String msg, Throwable e) {
        Status status = new Status(1, MixedCalcPlugin.getPluginId(), msg, e);
        MixedCalcLoggerUtil.openErrorDialog((IStatus)status);
    }

    public static void openWarningDialog(String msg) {
        Status status = new Status(2, MixedCalcPlugin.getPluginId(), msg);
        MixedCalcLoggerUtil.openErrorDialog((IStatus)status);
    }

    public static void openWarningDialog(String msg, Throwable e) {
        Status status = new Status(2, MixedCalcPlugin.getPluginId(), msg, e);
        MixedCalcLoggerUtil.openErrorDialog((IStatus)status);
    }

    public static void openErrorDialog(String msg) {
        Status status = new Status(4, MixedCalcPlugin.getPluginId(), msg);
        MixedCalcLoggerUtil.openErrorDialog((IStatus)status);
    }

    public static void openErrorDialog(String msg, Throwable e) {
        Status status = new Status(4, MixedCalcPlugin.getPluginId(), msg, e);
        MixedCalcLoggerUtil.openErrorDialog((IStatus)status);
    }
}

