/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NodeWrapper {
    private Node node;

    public NodeWrapper(Node node) {
        this.node = node;
    }

    public NodeWrapper() {
        this.node = null;
    }

    private Document getParentDocument() {
        if (this.node == null) {
            return null;
        }
        Document document = this.node instanceof Document ? (Document)this.node : this.node.getOwnerDocument();
        return document;
    }

    private List getInnerNodeList(String tagName) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = this.node.getChildNodes();
        if (tagName == null || tagName.equals("*")) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    list.add(node);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && tagName.equals(node.getNodeName())) {
                    list.add(node);
                }
                ++i;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private Node getFirstChild() {
        return this.node.getFirstChild();
    }

    private Node addTextNode(String tagName, String str) {
        Node child;
        if (this.node == null) {
            return null;
        }
        Document document = this.getParentDocument();
        if (document == null) {
            return null;
        }
        Text textNode = document.createTextNode(str);
        List valueNodeList = this.getInnerNodeList(tagName);
        if (valueNodeList == null) {
            Element child2 = document.createElement(tagName);
            this.node.appendChild(child2);
            child2.appendChild(textNode);
            return textNode;
        }
        Node valueNode = (Node)valueNodeList.get(0);
        if (valueNode == null) {
            child = document.createElement(tagName);
            this.node.appendChild(child);
        } else if (valueNode.getNodeType() != 1) {
            child = document.createElement(tagName);
            this.node.replaceChild(child, valueNode);
        } else {
            child = valueNode;
        }
        child.appendChild(textNode);
        return textNode;
    }

    Node getNode() {
        return this.node;
    }

    public int getNumberOfNodes(String tagName) {
        List nodeList = this.getInnerNodeList(tagName);
        if (nodeList == null) {
            return 0;
        }
        return nodeList.size();
    }

    public List getNodeTagList() {
        List nodeList = this.getInnerNodeList("*");
        if (nodeList == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getNodeType() != 1 || list.contains(node.getNodeName())) continue;
            list.add(node.getNodeName());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List getNodeList(String tagName) {
        List nodeList = this.getInnerNodeList(tagName);
        if (nodeList == null) {
            return null;
        }
        ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>();
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getNodeType() != 1) continue;
            list.add(new NodeWrapper(node));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public NodeWrapper getNthNode(String tagName, int n) {
        List nodeList = this.getInnerNodeList(tagName);
        if (nodeList == null) {
            return null;
        }
        Node node = (Node)nodeList.get(n);
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        return new NodeWrapper(node);
    }

    public NodeWrapper getFirstNode(String tagName) {
        return this.getNthNode(tagName, 0);
    }

    public Map getAttributes() {
        NamedNodeMap nodeMap = this.node.getAttributes();
        HashMap<String, String> attrMap = new HashMap<String, String>();
        int n = nodeMap.getLength();
        int i = 0;
        while (i < n) {
            Node node = nodeMap.item(i);
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                attrMap.put(attr.getName(), attr.getValue());
            }
            ++i;
        }
        return attrMap;
    }

    public String getAttribute(String name) {
        NamedNodeMap nodeMap = this.node.getAttributes();
        Node node = nodeMap.getNamedItem(name);
        if (node == null || !(node instanceof Attr)) {
            return null;
        }
        return ((Attr)node).getValue();
    }

    public String getChildValue(String tagName) {
        NodeWrapper firstNode = this.getFirstNode(tagName);
        if (firstNode == null) {
            return null;
        }
        Node valueNode = firstNode.getFirstChild();
        if (valueNode == null) {
            return null;
        }
        String str = valueNode.getNodeValue();
        return str;
    }

    public void setChildValue(String tagName, String str) {
        Node valueNode = this.getNthNode(tagName, 0).getFirstChild();
        if (valueNode == null) {
            this.addTextNode(tagName, str);
        } else {
            valueNode.setNodeValue(str);
        }
    }

    public String getNodeValue() {
        Node valueNode = this.getFirstChild();
        if (valueNode == null) {
            return null;
        }
        return valueNode.getNodeValue();
    }

    public void setNodeValue(String str) {
        if (this.node == null) {
            return;
        }
        Document document = this.getParentDocument();
        if (document == null) {
            return;
        }
        Text textNode = document.createTextNode(str);
        this.node.appendChild(textNode);
    }

    public NodeWrapper createNode(String tagName) {
        Document document = this.getParentDocument();
        if (document == null) {
            return null;
        }
        Element node = document.createElement(tagName);
        return new NodeWrapper(node);
    }

    public String getNodeName() {
        if (this.node == null) {
            return null;
        }
        return this.node.getNodeName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.node.toString());
        this.getAttributes();
        List nodeList = this.getNodeList("*");
        if (nodeList == null) {
            return buffer.toString();
        }
        buffer.append("\n");
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            NodeWrapper node = (NodeWrapper)it.next();
            buffer.append(node.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

