/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.mixedcalc.lib.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.gr.java_conf.dev240k.mixedcalc.lib.framework.MixedCalcLibraryUtil;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.IBufferParser;
import jp.gr.java_conf.dev240k.mixedcalc.lib.impl.ValueElement;
import jp.gr.java_conf.dev240k.util.commons.LoggerUtil;

public class DefaultBufferParser
implements IBufferParser {
    private Double parseEachStringAsDouble(String str) {
        return Double.valueOf(str);
    }

    private Double parseEachStringInRadix(String str, int radix) {
        return new Double(Integer.parseInt(str, radix));
    }

    private Double parseEachStringAsTime(String str) {
        String strTmp = ':' == str.charAt(str.length() - 1) ? String.valueOf(str) + "0" : str;
        String[] strs = strTmp.split(":");
        if (3 < strs.length) {
            throw new NumberFormatException(MixedCalcLibraryUtil.getMessage("message.debug.CannotParseAsTime"));
        }
        int i = 0;
        double d = Double.parseDouble(strs[i]) * 60.0 * 60.0;
        double signum = Math.signum(d);
        if (signum == 0.0) {
            signum = 1.0;
        }
        if (strs.length <= ++i) {
            return new Double(d);
        }
        d += signum * Double.parseDouble(strs[i]) * 60.0;
        if (strs.length <= ++i) {
            return new Double(d);
        }
        return new Double(d += signum * Double.parseDouble(strs[i]));
    }

    private Double calendarToDouble(Calendar cal) {
        long timeInMillis = cal.getTimeInMillis();
        return new Double((double)timeInMillis / 8.64E7);
    }

    private Double parseEachStringAsDate(String str) {
        String strTmp = '/' == str.charAt(str.length() - 1) ? String.valueOf(str) + "0" : str;
        String[] strs = strTmp.split("/");
        if (3 < strs.length) {
            throw new NumberFormatException(MixedCalcLibraryUtil.getMessage("message.debug.CannotParseAsDate"));
        }
        int i = 0;
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        int year = Integer.parseInt(strs[i]);
        cal.set(1, year);
        if (strs.length <= ++i) {
            return this.calendarToDouble(cal);
        }
        int month = Integer.parseInt(strs[i]);
        cal.set(2, month - 1);
        if (strs.length <= ++i) {
            return this.calendarToDouble(cal);
        }
        int day = Integer.parseInt(strs[i]);
        cal.set(5, day);
        return this.calendarToDouble(cal);
    }

    private Double parseEachString(String str, int numSys) {
        if (numSys == 1) {
            return this.parseEachStringAsDouble(str);
        }
        if (numSys == 2) {
            return this.parseEachStringInRadix(str, 2);
        }
        if (numSys == 3) {
            return this.parseEachStringInRadix(str, 8);
        }
        if (numSys == 4) {
            return this.parseEachStringInRadix(str, 16);
        }
        if (numSys == 5) {
            return this.parseEachStringAsTime(str);
        }
        if (numSys == 6) {
            return this.parseEachStringAsDate(str);
        }
        return null;
    }

    private List parseToList(StringBuffer buffer, int numSys) {
        String tmp = buffer.toString().replaceFirst(",\\s*-{0,1}$", "");
        String[] buffers = tmp.split(",");
        ArrayList<Double> list = new ArrayList<Double>();
        int i = 0;
        while (i < buffers.length) {
            Double d;
            try {
                d = this.parseEachString(buffers[i].trim(), numSys);
            }
            catch (NumberFormatException e) {
                LoggerUtil.debug(this.getClass(), (String)(String.valueOf(e.getClass().getName()) + ": " + e.getMessage()));
                return null;
            }
            if (d == null) {
                return null;
            }
            list.add(d);
            ++i;
        }
        return list;
    }

    public ValueElement parseBuffer(StringBuffer buffer, int numSys) {
        List list = this.parseToList(buffer, numSys);
        if (list == null) {
            return null;
        }
        ValueElement element = new ValueElement();
        element.setValueList(list);
        element.setNumberSystem(numSys);
        return element;
    }

    public boolean validateBuffer(StringBuffer buffer, int numSys) {
        return this.parseToList(buffer, numSys) != null;
    }
}

