/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dev240k.util.commons;

import java.util.Locale;
import java.util.ResourceBundle;

public class MessageUtil {
    private String propertiesBaseName = "messages";
    private Locale locale = Locale.getDefault();
    private ClassLoader classLoader = null;
    ResourceBundle resourceBundle;

    public MessageUtil() {
    }

    public MessageUtil(String propertiesBaseName) {
        this.propertiesBaseName = propertiesBaseName;
        this.loadResourceBundle();
    }

    public MessageUtil(String propertiesBaseName, ClassLoader classLoader) {
        this.propertiesBaseName = propertiesBaseName;
        this.classLoader = classLoader;
        this.loadResourceBundle();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale != null ? locale : Locale.getDefault();
        this.loadResourceBundle();
    }

    public String getPropertiesBaseName() {
        return this.propertiesBaseName;
    }

    public void setPropertiesBaseName(String propertiesBaseName) {
        this.propertiesBaseName = propertiesBaseName;
        this.loadResourceBundle();
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void loadResourceBundle() {
        this.resourceBundle = this.classLoader != null ? ResourceBundle.getBundle(this.propertiesBaseName, this.locale, this.classLoader) : (this.locale != null ? ResourceBundle.getBundle(this.propertiesBaseName, this.locale) : ResourceBundle.getBundle(this.propertiesBaseName));
    }

    public String getMessage(String key) {
        if (this.resourceBundle == null) {
            this.loadResourceBundle();
        }
        return this.resourceBundle.getString(key);
    }

    public String getMessage(String key, String[] args) {
        String msg = this.getMessage(key);
        int i = 0;
        while (i < args.length) {
            String replaceKey = "%" + String.valueOf(i + 1);
            String arg = args[i];
            if (arg == null) {
                arg = "";
            }
            msg = msg.replaceAll(replaceKey, arg);
            ++i;
        }
        return msg;
    }
}

