/**
 *  mLanguage
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: language.js,v $ $Revision: 1.5 $ $Date: 2006/11/20 07:39:16 $
 * 
 *  @requires  mController
 *  @requires  mUtils
 *  @member    mUtils
**/
{
 /**
  *  system language data object
  * 
  *  @private
 **/
 this._systemData = {};

 /**
  *  language data object
  * 
  *  @private
 **/
 this._langData = {};

 /**
  *  custom language data object
  * 
  *  @private
 **/
 this._customData = {};

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.init = function()
 {
  this._loadLanguage();
 };

 /**
  *  _loadLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @see     mUtils#_setupLanguage
  *  @private
 **/
 this._loadLanguage = function()
 {
  var config = mUtils.config;
  var file   = config.getConfig('sysLangPath') + config.getConfig('language') + '/system.js';
  try
  {
   mUtils.loadFile(file);
   mUtils.waitResponse(this,{'_systemData' : file},this._setupLanguage,null);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mLanguage','load system language',e);
  }
 };

 /**
  *  _setupLanguage
  * 
  *  @param   void
  * 
  *  @return  void
  * 
  *  @private
 **/
 this._setupLanguage = function()
 {
 };

 /**
  *  loadDirLanguage
  * 
  *  @param   function  func  // onload function
  *  @param   object    args  // arguments of onload function
  * 
  *  @return  void
 **/
 this.loadDirLanguage = function(func,args)
 {
  var config = mUtils.config;
  if(config.getConfig('useDirLanguage'))
  {
   var file = config.getConfig('languagesPath') + config.getConfig('language') + '/lang.js';
   mUtils.loadFile(file);
   mUtils.waitResponse(this,{'_langData' : file},func,args);
  }
  else
  {
   func(args);
  }
 };

 /**
  *  loadCustomLanguage
  * 
  *  @param  string    actionName  // target action name
  *  @param  function  func        // onload function
  *  @param  object    args        // arguments of onload function
  * 
  *  @return  void
 **/
 this.loadCustomLanguage = function(actionName,func,args)
 {
  this.resetLanguage();
  var config = mUtils.config;
  if(config.getConfig('useCustomLanguage'))
  {
   var file = config.getConfig('languagesPath') + config.getConfig('language') + '/' + actionName + 'Lang.js';
   mUtils.loadFile(file);
   mUtils.waitResponse(this,{'_customData' : file},func,args);
  }
  else
  {
   func(args);
  }
 };

 /**
  *  resetLanguage
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 this.resetLanguage = function()
 {
  this._customData = {};
 };

 /**
  *  getLanguage
  * 
  *  @param   string  keyName  // target key name
  *  @param   hash    opts     // replacement hash
  * 
  *  @return  string
 **/
 this.getLanguage = function(keyName,opts)
 {
  var str = null;
  switch(true)
  {
   case this._customData[keyName] != undefined:
    str = this._customData[keyName];
    break;
   case this._langData[keyName] != undefined:
    str = this._langData[keyName];
    break;
   case this._systemData[keyName] != undefined:
    str = this._systemData[keyName];
    break;
   default:
    mUtils.logger.setMessage('notice','mLanguage','get language string',mUtils.language.getLanguage('mLanguageUndefined',{'keyName' : keyName}));
    return null;
  }
  for(var i in opts)
   str = str.replace('{' + i + '}',opts[i]);
  return str;
 };
};
