/**
 *  mAbstractModel
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: abstractModel.js,v $ $Revision: 1.5 $ $Date: 2006/11/17 10:12:10 $
 * 
 *  @requires mUtils
 *  @requires mAction
 *  @member   mAction
**/
mAbstractModel = function()
{
 /**
  *  mDataObject
  * 
  *  @private
 **/
 this._dataObject = [];

 /**
  *  init
  * 
  *  @param   mRequest  request  // request object
  * 
  *  @return  void
 **/
 this.init = function(request)
 {
 };

 /**
  *  initVar
  * 
  *  @param   enum    type       // value type
  *                     bool,int,float,string,text
  *  @param   string  keyName    // id key name
  *  @param   object  value      // value
  *  @param   array   validator  // validator name array
  *  @param   array   filter     // filter name array
  * 
  *  @return  void
 **/
 this.initVar = function(type,keyName,value,validator,filter)
 {
  this._dataObject[keyName] =
  {
   'type'      : type,
   'validator' : validator,
   'filter'    : filter
  };
  this.set(keyName,value);
 };

 /**
  *  get
  * 
  *  @param   string  keyName  // target key name
  * 
  *  @return  object
 **/
 this.get = function(keyName)
 {
  return this._dataObject[keyName].value;
 };

 /**
  *  show
  * 
  *  @param   string  keyName  // target key name
  * 
  *  @return  object
 **/
 this.show = function(keyName)
 {
  var obj = this._dataObject[keyName];
  return mUtils.doFilter(obj.value,obj.filter,{});
 };

 /**
  *  set
  * 
  *  @param   string  keyName  // target key name
  *  @param   string  value    // value
  * 
  *  @return  void
 **/
 this.set = function(keyName,value)
 {
  var obj   = this._dataObject[keyName];
  value     = mUtils.doTypeSafe(obj.type,value);
  value     = mUtils.doValidate(value,obj.validator,{});
  obj.value = value;
 };
};
