/**
 *  mController
 * 
 *  @author   $Author: mumincacao $
 *  @version  $Name:  $ $RCSfile: mController.js,v $ $Revision: 1.1 $ $Date: 2006/11/12 07:59:06 $
 * 
 *  @requires DomUtils
 *  @requires mUtils
**/
var mController =
{
 /**
  *  render object
  * 
  *  @see     mRender
  *  @private
 **/
 _render : {},

 /**
  *  request object
  * 
  *  @see     mRequest
  *  @private
 **/
 _request : {},

 /**
  *  model objects
  * 
  *  @see     mModel
  *  @private
 **/
 _models : {},

 /**
  *  action objects
  * 
  *  @see     mAction
  *  @private
 **/
 _actions : {},

 /**
  *  init
  * 
  *  @param   void
  * 
  *  @return  void
 **/
 init : function()
 {
 },

 /**
  *  procedureAction
  * 
  *  @param   string  actionName
  * 
  *  @return  bool
 **/
 procedureAction : function(actionName)
 {
  mUtils.logger.resetLog();
  mController._loadConfig(actionName);
 },

 /**
  *  _loadConfig
  * 
  *  @param   string  actionName
  * 
  *  @return  void
  * 
  *  @see     mController#_loadLanguage
  *  @private
 **/
 _loadConfig : function(actionName)
 {
  var config = mUtils.config;
  if(!config.getConfig('useCustomConfig'))
  {
   this._loadLanguage(actionName);
   return;
  }
  config.resetConfig();
  var file = config.getConfig('configPath') + actionName + 'Config.js';
  mUtils.loadFile(file);
  mUtils.waitResponse(config,{'_customData' : file},this._loadLanguage,actionName);
 },

 /**
  *  _loadLanguage
  * 
  *  @param   string   actionName
  * 
  *  @return  void
  * 
  *  @see     mController#_loadFrame
  *  @private
 **/
 _loadLanguage : function(actionName)
 {
  var config = mUtils.config;
  if(!config.getConfig('useCustomLanguage'))
  {
   mController._loadFrame(actionName);
   return;
  }
  mUtils.language.resetLanguage();
  var file = config.getConfig('languagesPath') + config.getConfig('language') + '/' + actionName + 'Lang.js';
  mUtils.waitResponse(mUtils.language,{'_customData' : file},mController._loadFrame,actionName);
 },

 /**
  *  _loadFrame
  * 
  *  @param   string  actionName
  * 
  *  @return  void
  * 
  *  @see     mController#_setupFrame
  *  @private
 **/
 _loadFrame : function(actionName)
 {
  var config = mUtils.config;
  mUtils.loadFile(config.getConfig('renderPath'));
  mUtils.loadFile(config.getConfig('requestPath'));
  mUtils.waitResponse(this,{
        '_render'  : config.getConfig('renderPath'),
        '_request' : config.getConfig('requestPath')
        },this._setupFrame,actionName)
 },

 /**
  *  _setupFrame
  * 
  *  @param   string  actionName
  * 
  *  @return  void
  * 
  *  @see     mController#_loadModel
  *  @private
 **/
 _setupFrame : function(actionName)
 {
  mController._request.init();
  mController._render.init();
  mController._loadModel(actionName);
 },

 /**
  *  _loadModel
  * 
  *  @param   string  actionName
  * 
  *  @return  void
  * 
  *  @see     mController#_setupModel
  *  @private
 **/
 _loadModel : function(actionName)
 {
  var file = mUtils.config.getConfig('modelPath') + actionName + 'Model.js';
  var obj  = {};
  obj[actionName] = file;
  mUtils.loadFile(file);
  mUtils.waitResponse(this._models,obj,this._loadAction,actionName);
 },

 /**
  *  _loadAction
  * 
  *  @param   string  actionName
  * 
  *  @return  void
  * 
  *  @see     mController#_setupAction
  *  @private
 **/
 _loadAction : function(actionName)
 {
  var file = mUtils.config.getConfig('actionPath') + actionName + 'Action.js';
  var obj  = new Object();
  obj[actionName] = file;
  mUtils.loadFile(file);
  mUtils.waitResponse(mController._actions,obj,mController._setupAction,actionName);
 },

 /**
  *  _setupAction
  * 
  *  @param   string   actionName
  * 
  *  @return  mAction
  * 
  *  @see     mController#_executeAction
  *  @private
 **/
 _setupAction : function(actionName)
 {
  var action = mController._actions[actionName];
  try
  {
   action.init(mController._models[actionName]);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action initialize',actionName + mUtils.language.getLanguage('mControllerCantInit'));
  }
  mController._executeAction(action);
 },

 /**
  *  _executeAction
  * 
  *  @param   mAction  action
  * 
  *  @return  eNum
  * 
  *  @see     mController#_executeView
  *  @private
 **/
 _executeAction : function(action)
 {
  try
  {
   var viewName = action.execute(this._request);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action execute',actionName + mUtils.language.getLanguage('mControllerCantexecute'));
  }
  this._executeView(action,viewName);
 },

 /**
  *  _executeView
  * 
  *  @param   mAction  action
  *  @param   eNum     viewName
  * 
  *  @return  void
  * 
  *  @private
 **/
 _executeView : function(action,viewName)
 {
  try
  {
   action[viewName](this._render);
  }
  catch(e)
  {
   mUtils.logger.setMessage('critical','mController','action view',actionName + '.' + viewName + mUtils.language.getLanguage('mControllerCantView'));
  }
  this._render.display();
  if(mUtils.config.getConfig('useDebug'))
   mUtils.renderLog('memo',true);
 }
};

DomUtils.appendEvent(window,'load',mController.init,false);
