/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб                                                      */
/*============================================================================*/
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>

#include <xmlcatHelp.h>
struct mssComHelp comHelp={
  "xmlcat",       /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*              */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvǻȤʸĹ*/

/*----------------------------------------------------------------------------*/
/* Хѿ                                                             */
/*----------------------------------------------------------------------------*/
extern xmlParserCtxtPtr ctxt;
extern struct mssGlobalVariables mssGV;

static struct mssFPW    *fpw; /*ϥե빽¤*/
static iconv_t *icid;
static char *inEnc1=NULL; /*ܤΥեΥ󥳡ǥ*/
static char *inVer1=NULL; /*ܤΥեΥС*/
static char *inEncN=NULL; /*ܰʹߤΥեΥ󥳡ǥ*/
static char *inVerN=NULL; /*ܰʹߤΥեΥС*/
static int  procFileNo=-1;/*߽Υեֹ(ܤΥեǧ뤿)*/
static struct mssXmlTag *rootTag;

/*----------------------------------------------------------------------------*/
/* 롼ȥ̾                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optRTG={
    OSTR,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL  , /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    256,    /* ʸκĹ                                               */
    RTGT,   /* ΥץΥȥ(Helpɽ)                         */
    RTGC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    256,    /* ǽκե                                     */
    1,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optRTG,&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* ¤                                                                     */
/*----------------------------------------------------------------------------*/
/* -f ̾¤ */
/* ex) -f rec@id:recID */
struct XmlFld {
  int   cnt;               /*ܿ         */
  char *eleNamOrg[MssFieldMaxCnt]; /*̾ (rec)   */
  char *attNamOrg[MssFieldMaxCnt]; /*°̾ (id)    */
  char *newNamOrg[MssFieldMaxCnt]; /*̾(recID)*/
  char *eleNam[MssFieldMaxCnt];    /*̾UTF8     */
  char *attNam[MssFieldMaxCnt];    /*°̾UTF8     */
  char *newNam[MssFieldMaxCnt];    /*̾UTF8   */
  int   keyNum[MssFieldMaxCnt];    /*-kǤꤵƤСֹ*/
};

struct XmlKey {
  char *namOrg[MssFieldMaxCnt];
  char *nam[MssFieldMaxCnt];
  int   on[MssFieldMaxCnt];
  int   allKeyIsOn;
  int   cnt;
};

typedef struct _XmlState {
  int level;
  int crFlg;
} XmlState;

/*----------------------------------------------------------------------------*/
/* SAX ϥɥ顼                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){

  procFileNo++; /*ΥեֹUP*/

  /*ܤΥեXML*/
  if(procFileNo==0){
    inEnc1=mssStrdup((char *)ctxt->input->encoding);
    inVer1=mssStrdup((char *)ctxt->version);
    mssWriteXmlDeclaration( inVer1, inEnc1, fpw );
    if(inEnc1==NULL) inEnc1=mssStrdup("UTF-8");

    /*Ϥiconvץ*/
    icid=iconv_open(inEnc1,"UTF-8");
    if((int)icid==-1){
      mssShowErrMsg("encoding type error in iconv_open");
      mssEnd(mssErrorNoDefault);
    }

  /*ܰʹߤΥեXMLܤ*/
  }else{
    mssFree(inEncN);
    mssFree(inVerN);
    inEncN=mssStrdup((char *)ctxt->input->encoding);
    inVerN=mssStrdup((char *)ctxt->version);
    if(inEncN==NULL) inEncN=mssStrdup("UTF-8");
    if( 0!=strcmp(inVer1,inVerN) ){
      mssShowErrMsg("different xml version on %s",ctxt->input->filename);
      mssEnd(mssErrorNoDefault);
    }
    if( 0!=strcmp(inEnc1,inEncN) ){
      mssShowErrMsg("different xml encoding on %s",ctxt->input->filename);
      mssEnd(mssErrorNoDefault);
    }
    /*Ϥiconvץ*/
    icid=iconv_open(inEncN,"UTF-8");
    if((int)icid==-1){
      mssShowErrMsg("encoding type error in iconv_open");
      mssEnd(mssErrorNoDefault);
    }
  }
}

void end_doc(XmlState *state){
  if(icid!=NULL) iconv_close(icid);
}

/* start */
void start_element(XmlState *state, char *fullname, char **atts){

  struct mssXmlTag *xmlTag;
  int i;

  mssGV.inCnt++;

  if(state->level==0){
    if(!optRTG.set){
      if(!procFileNo==0){
        if(0!=strcmp(rootTag->element,fullname)){
          mssShowErrMsg("different root tag [%s] in %s",
                                              fullname,ctxt->input->filename );
          mssEnd(mssErrorNoDefault);
        }
        state->level++;
        return;
      }else{
        rootTag=mssInitXmlTag(fullname,NULL);
      }

    /*롼ȥꤵƤ*/
    }else{
      if(procFileNo==0){
        mssWriteXmlStartTag(rootTag,icid,fpw);
        mssGV.outCnt++;
        state->crFlg=1;
        state->level++;
      }
    }
  }

  if(state->crFlg){
    mssWriteRet(fpw);
    state->crFlg=0;
  }
  mssWriteXmlIndent(state->level,fpw);

  xmlTag=mssInitXmlTag(fullname,NULL);
  if(atts!=NULL){
    for(i=0;;i++){
      if(*(atts+2*i+0)==NULL) break;
      if(*(atts+2*i+1)==NULL) break;
      mssAddXmlTagAttributeStr(xmlTag,*(atts+2*i),*(atts+2*i+1),NULL);
    }
  }
  mssWriteXmlStartTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  mssGV.outCnt++;
  state->level++;
}

/* end */
void end_element(XmlState *state, char *fullname, char **atts){

  struct mssXmlTag *xmlTag;

  state->level--;

  /* 롼ȥ & add & ǸΥեǤʤ */
  if(state->level==0){
    if(!optRTG.set){
      if(procFileNo!=optINF.cnt-1){
        return;
      }
    }
  }

  if(state->crFlg){
    mssWriteRet(fpw);
    mssWriteXmlIndent(state->level,fpw);
    state->crFlg=0;
  }
  xmlTag=mssInitXmlTag(fullname,NULL);
  mssWriteXmlEndTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  if(optRTG.set){
    if(state->level==1){
      mssWriteRet(fpw);
      if(procFileNo==optINF.cnt-1){
        mssWriteXmlEndTag(rootTag,icid,fpw);
        mssWriteRet(fpw);
        state->level--;
      }
    }
  }else{
    if(state->level==0){
      mssWriteRet(fpw);
    }
  }
}

void start_characters(XmlState *state, xmlChar *chars, int len){
  char *tmp;

  switch(*chars){
  case '\n':
    state->crFlg=1; break;
  case '&':
    mssWriteStr("&amp;",fpw); break;
  case '>':
    mssWriteStr("&gt;",fpw); break;
  case '<':
    mssWriteStr("&lt;",fpw); break;
  case '\'':
    mssWriteStr("&apos;",fpw); break;
  case '"':
    mssWriteStr("&quot;",fpw); break;
  default:
    tmp=mssNencoding(chars,len,icid);
    mssWriteStr(tmp,fpw);
    mssFree(tmp);
  }
}

void start_cdata(XmlState *state, xmlChar *chars, int len){
  char *tmp;

  mssWriteStr("<![CDATA[",fpw);
  tmp=mssNencoding(chars,len,icid);
  mssWriteStr(tmp,fpw);
  mssFree(tmp);
  mssWriteStr("]]>",fpw);
}

static xmlEntityPtr get_entity( XmlState *ctx, xmlChar *name){
  return xmlGetPredefinedEntity(name);
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    (getEntitySAXFunc) get_entity, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
    (cdataBlockSAXFunc)start_cdata,
};

int main(int argc, char *argv[]){

  XmlState         *state;
  int i;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  /*Υ̾°̾UTF-8ѴƳǼ*/
  if(optRTG.set){
    icid=iconv_open("UTF-8",MssXmlDefEnc);
    if((int)icid==-1) {
      mssShowErrMsg("encoding type error in -E");
      mssEnd(mssErrorNoDefault);
    }

    rootTag=mssOpt2XmlTag(optRTG.str,icid);
    //rootTag=mssOpt2XmlTag(optRTG.str,NULL);

    if(icid!=NULL) iconv_close(icid);
  }

  /*ɸϥץ*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
//mssWriteXmlStartTag(rootTag,NULL,fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/

  state=mssCalloc(sizeof(XmlState),"xml2xt");
  for(i=0; i<optINF.cnt; i++){

    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(*(optINF.strList+i));
    if(!ctxt){
      mssShowErrMsg("not xml file");
      mssEnd(mssErrorNoDefault);
    }
    ctxt->sax=&SAXFunctions;

    ctxt->userData=state;
    xmlParseDocument(ctxt);
    ctxt->sax=NULL;
    xmlFreeParserCtxt(ctxt);
  }

  mssFree(inEnc1);
  mssFree(inVer1);
  mssFree(inEncN);
  mssFree(inVerN);
  mssFree(state);
  mssFreeXmlTag(rootTag);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);       /*ϥեΥ   */
  mssFreeOption(opt);     /*ץΰ賫       */
  mssShowEndMsg();        /*λå           */
  mssEnd(mssExitSuccess); /*λ                     */
  return(0);              /* to avoid warning message*/
}
