/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб(2003/06)                                             */
/*============================================================================*/
  
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <regex.h>

#include <xml2xtHelp.h>
struct mssComHelp comHelp={
  "xml2xt",       /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */                                    
  HELPS,          /*              */
  HELPE,          /*              */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvǻȤʸĹ*/

/*----------------------------------------------------------------------------*/
/* ¤                                                                     */
/*----------------------------------------------------------------------------*/

/* -f ̾¤                                      */
/* ex) -f rec@id:recID                                  */
/*        ǥѥ@°̾%ץ:̾           */
/* data/rec@id%f:recID,/a/b@id%n:keyID                  */
/*   eleNam[0][0]="data",[0][1]="rec",[0][2]=NULL       */
/*   attNam[0]="id"                                     */
/*   optNam[0][0]='f',[0][1]=0                          */
/*   newNam[0]="recID"                                  */
/*                                                      */
/*   eleNam[1][0]="/",[1][1]="a",[1][2]="b",[1][3]=NULL */
/*   attNam[1]="id"                                     */
/*   optNam[1][0]='f',[1][1]=0                          */
/*   newNam[1]="keyID"                                  */

struct XmlFld {
  int   cnt;                       /*ܿ         */
  char *element[MssFieldMaxCnt];   /*̾UTF8     */
  char *attribute[MssFieldMaxCnt]; /*°̾UTF8     */
  char  option[MssFieldMaxCnt];    /*ץ t:ƥ,f:ե饰,n:̾ */
  char *field[MssFieldMaxCnt];     /*̾UTF8   */
 };


struct XmlKey {
  char    **path;  /*-kǻꤵ줿ޤǶڤ줿ʸ*/
  regex_t  *regex; /*ʸɽ˥ѥ뤷*/
  int       cnt;   /*Ǥο*/
};

typedef struct _XmlState {
  int level;            /* ߽NodeΥ٥(rootNode=0) */
}XmlState;

/*----------------------------------------------------------------------------*/
/* Хѿ                                                             */
/*----------------------------------------------------------------------------*/
extern xmlParserCtxtPtr ctxt;
extern struct mssGlobalVariables mssGV;

static struct mssFPW    *fpw; /*ϥե빽¤*/
static struct mssHeader *hdo; /*ϥե<head>Ǽ¤*/
static iconv_t *icid;   /*iconv Ѵϥɥ*/
static char *inEnc=NULL; /*󥳡ǥ*/
static char *inVer=NULL; /*С*/
static char currentPath[4096]; /*߽Υѥ (/a/b/c/)*/
static char *inKeyStartPath=NULL; /*-kǻꤷѥθ߽Хѥ*/
static int inKey;/*߽Ǥ-kǻꤷ줫ΥѥäƤ뤫*/
static int inFldNo[MssFieldMaxCnt];/*߽-fֹ*/
static char   fldDat[MssFieldMaxCnt][MssFieldMaxLen];/*-fǻꤵ줿ƹܤμºݤ*/
static struct XmlKey *key;
static struct XmlFld *fld;


/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* Ԥñ̤ȤʤXMLΥѥ̾                                            */
/*----------------------------------------------------------------------------*/
  MssOptSTR optKEY={
    OSTR,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    256,    /* ʸκĹ                                               */
    KEYT,   /* ΥץΥȥ(Helpɽ)                         */
    KEYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϤܤΥ̾                                                       */
/*----------------------------------------------------------------------------*/
  MssOptSTR optFLD={
    OSTR,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL  , /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    1024,   /* ʸκĹ                                               */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* space򲿤Ѵ뤫                                                      */
/*----------------------------------------------------------------------------*/
  MssOptSTR optSPC={
    OSTR,   /* ץ󥿥                                             */
    "S",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "_",    /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    1,      /* ʸκĹ                                               */
    SPCT,   /* ΥץΥȥ(Helpɽ)                         */
    SPCC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optKEY,&optFLD,&optSPC,&optINF,&optOTF,&optZIP,NULL};
    
/*----------------------------------------------------------------------------*/
/* -k Υȡʬ+encoding                                                 */
/*----------------------------------------------------------------------------*/
static void setXmlKey(void){
  int i;
  char *pos;
  char *keyPos[MssFieldMaxCnt];

  key=mssCalloc(sizeof(struct XmlKey),"setXmlKey");
  if(optKEY.set){

    /* ޤˤȡʬ */
    i=0;
    pos = strtok(optKEY.str,",");
    while(pos!=NULL){
      keyPos[i++]=pos;
      pos=strtok(NULL,",");
    }
    key->cnt=i;

    /* encoding path˥å */
    key->path=mssCalloc(sizeof(char *),"xml2xt");
    for(i=0; i<key->cnt; i++){
      *(key->path+i)=mssEncoding(keyPos[i],icid);
    }
  }else{
    key->path=NULL;
  }

  key->regex=mssCalloc(sizeof(regex_t)*key->cnt,"xml2xt");
  for(i=0; i<key->cnt; i++){
    if( regcomp(key->regex+i,*(key->path+i),REG_EXTENDED) ){
      mssShowErrMsg("error in compiling regex");
      mssEnd(mssErrorNoDefault);
    }
  }
}

static void freeXmlKey(struct XmlKey *key){
  int i;
  if(key!=NULL){
    for(i=0; i<key->cnt; i++){
      if(*(key->path+i)!=NULL) mssFree(*(key->path+i));
      regfree(key->regex+i);
    }
    mssFree(key->regex);
    mssFree(key->path);
    mssFree(key);
  }
}

/*----------------------------------------------------------------------------*/
/* -f Υȡʬ+encoding                                                 */
/* data/rec@id%f:recID,/a/b@id%n:keyID                                        */
/*----------------------------------------------------------------------------*/
static struct XmlFld *setXmlFld(){
  int i,j;
  char *pos;
  struct XmlFld *fld=NULL;
  char *element[MssFieldMaxCnt];    /*encode̾     */
  char *attribute[MssFieldMaxCnt];  /*encode°̾     */
  char  option[MssFieldMaxCnt];     /*encodeΥץ */
  char *field[MssFieldMaxCnt];      /*encodeο̾   */
  char tmp[4096];

  fld=mssCalloc(sizeof(struct XmlFld),"setXmlFld");

  /*ޤΥȡʬ(̾Ƭɥ쥹򥻥å)*/
  /* data/rec@id%f:recID|/a/b@id%n:keyID              */
  fld->cnt=0;
  pos = strtok(optFLD.str,",");
  while(pos!=NULL){
    if(fld->cnt>=MssFieldMaxCnt){
      mssShowErrMsg("too many fields on -f");
      mssEnd(mssErrorNoDefault);

    }
    element[fld->cnt]=pos;
    fld->cnt++;
    pos=strtok(NULL,",");
  }

  /*ǥȡʬ(̾Υå:strdup)*/
  /* data/rec@id%f|recID|/a/b@id%n|keyID  */
  for(i=0; i<fld->cnt; i++){
    pos=strchr(element[i],':');
    if(pos!=NULL){
      *pos='\0';
      field[i]=mssStrdup(++pos);
    }else{
      field[i]=NULL;
    }
  }

  /*%ǥȡʬ(ץΥå)  */
  /* data/rec@id|f|recID|/a/b@id|n|keyID  */
  for(i=0; i<fld->cnt; i++){
    j=0;
    pos = strchr(element[i],'%');
    if(pos!=NULL){
      *pos='\0';
      option[i]=*(++pos);
    }else{
      option[i]=0;
    }
  }

  /*ʳǿ̾ꤵƤʤС
    ̾+°̾򿷹̾ȤϿ*/
  for(i=0; i<fld->cnt; i++){
    if(field[i]==NULL){
      field[i]=mssStrdup(element[i]);
    }
  }

  /*@ǥȡʬ(°̾Υå)*/
  /* data/rec|id|f|recID|/a/b|id|n|keyID  */
  for(i=0; i<fld->cnt; i++){
    pos=strchr(element[i],'@');
    if(pos!=NULL){
      *pos='\0';
      attribute[i]=++pos;
    }else{
      attribute[i]=NULL;
    }
  }

  /*-----------------------------------*/
  /*UTF8ؤencoding + ¤ΤؤΥå*/
  /*-----------------------------------*/
  for(i=0; i<fld->cnt; i++){

    /**/
    /* ǤκǸ"/"ä */
    if(*(element[i]+strlen(element[i])-1)!='/'){
      strcpy(tmp,element[i]);
      strcat(tmp,"/");
    }else{
      strcpy(tmp,element[i]);
    }
    fld->element[i]=mssEncoding(tmp,icid);

    /*°*/
    fld->attribute[i]=mssEncoding(attribute[i],icid);

    /*ѥ᡼*/
    fld->option[i]=option[i];

    /*̾*/
    fld->field[i]=mssEncoding(field[i],icid);
  }

  for(i=0; i<fld->cnt; i++){
    mssFree(field[i]);
  }

  return(fld);
}

static void freeXmlFld(struct XmlFld *fld){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(fld->element[i]  !=NULL) mssFree(fld->element[i]);
    if(fld->attribute[i]!=NULL) mssFree(fld->attribute[i]);
    if(fld->field[i]    !=NULL) mssFree(fld->field[i]);
  }
  if(fld!=NULL)mssFree(fld);
}

static void writeEncStr(char *str){
  char *buf;

  if( str!=NULL && *str!='\0') {
    buf=mssEncoding(str,icid);
    mssWriteStr(buf,fpw);
    if(buf!=NULL && buf!=str) mssFree(buf);
  }else{
    mssWriteStr("*",fpw);
  }
}

/*ΥڡʤΥڡʸѴ*/
/*ʸ֤ѤΤfreeϤǤʤΤ*/
static char *chgSpc(char *str){
  int len;
  char *pos;

  if(str==NULL) return(NULL);

  /*Υڡʸʤ*/
  while(*str!='\0'){
    if(!isspace(*str)) break;
    str++;
  }
  len=strlen(str);
  if(len<=0) return(NULL);

  /*Υڡʸʤ*/
  pos=str+strlen(str)-1;
  while(1){
    if(!isspace(*pos)) break;
    *pos='\0';
    pos--;
  }

  /*ڡѴ*/
  pos=str;
  while(*pos!='\0'){
    if( isspace(*pos) ) *pos=*optSPC.str;
    pos++;
  }
  return(str);
}
 
/*fldDat*/
static void printDat(XmlState *state){
  int fn;

  for(fn=0; fn<fld->cnt-1; fn++){
    writeEncStr(chgSpc(fldDat[fn]));
    mssWriteDlm(fpw);
  }
    writeEncStr(chgSpc(fldDat[fn]));
    mssWriteRet(fpw);
  mssGV.outCnt++;
}

/*fldDat򥯥ꥢ*/
static void clearFldDat(XmlState *state){
  int i;

  for(i=0; i<fld->cnt; i++){
    /*Хѥ()ιܤϥꥢʤ*/
    if(*fld->element[i]!='/') fldDat[i][0]='\0';
  }
}

void Strncpy(char *to, char *from, int len){
  int i,j;

  i=0;
  for(j=0; j<len; j++){
    *(to+i)=*(from+j);
    if((++i)>=MssFieldMaxLen-1) {
      mssShowErrMsg("exceed maximum length of field");
      mssEnd(mssErrorNoDefault);
    }
  }
  *(to+i)='\0';
}

void Strncat(char *to, char *from, int len){
  int i,j;

  i=strlen(to);
  for(j=0; j<len; j++){
    *(to+i)=*(from+j);
    if((++i)>=MssFieldMaxLen-1) {
      mssShowErrMsg("exceed maximum length of field");
      mssEnd(mssErrorNoDefault);
    }
  }
  *(to+i)='\0';
}

/*----------------------------------------------------------------------------*/
/* SAX ϥɥ顼                                                             */
/*----------------------------------------------------------------------------*/
/*############## start_doc */
void start_doc(XmlState *state){
  int i;

  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  if(inEnc==NULL) inEnc=mssStrdup("UTF-8");

  /*ѥ᡼Ѥiconvץ                                   */
  /*xmlޥɤΥѥ᡼ϥǡϥǡencoding     */
  /*ơϥǡΥ󥳡ǥ󥰤ȤʤȤ˺롣*/
  icid=iconv_open("UTF-8",inEnc);
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /* -k,-f ѥ᡼Υå+UTF-8Ѵ */
  setXmlKey();
  fld=setXmlFld(key);

  /*ѥ᡼Ѥiconv*/
  if(icid!=NULL) iconv_close(icid);

  /*Ϥiconvץ*/
  icid=iconv_open(inEnc,"UTF-8");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /*ϥإåκȽ   */
  hdo=mssInitHeader(NULL,NULL);
  for(i=0; i<fld->cnt; i++){
    mssAddFieldsByStr( hdo->flds, mssEncoding(fld->field[i],icid) );
  }

  /*xmlTableإåν񤭽Ф*/
  mssWriteHeader(hdo, fpw);

  /* currentPathν */
  currentPath[0]='/';
  currentPath[1]='\0';

  for(i=0; i<fld->cnt; i++){
    inFldNo[i]=0;
  }
}

/*############## end_doc */
void end_doc(XmlState *state){
  /*Ѥiconv*/
  if(icid!=NULL) iconv_close(icid);
}

/*-kΥäʤ1֤¾0*/
static int isInKey(void){
  int i;
  for(i=0; i<key->cnt; i++){
    /*0ǥޥå*/
    if(0==regexec(key->regex+i,currentPath,0,NULL,0)) return(1);
  }
  return(0);
}

/*----------------------------------------------*/
/*-fǤäʤСǤֹ֤*/
/* inFldNo[]ƤϤޤֹ򥻥åȤ    */
/* inFldCntˤιܿ򥻥åȤ롣           */
/*----------------------------------------------*/
static void setInFld(){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(*fld->element[i]=='/'){ /* ----- Хѥξ ( -f /a/b ) */
      if(currentPath!=NULL){
        if(0==strcmp(currentPath,fld->element[i])){
          inFldNo[i]=1;
        }
      }
    }else{                     /* ----- Хѥξ ( -f a/b ) */
      if(inKeyStartPath!=NULL){
        if(0==strcmp(inKeyStartPath,fld->element[i])){
          inFldNo[i]=1;
        }
      }
    }
  }
}

static void unsetInFld(){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(*fld->element[i]=='/'){ /* ----- Хѥξ ( -f /a/b ) */
      if(currentPath!=NULL){
        if(0==strcmp(currentPath,fld->element[i])){
          inFldNo[i]=0;
        }
      }
    }else{                     /* ----- Хѥξ ( -f a/b ) */
      if(inKeyStartPath!=NULL){
        if(0==strcmp(inKeyStartPath,fld->element[i])){
          inFldNo[i]=0;
        }
      }
    }
  }
}

static char *getAttVal(char *attName, char **atts) {
  int i;

  if(atts==NULL || attName==NULL) return(NULL);

  i=0;
  while(1){
    if( *(atts+i)==NULL ) return(NULL);
    if( 0==strcmp(attName,*(atts+i)) ){
      return(*(atts+i+1));
    }
    i=i+2;
  }
}

/*############## start_element */
void start_element(XmlState *state, char *fullname, char **atts){
  char *attVal;
  int prvInKey=inKey;

  int i;

  mssGV.inCnt++;

  /*ߤΥΡɥѥ򹹿*/
  strcat(currentPath,fullname);
  strcat(currentPath,"/");

  /*-kΥäɤ*/
  inKey=isInKey();

  /*ƥä γʸ֤򥻥å*/
  if(prvInKey==0 && inKey==1){
    inKeyStartPath=currentPath+strlen(currentPath);
  }

  /*-fǻꤷɤǤäƤ뤫*/
  setInFld();

  for(i=0; i<fld->cnt; i++){
    if(inFldNo[i]){
      /*°ܤξ(<a id="aaa">)*/
      if(fld->attribute[i]!=NULL){
        attVal=getAttVal(fld->attribute[i],atts);
        if( attVal!=NULL ){
          switch(fld->option[i]){
          case 'f': /*ե饰*/
            fldDat[i][0]='1';
            fldDat[i][1]='\0';
            break;
          case 'n': /*̾(̾+°̾)*/
            Strncpy(fldDat[i],currentPath,strlen(currentPath));
            fldDat[i][strlen(currentPath)-1]='\0'; /*Ǹ"/"ä*/
            Strncat(fldDat[i],"@",1);
            Strncat(fldDat[i],fld->attribute[i],strlen(fld->attribute[i]));
            break;
          default: /*ƥ(ǥե)*/
            Strncpy(fldDat[i],attVal,strlen(attVal));
            break;
          }
        }

      /*ǻܤξ(<a>)*/
      }else{
        switch(fld->option[i]){
        case 'f': /*ե饰*/
          fldDat[i][0]='1';
          fldDat[i][1]='\0';
          break;
        case 'n': /*̾(̾+°̾)*/
          Strncpy(fldDat[i],currentPath,strlen(currentPath));
          fldDat[i][strlen(currentPath)-1]='\0'; /*Ǹ"/"ä*/
          break;
        default: /*ƥ(ǥե)*/
          /*ƥȻξ(<a>text</a>)characerˤƥåȤ*/
          /*ƱǤФ褿ȤΤˡΥǡ򥯥ꥢ*/
          fldDat[i][0]='\0'; /*Ǹ"/"ä*/
          break;
        }
      }
    }
  }
  state->level++;
}

/*############## end_element */
void end_element(XmlState *state, char *fullname, char **atts){
  int prvInKey=inKey;
  char *pos;

  unsetInFld();

  state->level--;

  /*ߤΥΡɥѥ򹹿*/
  pos=currentPath+strlen(currentPath)-2;
  while(*pos!='/') pos--;
  *(++pos)='\0';

  /*end_elementǥФʤ*/
  inKey=isInKey();
  if(prvInKey==1 && inKey==0){
    /*Ф γʸ֤NULL˥å*/
    inKeyStartPath=NULL;
    /*ǡ*/
    printDat(state);
    clearFldDat(state);
  }

  /*-fǻꤷɤǤäƤ뤫*/
  /*end_elementǤϡƥȻܤλΤߡĴ*/

}

/*############## start_characters */
void start_characters(XmlState *state, xmlChar *chars, int len){
  int i;

  for(i=0; i<fld->cnt; i++){
    if(inFldNo[i]){
      /*°ǤʤǤξ*/
      if(fld->attribute[i]==NULL){
        /*%n,%fǤʤ*/
        if(fld->option[i]==0){
          /* fldDat[i][0]='\0'; start_elementǥꥢѹ*/
          Strncat(fldDat[i],chars,len);
        }
      }
    }
  }
}

/*sax error handler*/
#include "saxerror.h"

void xmlSaxErrEndLocal(void *ctx, const char *msg, ...){
  
  XmlState *dummy=NULL;

  if(0==strncmp(msg,"Document is empty",17)){
    
    ctxt->input->encoding=MssXmlDefEnc;
    start_doc(dummy);
    mssWriteFooter(fpw);
    mssCloseFPW(fpw);
    mssShowEndMsg();
    mssEnd(mssExitSuccess);
  }else{
     xmlSaxErrEnd(ctx, msg);
  }
}


static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEndLocal, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEndLocal, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEndLocal, /* xmlParserError */
    NULL, /* getParameterEntity */
    NULL,
};


int main(int argc, char *argv[]){

  XmlState      *state;

  char *tmp;
  char *fname;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp); /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                       */
  mssSetOption(opt,argc,argv);    /* ޥɥץ     */

/*prnOption(opt);*/

  tmp=optSPC.str;
  while(*tmp!='\0'){
    if(isspace(*tmp++)) {
      mssShowErrMsg("can't use space character in -s option");
      mssEnd(mssErrorNoDefault);
    }
  }

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*ɸϥץ*/

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  state=mssCalloc(sizeof(XmlState),"xml2xt");
  state->level = 0;

  if(optINF.set){
    fname=optINF.str;
  }else{
    fname="/dev/stdin";
  }

  ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(fname);
  if(!ctxt){
    fprintf(stderr,"not xml\n");
  }
  ctxt->sax=&SAXFunctions;
  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

  freeXmlKey(key);
  freeXmlFld(fld);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν*/
  mssCloseFPW(fpw);       /*ϥեΥ*/
  mssFreeHeader(hdo);     /*ϥإåΰ賫*/
  mssFreeOption(opt);     /*ץΰ賫*/
  mssShowEndMsg();        /*λå*/
  mssEnd(mssExitSuccess); /*λ*/
  return(0); /* to avoid warning message*/
}
