
#ifndef __MSSOPTION_H
#define __MSSOPTION_H 1

#include <mssBase.h>

/**
 * # ENUM #
 * ޥɥץη
 */
enum OptType {
  OSTR, /*ʸ      */
  OSEL, /*ʸ  */
  OSLS, /*ʸꥹȷ*/
  OINT, /*int         */
  OILS, /*intꥹȷ   */
  ORNG, /*intϰϷ     */
  ODBL, /*double      */
  ODLS, /*doubleꥹȷ*/
  OINF, /*ϥե뷿*/
  OOTF, /*ϥե뷿*/
  OFLD, /*ܷ        */
  OKEY, /*keyܷ     */
  OFLG  /*ե饰      */
};

/**
 * # STRUCT #
 * ʸ
 */
struct OptSTR {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *def;     /*ǥե*/
  int           minLen;  /*ǤκǾʸ*/
  int           maxLen;  /*Ǥκʸ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/

  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptSTR MssOptSTR;

/**
 * # STRUCT #
 * ʸ
 */
struct OptSEL {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *def;     /*ǥե*/
  char         *selList; /*ʸꥹ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/
  char         *selListTitle; /*ʸꥹȥȥ*/

  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
} OptSEL;

/**
 * # TYPEDEF #
 */
typedef struct OptSEL MssOptSEL;

/**
 * # STRUCT #
 * ʸ
 */
struct OptSLS {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *def;     /*ǥե*/
  int           maxCnt;  /*ꥹǤκ*/
  int           minLen;  /*ǤκǾʸ*/
  int           maxLen;  /*Ǥκʸ*/
  int           colFlg;  /*⥳ǽե饰 ex) abc:xyz*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/

  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  char        **strList; /*ºݤ*/
  char        **colList; /*⥳ʲʸ*/
  int           cnt;     /*ꥹȤθĿ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptSLS MssOptSLS;

/**
 * # STRUCT #
 * 
 */
struct OptINT {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  int           def;     /*ǥե*/
  int           min;     /*ǤκǾ*/
  int           max;     /*Ǥκ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/

  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  int           val;     /*ºݤ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptINT MssOptINT;

/**
 * # STRUCT #
 * ꥹȷ
 */
struct OptILS {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *def;     /*ǥե(ʸ)*/
  int           maxCnt;  /*ꥹǤκ*/
  int           min;     /*ǤκǾ*/
  int           max;     /*Ǥκ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/

  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  int          *val;     /*ºݤ*/
  int           cnt;     /*ꥹȤθĿ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptILS MssOptILS;

/**
 * # STRUCT #
 * ϰϷ
 */
struct OptRNG {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *def;     /*ǥե(ʸ)*/
  int           maxCnt;  /*ꥹǤκ*/
  int           min;     /*ǤκǾ*/
  int           max;     /*Ǥκ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/

  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  int          *from;    /*ºݤͥꥹ(from)*/
  int          *to;      /*ºݤͥꥹ(to)*/
  int           cnt;     /*ꥹȤθĿ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptRNG MssOptRNG;

/**
 * # STRUCT #
 * ¿
 */
struct OptDBL {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  double        def;     /*ǥե*/
  double        min;     /*ǤκǾ*/
  double        max;     /*Ǥκ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/
  
  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  double        val;     /*ºݤ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptDBL MssOptDBL;

/**
 * # STRUCT #
 * ¿ꥹȷ
 */
struct OptDLS {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *def;     /*ǥե(ʸ)*/
  int           maxCnt;  /*ꥹǤκ*/
  double        min;     /*ǤκǾ*/
  double        max;     /*Ǥκ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/
  
  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  double       *val;     /*ºݤ*/
  int           cnt;     /*ꥹȤθĿ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptDLS MssOptDLS;

/**
 * # STRUCT #
 * ϥե뷿
 */
struct OptINF {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  int           maxCnt;  /*ꥹǤκ*/
  int           fnf;     /*1:file not foundΥ顼ǽλʤ 0:*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/
  
  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  char        **strList; /*ºݤ*/
  int           cnt;     /*ꥹȤθĿ*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptINF MssOptINF;

/**
 * # STRUCT #
 * ϥե뷿
 */
struct OptOTF {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           must;    /*ɬܥե饰*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/
  
  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptOTF MssOptOTF;

/**
 * # STRUCT #
 * ե饰
 */
struct OptFLG {
  enum OptType  type;    /*ץ󥿥*/
  char         *keyWord; /*ʸ*/
  int           def;     /*Ūˤset(1). onˤȤΰ*/
  char         *title;   /*ѥ᡼ȥ*/
  char         *comment; /*ѥ᡼*/
  
  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
};

/**
 * # TYPEDEF #
 */
typedef struct OptFLG MssOptFLG;

/**
 * # STRUCT #
 * ܷ
 */
struct OptFLD {
  enum OptType  type;        /*ץ󥿥*/
  char         *keyWord;     /*ʸ*/
  int           must;        /*ɬܥե饰*/
  int           maxCnt;      /*ꥹǤκ(ɽŸ)*/
  char         *inKeyWord;   /*оݤȤϥǡΥ(GUI)*/
  int           globFlg;     /*磻ɥɵĥե饰*/
  int           newFlg;      /*̾λǽե饰*/
  char         *fldOptSel;   /*ܥץ*/
  char         *title;       /*ѥ᡼ȥ*/
  char         *comment;     /*ѥ᡼*/
  char         *fldOptTitle; /*ܥץ*/
  
  int           set;     /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;     /*ץʸ:argvstrdup*/
  char        **nam;     /*̾ꥹ*/
  char        **newNam;  /*̾ꥹ(꤬ʤnamƱ)*/
  char        **fldOpt;  /*ܥץꥹ(꤬ʤNULL)*/
  int           cnt;     /*ꥹȤθĿ*/

  struct mssFields *flds;
  int *fldNo2optNo;

};

/**
 * # TYPEDEF #
 */
typedef struct OptFLD MssOptFLD;

/**
 * # STRUCT #
 * ܷ
 */
struct OptKEY {
  enum OptType  type;      /*ץ󥿥*/
  char         *keyWord;   /*ʸ*/
  int           must;      /*ɬܥե饰*/
  int           maxCnt;    /*ꥹǤκ(ɽŸ)*/
  char         *inKeyWord; /*оݤȤϥǡΥ(GUI)*/
  int           def;       /*1:diff,2:same */
  char         *title;     /*ѥ᡼ȥ*/
  char         *comment;   /*ѥ᡼*/
  
  int           set;       /*ޥɥ饤ǻꤵ줿ե饰*/
  char         *str;       /*ץʸ:argvstrdup*/
  char        **nam;       /*̾ꥹ*/
  int           diffSame;  /*0:-kλͭ,1:diff,2:same*/
  int           cnt;       /*ꥹȤθĿ*/

  struct mssFields *flds;
  int *fldNo2optNo;
};

/**
 * # TYPEDEF #
 */
typedef struct OptKEY MssOptKEY;


/**
 * # PROTOTYPE # 
 */
void	mssHelpDoc(void *opt[],struct mssComHelp *comHelp, int argc, char **argv);
void	mssFreeOption(void *opt[]);
void	mssSetOption(void *opt[], int argc, char *argv[]);
void	mssShowOption(void *opt[]);
int	mssIsFldOptOn(MssOptFLD *optFld,int i, char c );
void	mssCpyOptKey(MssOptKEY *to,MssOptKEY *from);
int	mssIsInRange(MssOptRNG *optRNG,int val);

#endif /* _OPTION_H */

