
/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/06/20                                           */
/*============================================================================*/
#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtbucketHelp.h>
struct mssComHelp comHelp={
  "xtbucket",     /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*              */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;

#define MALLOC_CNT 1000

struct ctbl { /*count table*/
  double Val;
  unsigned long Cnt;
};

struct kTbl { /*k-cluster table*/
           double minVar;
  unsigned long prvNo;
  unsigned long from;
  unsigned long to;
};

struct rTbl { /*range table*/
  double from;
  double to;
};

static struct ctbl *cTable;       /*ͤȤηä*/
static long         cTableCnt;    /*cTableϿƤ*/
static long         cTableMaxCnt; /*cTableϿǽ(malloc)*/

static struct kTbl   *kTable;
static struct rTbl   *rTable;
static unsigned long *sTable;
static struct rTbl   **rTables;

int cutCnt; /*ºݤʬ*/

void insertValue(
  double value,	/**/
  int    start	/*륹Ȱ*/
                 ){
  int i;

  /*ꥪСΥꥢMALLOC_CNTñ̤ */
  if( cTableCnt >= cTableMaxCnt) {
    cTableMaxCnt+=MALLOC_CNT;
    cTable = (struct ctbl *)mssRealloc(cTable,
                             cTableMaxCnt * sizeof(struct ctbl),"xtbucket");
  }

  for(i=cTableCnt-1; i>=start; i--){
    (cTable+i+1)->Val = (cTable+i)->Val;
    (cTable+i+1)->Cnt = (cTable+i)->Cnt;
  }
  (cTable+start)->Val = value;
  (cTable+start)->Cnt = 1;
  cTableCnt++;
}

void setCntTable(char *str){
  /*Хʥꥵõ륹Ȱ֤ȥɰ֤Ȥ*/
  double value; /*ơ֥˥åȤ*/
  int start;
  int end;
  int try=0;

  if(MssIsNull(str))return;

  value=atof(str);
  /*õƱͤơ֥˸ĤХȥå*/
  /*Ĥʤstartΰ֤ˤͤ*/
  start=0;
  end=cTableCnt-1;
  while(start<=end){
    try=(start+end)/2;
    if((cTable+try)->Val > value) {
      end=try-1;
    } else if((cTable+try)->Val < value) {
      start=try+1;
    } else {
      (cTable+try)->Cnt++;
      return;
    }
  }
  /*õǸĤʤФͤơ֥˿Ͽ*/
  insertValue(value, start);
  return;
}


/*----------------------------------------------------------------------------*/
/*ǡΥؤΥå
cTable[i]˥åȤ if=ǻꤷֹ򣰤֤˳꿶äֹ
                        ex)f=2,5ξ cTable[0]2,cTable[1]5
cTable[i]mallocǳݤ줿ΰƬɥ쥹åȤ롣
ΰϼι¤ΤΥǡ¤
double Val;        
unsigned long Cnt; ͤνи
*/
/*----------------------------------------------------------------------------*/
struct ctbl *setcTable(struct mssFldRecKey *frk,int fldNo){
/*  int i;*/

  cTableMaxCnt=MALLOC_CNT;
  cTable =NULL;
  cTable =(struct ctbl *)mssCalloc(cTableMaxCnt*sizeof(struct ctbl),"xtbucket");

  mssSeekTopFRK(frk);
  while( EOF != mssReadFldRecFRK(frk) ){
    /*ܤͤ򥻥åȤ*/
    setCntTable(*(frk->pnt+fldNo));
  }

/* ǥХåꥹ*/
/*
  for(i=0; i<cTableCnt; i++){
    printf("field[%d] %g - %ld\n",i,(cTable+i)->Val,(cTable+i)->Cnt);
  }
*/
  return(cTable);
}

/*cTableˤơstartendޤǤη¤*/
/*ʬǾϷºǾΤ*/
double calVariance( int start, int end){
  double result=0;
  int i;
  for(i=start; i<=end; i++){
    result+=(cTable+i)->Cnt;
  }
  return(result*result);
}

/*----------------------------------------------------------------------------*/
/* ŬåȥݥȤ                                                 */
/*----------------------------------------------------------------------------*/
/*
Algorithm by N.Katoh
kTableȤϡʬǾ뤿Υơ֥ǰʲΤ褦ʹ¤Ȥ
kTablerTable롣

ʬ 1    2    3    ... k
     1 a(1,1) a(1,2) a(1,3) ... a(1,k)
     2 a(2,1) a(2,2) a(2,3) ... a(2,k)
     3 a(3,1) a(3,2) a(3,3) ... a(3,k)
     .   .      .      .    ...   .
     .   .      .      .    ...   .
     j a(j,1) a(j,2) a(j,3) ... a(j,k)

a(j,k)ˤϼι¤Τ
           double minVar;
  unsigned long prvNo;
  unsigned long from;
  unsigned long to;
minVarϡkĤͤˤĤjʬ䤷ȤκǾʬ
ʬͤѤɬפϤʤñ˷Σͤؤ뤳ȤǤ
prvNoϡjʬξˡǾʬͤĤ褦j-1ʬk
from,toϡjʬξˡǾʬͤĤ褦jܤʬϰϡ

ʬιԤϡºݤˤcTableηΣ¤äƤ
*/
/*----------------------------------------------------------------------------*/
void calOptCutPoint(int cutNum){

  unsigned long   maxCnt;
           double minMinVar=0;
  unsigned long   minPrvNo=0;
  unsigned long   minFrom=0;
  unsigned long   minTo=0;
           double tmpVar;
  struct kTbl *tmpKtbl;
  int j,k,l;

  maxCnt=cTableCnt; /* ͤμ */
  /*kTableꥢ*/
  kTable = (struct kTbl *)mssCalloc(
                          maxCnt*cutNum*sizeof(struct kTbl),"calOptCutP");
  /*sTableꥢ*/
  sTable = (unsigned long *)mssCalloc(
                          maxCnt*sizeof(unsigned long),"calOptCutP");
  /*rTableꥢ*/
  rTable = (struct rTbl *)mssCalloc(
                          cutNum*sizeof(struct rTbl),"calOptCutP");

  /*ͤäƤ*/
  *sTable = cTable->Cnt;
  for(j=1; j<cTableCnt; j++){
    *(sTable+j) = *(sTable+j-1) + (cTable+j)->Cnt;
  }

  /*k=1ξη׻*/
  for(j=0; j<cTableCnt; j++){
    (kTable+j)->minVar = calVariance(0,j);
    (kTable+j)->prvNo  = 0;
    (kTable+j)->from   = 0;
    (kTable+j)->to     = j;
  }

  /*ͤμ⥫åȿ(k=)礭cutCntĴ*/
  cutCnt=cutNum;
  if(cutNum>cTableCnt)cutCnt=cTableCnt;

  /*k=2ʾξη׻*/
  for(j=1; j<cutCnt; j++){ /*j=1ǻϤޤΤkʬ10б*/
    for(k=j; k<cTableCnt; k++){
      minMinVar=DBL_MAX;
      for(l=j-1; l<k; l++){
        tmpVar = (kTable+cTableCnt*(j-1)+l)->minVar +
                 (double)(sTable[k]-sTable[l])*(double)(sTable[k]-sTable[l]);
        /*>ˤСƱξ˸¿*/
        /*>=ˤСƱξ¿*/
        if( minMinVar > tmpVar ){
          minMinVar =tmpVar;
          minPrvNo  =l;
          minFrom   =l+1;
          minTo     =k;
        }
      } /*for l*/
      (kTable+cTableCnt*j+k)->minVar = minMinVar;
      (kTable+cTableCnt*j+k)->prvNo  = minPrvNo;
      (kTable+cTableCnt*j+k)->from   = minFrom;
      (kTable+cTableCnt*j+k)->to     = minTo;
    }/*for k*/
  } /*for j*/

  tmpKtbl=kTable+cutCnt*cTableCnt-1;
  for(j=cutCnt-1; j>=0; j--){
    //(rTable+cutNum+j)->from=(cTable+(tmpKtbl->from))->Val;
    //(rTable+cutNum+j)->to  =(cTable+(tmpKtbl->to  ))->Val;
    (rTable+j)->from=(cTable+(tmpKtbl->from))->Val;
    (rTable+j)->to  =(cTable+(tmpKtbl->to  ))->Val;
    tmpKtbl=kTable+(j-1)*cTableCnt+(tmpKtbl->prvNo);
  }
  /*fromtoȤ*/
  if(cutCnt>1) (rTable+0)->to=((rTable+0)->to+(rTable+1)->from)/2;
  for(j=1; j<cutCnt-1; j++){
    (rTable+j)->from=(rTable+j-1)->to;
    (rTable+j)->to  =((rTable+j)->to+(rTable+j+1)->from)/2;
  }
  (rTable+j)->from=(rTable+j-1)->to;

/* ǥХåꥹ*/
/*
  printf("---- kTable : cnt-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%02d : ",j);
    for(k=0; k<cTableCnt; k++){
      printf("%g ", (kTable+cTableCnt*j+k)->minVar);
    }
    printf("\n");
  }
  printf("---- kTable : from,to-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%02d : ",j);
    for(k=0; k<cTableCnt; k++){
      printf("(%ld,%ld) ", (kTable+cTableCnt*j+k)->from,
                           (kTable+cTableCnt*j+k)->to   );
    }
    printf("\n");
  }
  printf("---- kTable : prvNo-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%02d : ",j);
    for(k=0; k<cTableCnt; k++){
      printf("%ld ", (kTable+cTableCnt*j+k)->prvNo);
    }
    printf("\n");
  }
  printf("---- rTable : prvNo-----\n");
  for(j=0; j<cutCnt; j++){
    printf("%g - %g\n",
    (rTable+j)->from, (rTable+j)->to);
    //(rTable+cutNum+j)->from, (rTable+cutNum+j)->to);
  }
  printf("=============\n");
*/
}

/*
===============================================================================
Main Function
===============================================================================
*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptKEY optKEY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
    KEYT,   /* ΥץΥȥ(Helpɽ)                         */
    KEYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* оݹ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ʬ                                                                     */
/*----------------------------------------------------------------------------*/
  MssOptINT optNUM={
    OINT,   /* ץ󥿥                                             */
    "n",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    0,      /* ǥե(ͤȤƻ)                                   */
    2,      /* Ǿ                                                       */
    255,    /*                                                        */
    NUMT,   /* ΥץΥȥ(Helpɽ)                         */
    NUMC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* Ͻ                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptSEL optFMT={
    OSEL,    /* ץ󥿥                                             */
    "F",     /* (ʣʸԲ)                                   */
    0,       /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "0",     /* ǥե(ʸˤ)                                       */
    "0,1,2",
            /* ǽͥꥹ                                           */
    FMTT,   /* ΥץΥȥ(Helpɽ)                         */
    FMTC,   /* ΥץΥ(Helpɽ)                         */
    FMTS    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* Хåȷ׻ˡ                                                           */
/*----------------------------------------------------------------------------*/
  MssOptSEL optTyp={
    OSEL,    /* ץ󥿥                                             */
    "c",     /* (ʣʸԲ)                                   */
    0,       /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    "cnt",   /* ǥե(ʸˤ)                                       */
    "cnt,rng",
            /* ǽͥꥹ                                           */
    TYPT,   /* ΥץΥȥ(Helpɽ)                         */
    TYPC,   /* ΥץΥ(Helpɽ)                         */
    TYPS    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ֹսե饰                                                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* ץ󥿥                                             */
    "r",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    REVT,   /* ΥץΥȥ(Helpɽ)                         */
    REVC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optKEY,&optFLD,&optNUM,&optFMT,&optTyp,&optREV,
               &optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};

/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdi;     /* ϥե<head>Ǽ¤*/
  struct mssHeader    *hdo;     /* ϥե<head>Ǽ¤*/
  struct mssFPR       *fpr;     /* ϥե빽¤                */
  struct mssFPW       *fpw;     /* ϥե빽¤                */
  struct mssFldRecKey *frk=NULL;/* Хåե¤                */
  struct mssFields    *sf;      /* ȹܹ¤                  */
  int sorted;                   /*Ⱥѥå                 */

  char *vstr;
  double val;
  int num;      /*ϤХåֹ*/
  int *cutCnts; /*μºݤΥХåȿ*/
  char  *bufStr;
  double bufNum;
  double *max;
  double *min;
  double rng;
  int i,j,k;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
  fpr=mssOpenFPR(optINF.str,4);      /* ϥե륪ץ                  */
  hdi=mssReadHeader(fpr);            /* إåɤ߹                      */
  mssSetOptKey(&optKEY, hdi);        /* -k ܤإåܤ˴ϢŤ     */
  mssSetOptFld(&optFLD, hdi);        /* -f ܤإåܤ˴ϢŤ     */
  
  /*ȹܤκ*/
  sf=mssInitFields();
  mssAddFieldsByFields(sf,optKEY.flds); /* -k ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sf);         /* ֹͥϿˤդ   */
  sorted=mssChkSorted(sf,hdi);          /* ȺѤå                 */
    
/*mssShowFields(sf);*/
/*mssShowOption(opt);*/
/*mssShowHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/                              
  hdo=mssInitCpyHeader(hdi);
    
  /*ϥإåܤɲ*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*̾ɲä*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);                  
    
  /*ȤɬפʤsfΥȾȿ*/
  if(!sorted){
    mssSetFieldsSort(hdo->flds,sf);
  } 
    
  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);                                    
  mssWriteHeader(hdo, fpw);
    
/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*ȤɬѤʤХȤƥȺѤߥեȤƥץ*/            
  if(!sorted){
    fpr=mssReopenFPRsort(fpr,4,sf,hdi->flds->cnt,optTMP.str);
  }

  rTables=mssMalloc(optFLD.flds->cnt*sizeof(struct rTbl *),"xtbucket");
  cutCnts=mssMalloc(optFLD.flds->cnt*sizeof(int),"xtbucket");

  /*FRK¤Τν*/
  frk=mssInitFRK(hdi->flds->cnt, &optKEY,optTMP.str);

  while(1){ /*loop by key*/
    /*ǡɤ߹*/
    if(EOF==mssReadFRK(fpr,frk)) break;

    /*ϰ϶ʬ(rng)*/
    if( strcmp("rng",optTyp.str)==0 ){
      max=mssMalloc(optFLD.flds->cnt*sizeof(double),"rng1");
      min=mssMalloc(optFLD.flds->cnt*sizeof(double),"rng2");
      for(i=0; i<optFLD.flds->cnt; i++){
        *(max+i)=-DBL_MAX;
        *(min+i)= DBL_MAX;
      }

      mssSeekTopFRK(frk);
      while( EOF != mssReadFldRecFRK(frk) ){
        /*͡Ǿͤ򥻥åȤ*/
        for(i=0; i<optFLD.flds->cnt; i++){
          bufStr=*(frk->pnt+MssFlds2num(optFLD.flds,i));
          if(MssIsNull(bufStr)) continue;
          bufNum=atof(bufStr);
          if( *(max+i)<bufNum ) *(max+i)=bufNum;
          if( *(min+i)>bufNum ) *(min+i)=bufNum;
        }
      }

      /*rTableꥢ*/
      for(i=0; i<optFLD.flds->cnt; i++){
        if( *(max+i)==DBL_MAX || *(min+i)==-DBL_MAX ){
          *(rTables+i)=NULL;
          *(cutCnts+i)=0; /*åȿΥå*/
        }else if( *(max+i) == *(min+i) ){
          *(rTables+i) = (struct rTbl *)mssMalloc(
                          1*sizeof(struct rTbl),"calOptCutP");
          ((*(rTables+i))+0)->from=*(min+i);
          ((*(rTables+i))+0)->to  =*(max+i);
          *(cutCnts+i)=1; /*åȿΥå*/
        }else{
          *(rTables+i) = (struct rTbl *)mssMalloc(
                          optNUM.val*sizeof(struct rTbl),"calOptCutP");
          rng=( *(max+i) - *(min+i) )/(double)optNUM.val;
          for(j=0; j<optNUM.val; j++){
                                 (*(rTables+i)+j)->from=*(min+i)+rng*j;
            if(j==optNUM.val-1)  (*(rTables+i)+j)->to  =*(max+i);
            else                 (*(rTables+i)+j)->to  =*(min+i)+rng*(j+1);
          }
          *(cutCnts+i)=optNUM.val; /*åȿΥå*/
        }
      }
      mssFree(max);
      mssFree(min);

    /*ʬ(cnt)*/
    }else{
      for(i=0; i<optFLD.flds->cnt; i++){
        /*ǡcTable˥å*/
        cTableCnt=0;
        cTableMaxCnt=0;
        cTable=setcTable(frk,MssFlds2num(optFLD.flds,i));

        /*ŬåȥݥȤ*/
        calOptCutPoint(optNUM.val);

        /*åȿΥå*/
        *(cutCnts+i)=cutCnt;

        /*rTable¸*/
        *(rTables+i)=rTable;

        /*ΰ賫*/
        mssFree(cTable);
        mssFree(kTable);
        mssFree(sTable);
      }
    }

    /**/
    mssSeekTopFRK(frk);
    while( EOF != mssReadFldRecFRK(frk) ){
      mssGV.inCnt++;
      mssWriteFld(frk->pnt,frk->fldCnt,"",fpw);
      mssGV.outCnt++;

      for(i=0; i<optFLD.flds->cnt; i++){
        mssWriteDlm(fpw);
        vstr=*(frk->pnt+MssFlds2num(optFLD.flds,i));
        if(MssIsNull(vstr) || *(cutCnts+i) == 0){
          mssWriteNull(fpw);
        }else{
          val=atof(vstr);
          for(k=0; k<*(cutCnts+i)-1; k++){
            if( val>=(*(rTables+i)+k)->from && val<(*(rTables+i)+k)->to ){
              break;
            }
          }

          if(optREV.set)num=*(cutCnts+i)-k-1;
          else          num=k;
          if(*optFMT.str=='0'){
            mssWriteInt(num+1,fpw);
          }else if(*optFMT.str=='1'){
            mssWriteDbl((*(rTables+i)+k)->from,fpw);
            mssWriteStr("_",fpw);
            mssWriteDbl((*(rTables+i)+k)->to  ,fpw);
          }else{
            mssWriteInt(num+1,fpw);
            mssWriteStr(":",fpw);
            mssWriteDbl((*(rTables+i)+k)->from,fpw);
            mssWriteStr("_",fpw);
            mssWriteDbl((*(rTables+i)+k)->to  ,fpw);
          }
        }
      }
      mssWriteRet(fpw);
    }
    for(i=0; i<optFLD.flds->cnt; i++){
      mssFree(*(rTables+i));
    }
  }

  /*ΰ賫*/
  mssFree(rTables);
  mssFree(cutCnts);
  mssFreeFRK(frk);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
/*printf("allocCnt=%d\n",getAllocCnt());*/
  mssWriteFooter(fpw);    /* եåν             */
  mssCloseFPR(fpr);       /* ϥեΥ     */
  mssCloseFPW(fpw);       /* ϥեΥ     */
  mssFreeFields(sf);      /* ȹܹ¤Τΰ賫 */
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeHeader(hdo);     /* ϥإåΰ賫         */
  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
