/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб                                                      */
/*============================================================================*/

#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>

#include <xmlencHelp.h>
struct mssComHelp comHelp={
  "xmlenc",       /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*              */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvǻȤʸĹ*/

/*----------------------------------------------------------------------------*/
/* Хѿ                                                             */
/*----------------------------------------------------------------------------*/
extern xmlParserCtxtPtr ctxt;
extern struct mssGlobalVariables mssGV;

struct mssFPW    *fpw; /*ϥե빽¤*/
iconv_t *icid;   /*iconv Ѵϥɥ*/
char *inEnc=NULL; /*󥳡ǥ*/
char *inVer=NULL; /*С*/

/*----------------------------------------------------------------------------*/
/* encoding̾                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptSTR optENC={
    OSTR,   /* ץ󥿥                                             */
    "e",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL  , /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    50,     /* ʸκĹ                                               */
    ENCT,   /* ΥץΥȥ(Helpɽ)                         */
    ENCC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optENC,&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* ¤                                                                     */
/*----------------------------------------------------------------------------*/
typedef struct _XmlState {
  int level;
  int crFlg;
} XmlState;

/*----------------------------------------------------------------------------*/
/* SAX ϥɥ顼                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){

  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  mssWriteXmlDeclaration( inVer, optENC.str, fpw );

  /*Ϥiconvץ*/
  icid=iconv_open(optENC.str,"UTF-8");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }
}

void end_doc(XmlState *state){

  if(icid!=NULL) iconv_close(icid);
}


/* start */
void start_element(XmlState *state, char *fullname, char **atts){
  struct mssXmlTag *xmlTag;
  int i;

  mssGV.inCnt++;
  if(state->crFlg){
    mssWriteRet(fpw);
    state->crFlg=0;
  }

  mssWriteXmlIndent(state->level,fpw);
  xmlTag=mssInitXmlTag(fullname,NULL);
  if(atts!=NULL){
    for(i=0;;i++){
      if(*(atts+2*i+0)==NULL) break;
      if(*(atts+2*i+1)==NULL) break;
      mssAddXmlTagAttributeStr(xmlTag,*(atts+2*i),*(atts+2*i+1),NULL);
    }
  }
  mssWriteXmlStartTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  mssGV.outCnt++;
  state->level++;
}

/* end */
void end_element(XmlState *state, char *fullname, char **atts){
  struct mssXmlTag *xmlTag;

  state->level--;

  if(state->crFlg){
    mssWriteRet(fpw);
    mssWriteXmlIndent(state->level,fpw);
    state->crFlg=0;
  }

  xmlTag=mssInitXmlTag(fullname,NULL);
  mssWriteXmlEndTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  if(state->level==0){
    mssWriteRet(fpw);
  }
}

void start_characters(XmlState *state, xmlChar *chars, int len){
  char *tmp;

  switch(*chars){
  case '\n':
    state->crFlg=1; break;
  case '&':
    mssWriteStr("&amp;",fpw); break;
  case '>':
    mssWriteStr("&gt;",fpw); break;
  case '<':
    mssWriteStr("&lt;",fpw); break;
  case '\'':
    mssWriteStr("&apos;",fpw); break;
  case '"':
    mssWriteStr("&quot;",fpw); break;
  default:
    tmp=mssNencoding(chars,len,icid);
    mssWriteStr(tmp,fpw);
    mssFree(tmp);
  }
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    NULL, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
};

int main(int argc, char *argv[]){

  XmlState         *state;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*ɸϥץ*/

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/

  state=mssCalloc(sizeof(XmlState),"xml2xt");

  if(optINF.set){
    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(optINF.str);
  }else{
    ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt("/dev/stdin");
  }
  if(!ctxt){
    mssShowErrMsg("not xml file\n");
    mssEnd(mssErrorNoDefault);
  }
  ctxt->sax=&SAXFunctions;

  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

  mssFree(inEnc);
  mssFree(inVer);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);     /*ϥեΥ      */
  mssFreeOption(opt);   /*ץΰ賫          */
  mssShowEndMsg();      /* λå             */
  return(0);            /* to avoid warning message   */
}
