#!/usr/bin/env bash

#*****************************************************************************
# xtfld2rec.sh
# 項目名と値の行展開
# Y.Hamuro
# 1.0  新規作成 2004/12/06
#*****************************************************************************

#エラーメッセージ
function help {
cat >/dev/stderr <<EOF
------------------------
xtfld2rec.sh version 1.0
------------------------
概要)項目名と値を行に展開する(クロス集計の逆)。
書式) xtfld2rec.sh -f 行に展開する項目名リスト
                   -k データ化された項目名に対する新項目名
                   -v 展開後の値に対する新項目名
                   [-i 入力ファイル名] [-o出力ファイル名]
                   [-T ワークディレクトリ名] [-V] [-h]

      -V : コマンドの完了メッセージを表示させる。
      -h : ヘルプの表示


例) xtfld2rec.sh -f amt200401,amt200402 -k 年月 -v 数量 -i dat.xt -o rsl.xt
例) xtfld2rec.sh -f 'amt*' -k 年月 -v 数量 -i dat.xt -o rsl.xt
EOF
exit 1
}

#デフォルトでは、コマンドのメッセージはOFF
export mssQuiet=1

#完了メッセージ用にコマンドラインを保存
cmdLine="$0 $*"

#シグナルによる終了
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
} 

#パラメータのチェック＆セット
while getopts ":f:k:v:i:o:Vh" opt; do
  case $opt in
    f  ) fld=$OPTARG ;;
    k  ) keyName=$OPTARG ;;
    v  ) valName=$OPTARG ;;
    i  ) input=$OPTARG ;;
    o  ) output=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$tmpD" = "" ]; then
   tmpD=/tmp
fi
if [ "$input" = "" ]; then
  input=/dev/stdin
fi
if [ "$output" = "" ]; then
  output=/dev/stdout
fi
if [ "$fld" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$keyName" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -k is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$valName" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi

#ワークファイル名
TD=$tmpD/xtfld2rec-$$

#トラップ発動
trap endByInt INT QUIT TERM HUP

#データのコピー
cat <$input >$TD-xxbase

#対象項目リストの作成
xtbest -R 0 -i $TD-xxbase |
xtcut -f $fld |
xt2txt -F -o $TD-xxfld
fldList=`cat $TD-xxfld`

xtbest -R 0 -i $TD-xxbase |
xtcut -r -f $fld |
xt2csv -F -o $TD-xxfldr
fldRlist=`cat $TD-xxfldr`

echo $fldList
for fldName in $fldList ; do
  xtcut -f $fldRlist,$fldName:$valName -i $TD-xxbase |
  xtsetchr -v $fldName -a $keyName |
  xtcut -f $fldRlist,$keyName,$valName -o $TD-xxsep-$fldName
done

xtcat -c -i $TD-xxsep-\* -o $output

rm -rf $TD-xx*

#完了メッセージ表示
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
