#!/usr/bin/env bash

################################################################################
# xtrfm
# RFM
# 2003/07/22 Y.Hamuro ^쐬
# 2004/01/21 tops /bin/bash -> /usr/bin/env bash ɕύX(ĉwE)
# 2004/01/21 wvŃo[W\悤ɕύX(1.0.1)
# 1.1 fBNg쐬p~,gbvǉA 2004/11/09
################################################################################

#===============================================================================
#wvbZ[W( -h^ꂽƂɕ\ )
#-------------------------------------------------------------------------------
# -h^ꂽƂɕ\B
# "cat >/dev/stderr <<EOR""EOF"̍s܂ł̃eLXĝ܂܉ʂɕ\
# p@ɂāAȗ\\ȃp[^͊("[]")Ŋ邱ƁB
#===============================================================================
function help {
cat >/dev/stderr <<EOF
---------------------
xtrfm.sh version 1.1
---------------------
Tv) RFM͂̃f[^쐬
p@) xtrfm [-c ڋqIDږ] [-d tږ] [-D t] [-m zږ]
              [-p] [-R RecencỹNX] [-F FrequencỹNX]
              [-M MonetarỹNX] [-i̓t@C] [-o o̓t@C]
  -c ڋqIDږ : ڋqIDږw肷(ڂ̎w\)
                    ȗ"ڋq"Ƃږ𗘗pB
  -d tږ   : ڋq̖Kږw肷B
                    ȗ"t"Ƃږ𗘗pB
  -D t     : RecencyvZ邽߂̊BYYYYMMDĎ`Ŏw肷B
                    RecencýAutv|uڋq̍ŏIKvŌvZ
                    ɂ`B
                    ȗ͖{̓tpB
  -m zږ   : ڋq̍wzږw肷B
                    ȗ"z"Ƃږ𗘗pB
  -R              : Recency̃NXɕ邩(ftHg5)
  -F              : Frequency̃NXɕ邩(ftHg5)
  -M              : Monetary̃NXɕ邩(ftHg5)
  -i ̓t@C : ChJ[hpłB
  -o o̓t@C : o̓t@C

Ql) MUSASHI-SCENARIOłׂ͂Ȑݒ肪łRFMmssRFM.shB
p1) xtrfm -i dat.xt -o rsl.xt
p2) xtrfm -c custID -d date -m amount -D 20030101 -p 20020101_20021231 -R 10 -F 10 -M 10 -i dat.xt -o rsl.xt
EOF
exit 1
}

#ftHgł́AR}h̃bZ[WOFF
export mssQuiet=1

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#===============================================================================
#p[^̃Zbg
# Ƃp[^́A̒lϐɃZbgAƂȂp[^́A
# ϐ"1"ZbgB
#-------------------------------------------------------------------------------
# getopts̈ɂ
#   ŏ̃R(:)́AsȃIvV͎ɁAoptϐ"?"ZbgB
#   ̂ƂɂÃP[X"\?)"ɈAhelps邱ƂɂȂB
#   ݒ肵p[^A"At@xbg+R"(ex."i:")ŗ^ƈƂ
#   p[^ƂĈARȂ̏ꍇ́ÂȂp[^ƂĈB
#   ex. "i:a:thv" -> "-i", "-a"͈Ƃp[^B
#                    "-t", "-h", "-v"͈ƂȂp[^B
#   OPTARGϐɃZbgB
#
# while & case ̏ɂ
#   while[v(whiledone܂ł̃ubN)񂲂ƂɁA[U͂
#   p[^Â`FbNAgetopts̈(LQ)ɊÂA
#   opt,OPTARGϐZbgB
#   optϐɂ́A[U͂p[^̃L[[hZbgA
#   OPTARGϐɂ́ÃL[[hƂȂA̒lZbgB
#   [Usȃp[^͂ꍇ́Aoptϐ"?"ZbgA
#   "\? )"̈ꕶsB
#
# caseƂ
#   "case $opt in ` case"́Aoptϐ̓eAu x )vx̒lƓs
#   R}hsBu x )v̌ɂ͕̃R}hLq\\ł邪A
#   Ō̃R}ȟ";;"(I[L)KvB
#===============================================================================
  while getopts ":c:d:D:m:p:R:F:M:i:o:T:Vh" opt; do
    case $opt in
      c  ) cFld=$OPTARG ;;
      d  ) dFld=$OPTARG ;;
      D  ) today=$OPTARG ;;
      m  ) mFld=$OPTARG ;;
      p  ) period=$OPTARG ;;
      R  ) bucketR=$OPTARG ;;
      F  ) bucketF=$OPTARG ;;
      M  ) bucketM=$OPTARG ;;
      i  ) INPUT=$OPTARG ;;
      o  ) OUTPUT=$OPTARG ;;
      T  ) TMPD=$OPTARG ;;
      V  ) mssQuiet=0 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done

#-------------------------------------------------------------------------------
# OPTINDPZB->̏ɂALp[^$nŎQ
# \\ƂȂB
#-------------------------------------------------------------------------------
  shift $(($OPTIND -1 ))

#-------------------------------------------------------------------------------
# p[^̃`FbN
#-------------------------------------------------------------------------------
  if [ "$cFld" = "" ]; then
     cFld="ڋq"
  fi
  if [ "$dFld" = "" ]; then
     dFld="t"
  fi
  if [ "$today" = "" ]; then
     today=`date +%Y%m%d`
  fi
  if [ "$mFld" = "" ]; then
     mFld="z"
  fi
  if [ "$period" = "" ]; then
     periodFrom="0"
     periodTo="99999999"
  else
     periodFrom=${period%_*}
     periodTo=${period#*_}
  fi
  if [ "$bucketR" = "" ]; then
    bucketR=5
  fi
  if [ "$bucketF" = "" ]; then
    bucketF=5
  fi
  if [ "$bucketM" = "" ]; then
    bucketM=5
  fi
  if [ "$INPUT" = "" ]; then
    INPUT=/dev/stdin
  fi
  if [ "$OUTPUT" = "" ]; then
    OUTPUT=/dev/stdout
  fi
  if [ "$TMPD" = "" ]; then
     TMPD=/tmp
  fi

#-------------------------------------------------------------------------------
# eO
#-------------------------------------------------------------------------------
# [Nt@C̃vtBbNX̐ݒ
# $$̓vZXԍ
wf=$TMPD/xtrfm-$$

#gbv
trap endByInt INT QUIT TERM HUP
#-------------------------------------------------------------------------------
# C
#-------------------------------------------------------------------------------
# 1. ̓f[^𕹍A
# 2. Kvȍ(ڋq,t,z)𔲂A
# 3. f[^IA
# 4. ڋqʓʋzv߂B
xtcat -i "$INPUT" |
xtsel -c "\$$dFld>$periodFrom && \$$dFld<$periodTo" |
xtcut -f $cFld,$dFld,$mFld |
xtagg -k $cFld,$dFld -f $mFld -c sum -o $wf-xx01

#XpxNX߂
xtcut -f $cFld -i $wf-xx01 |
xtcount -k $cFld -a Frequency |
xtbucket -n $bucketF -f Frequency:Fclass -o $wf-xxF

#zNX߂
xtcut -f $cFld,$mFld -i $wf-xx01 |
xtagg -k $cFld -f $mFld:Monetary -c sum |
xtbucket -n $bucketM -f Monetary:Mclass -o $wf-xxM

#RecencyNX߂
xtsetchr -v "$today" -a today -i $wf-xx01 |
xtcut -f $cFld,$dFld,today |
xtagg -k $cFld -f $dFld -c max |
xtcal -c "day($today,\$$dFld)" -a Recency |
xtbucket -r -n $bucketR -f Recency:Rclass -o $wf-xxR

#O̃t@C
xtjoin -nN -k $cFld -m $wf-xxF -f Frequency,Fclass -i $wf-xxR |
xtjoin -nN -k $cFld -m $wf-xxM -f Monetary,Mclass |
xtcut -f $cFld,Recency,Frequency,Monetary,Rclass,Fclass,Mclass -o $OUTPUT

#-------------------------------------------------------------------------------
# ㏈
#-------------------------------------------------------------------------------
# [Nt@C̍폜
rm $wf-xx*

#bZ[W\
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================

