#!/usr/bin/env bash

#*****************************************************************************
# xtas.sh version 1.1
# lbg[N@ɂuhXCb`m̎Zo
# Y.Hamuro
# 2004/10/13
# 2004/10/30 VOiΉȂ(1.1)
#*****************************************************************************

#G[bZ[W
function help {
cat >/dev/stderr <<EOF
--------------------------
xtnflow.sh version 1.1
--------------------------
Tv) lbg[Nʐ@ɂuhom̎Zo
) xtnflow.sh -c ڋqږ -b uhږ -q ʍږ
                 -i Ot@C -I t@C [-oo̓t@C]
                 [-T [NfBNg] [-V] [-h]

) -b, -q ɂ͕ڂwłȂ(Pꍀڂ̂)B
      -q Ŏw肳ꂽڂNULLlꍇ́A̍sSĂȂB
      -c,-bŎw肳ꂽڂNULLlꍇ́Â܂܏B

) xtnflow.sh -c ڋq -b uh -q  -i dat1.xt -I dat2.xt -o rsl.xt
EOF
exit 1
}

#ftHgł́AR}h̃bZ[WOFF
export mssQuiet=1

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}


#p[^̃`FbNZbg
  while getopts ":c:b:q:i:I:o:T:Vh" opt; do
    case $opt in
      c  ) CUST=$OPTARG ;;
      b  ) BRAND=$OPTARG ;;
      q  ) QTTY=$OPTARG ;;
      i  ) input1=$OPTARG ;;
      I  ) input2=$OPTARG ;;
      o  ) output=$OPTARG ;;
      T  ) tmpD=$OPTARG ;;
      V  ) mssQuiet=0 ;;
      h  ) echo 'h'; help ;;
      \? ) echo '?'$OPTARG; help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$tmpD" = "" ]; then
     tmpD=/tmp
  fi
  if [ "$input1" = "" ]; then
     echo "#MSG# $$ \"xtas.sh\" \"option -i is mandatory\"" >/dev/stderr
     help; exit 1
  fi
  if [ "$input2" = "" ]; then
     echo "#MSG# $$ \"xtas.sh\" \"option -I is mandatory\"" >/dev/stderr
     help; exit 1
  fi
  if [ "$output" = "" ]; then
     output=/dev/stdout
  fi
  if [ "$CUST" = "" ]; then
     echo "#MSG# $$ \"xtas.sh\" \"option -c is mandatory\"" >/dev/stderr
     help; exit 1
  fi
  if [ "$BRAND" = "" ]; then
     echo "#MSG# $$ \"xtas.sh\" \"option -b is mandatory\"" >/dev/stderr
     help; exit 1
  fi
  if [ "$QTTY" = "" ]; then
     echo "#MSG# $$ \"xtas.sh\" \"option -q is mandatory\"" >/dev/stderr
     help; exit 1
  fi

# [Nt@C̃vtBbNX̐ݒ
TD=$tmpD/xxx$$

#gbv
trap endByInt INT QUIT TERM HUP


# ==============================================================================
# 菇P) uh0(X)߃IWif[^ɉ(xxt1base,xxt2base)
# ==============================================================================
echo "#MSG# $$ \"Calculating brand 0 on each customer\"" >/dev/stderr

echo "#MSG# $$ \" ... cutting out necessary fields and summing up\"" >/dev/stderr
xtcut -f "$CUST,$BRAND:##b1##,$QTTY:##q1##" -i $input1 |
xtdelnul -f "##q1##" |
xtagg -k "$CUST,##b1##" -f "##q1##" -c sum -o $TD-xxt1

xtcut -f "$CUST,$BRAND:##b2##,$QTTY:##q2##" -i $input2 |
xtdelnul -f "##q2##" |
xtagg -k "$CUST,##b2##" -f "##q2##" -c sum -o $TD-xxt2

echo "#MSG# $$ \" ... calculating a difference of quantity between T1 and T2\"" >/dev/stderr
xtcut -f $CUST,##q2## -i $TD-xxt2 |
xtagg -k $CUST -f "##q2##" -c sum -o $TD-xxa

xtcut -f $CUST,##q1## -i $TD-xxt1 |
xtagg -k $CUST -f "##q1##" -c sum |
xtjoin -k $CUST -m $TD-xxa -f "##q2##" -nN |
xtnulto -f "##q1##,##q2##" -v 0 |
xtsel -c '$##q2## >= $##q1##' -u $TD-xxq1g |
xtsel -c '$##q2## <> $##q1##' -o $TD-xxq2g

echo "#MSG# $$ \" ... generating Brand0 files\"" >/dev/stderr
xtcal -c '$##q2##-$##q1##' -a "##diff##" -i $TD-xxq2g |
xtsetchr -v "#BRAND0#" -a "##b1##" |
xtcut -f "$CUST,##b1##,##diff##:##q1##" -o $TD-xxb0t1

xtcal -c '$##q1##-$##q2##' -a "##diff##" -i $TD-xxq1g |
xtsetchr -v "#BRAND0#" -a "##b2##" |
xtcut -f "$CUST,##b2##,##diff##:##q2##" -o $TD-xxb0t2

echo "#MSG# $$ \" ... concatinate Brand0 files and original files\"" >/dev/stderr
xtcat -i $TD-xxt1,$TD-xxb0t1 -o $TD-xxt1base
xtcat -i $TD-xxt2,$TD-xxb0t2 -o $TD-xxt2base

# ==============================================================================
# 菇2) ڋqʍv߁At1*t2(R)\\Ɍ
# ==============================================================================
echo "#MSG# $$ \"Calculating total quantity on each customer\"" >/dev/stderr
xtcut -f "$CUST,##q1##" -i $TD-xxt1base |
xtagg -k $CUST -f "##q1##:##ctotal##" -c sum -o $TD-xxctotal

xtcut -f "##q1##" -i $TD-xxt1base |
xtagg -f "##q1##:##total##" -c sum -o $TD-xxtotal

echo "#MSG# $$ \"Calculating total quantity on each brand\"" >/dev/stderr
xtcut -f "##b1##,##q1##" -i $TD-xxt1base |
xtagg -k "##b1##" -f "##q1##:##q1Total##" -c sum -o $TD-xxq1Total

xtcut -f "##b2##,##q2##" -i $TD-xxt2base |
xtagg -k "##b2##" -f "##q2##:##q2Total##" -c sum -o $TD-xxq2Total

echo "#MSG# $$ \"Calculating network flow estimated\"" >/dev/stderr
xtcut   -f "$CUST,##b1##,##q1##" -i $TD-xxt1base |
xtnjoin -k $CUST -m $TD-xxt2base -f "##b2##,##q2##" |
xtjoin  -k $CUST -m $TD-xxctotal -f "##ctotal##" |
xtcal -c '$##q1##*$##q2##/$##ctotal##' -a "##flow##" |
xtcut -f "##b1##,##b2##,##flow##" |
xtagg -k "##b1##,##b2##" -f "##flow##" -c sum |
xtjoin -k "##b1##" -m $TD-xxq1Total -f "##q1Total##" |
xtjoin -k "##b2##" -m $TD-xxq2Total -f "##q2Total##" |
xtproduct -m $TD-xxtotal -f "##total##" |
xtcal -c '$##flow##/$##q1Total##' -a "##op##" |
xtcal -c '$##flow##/$##q2Total##' -a "##ip##" |
xtcal -c '$##flow##/$##total##' -a "##support##" |
xtcut -f "##b1##:B1,##b2##:B2,##flow##:Flow,##q1Total##:Q1,##q2Total##:Q2,##total##:Total,##op##:flowOutProb,##ip##:flowInProb,##support##:support" -o $output
echo "#MSG# $$ \"Done\"" >/dev/stderr

rm $TD-xx*

