#!/usr/bin/env bash

#*****************************************************************************
# xtmvavg.sh
# ړώZoXNvg
# Y.Hamuro
# 1.0b 2004/05/07
# 1.0 -kǉ,-f̎w@ύX,gbvΉ 2004/11/09
#*****************************************************************************

function help {
cat >/dev/stderr <<EOF
--------------------------
xtmvavg.sh version 1.0
--------------------------
Tv) ړςvZB
) xtmvavg.sh -k L[ږ -s ׊鍀ږXg -f Wvږ:Vږ
                 -n ړ [-i ̓t@C] [-oo̓t@C]
                  [-T [NfBNg] [-V] [-h]

      -V : R}h̊bZ[W\B
      -h : wv̕\

1) xtmvavg.sh -s  -f z:ړ -n 3 -i input.xt -o output.xt
2) xtmvavg.sh -s %r -f :ʕ,z:z -n 5 -i input2.xt -o output2.xt
3) xtmvavg.sh -k X -s  -f z:z -n 4 <input3.xt >output3.xt

1̓o̓f[^
--------------
input.xt̓e
--------------
 z
1 10
2 20
3 30
4 40
5 50
--------------
output.xt̓e
--------------
 z ړ
1 10 *
2 20 *
3 30 20
4 40 30
5 50 40
--------------
3 : (10+20+30)/3 = 20
4 : (20+30+40)/3 = 30
5 : (30+40+50)/3 = 40
EOF
exit 1
}

#ftHgł́AR}h̃bZ[WOFF
export mssQuiet=1

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#p[^̃`FbNZbg
while getopts ":k:s:f:n:a:i:o:T:Vh" opt; do
  case $opt in
    k  ) KEY=$OPTARG ;;
    s  ) SORT=$OPTARG ;;
    f  ) FLD=$OPTARG ;;
    n  ) MVCNT=$OPTARG ;;
    i  ) INPUT=$OPTARG ;;
    o  ) OUTPUT=$OPTARG ;;
    T  ) TMPD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$SORT" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -s is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$FLD" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$MVCNT" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$INPUT" = "" ]; then
   INPUT=/dev/stdin
fi
if [ "$OUTPUT" = "" ]; then
 OUTPUT=/dev/stdout
fi
if [ "$TMPD" = "" ]; then
   TMPD=/tmp
fi
if [ "$KEY" = "" ]; then
  KEY="#same#"
  KEYPAR=""
else
  KEYPAR=${KEY},
fi

#-s̃p[^%ŕ -s t%r -> SORTFLD=t SORTPAR=r
SORTFLD=${SORT%\%*}
SORTPAR=${SORT#*%}
if [ "$SORTFLD" = "$SORTPAR" ]; then
  SORTPAR=""
else
  SORTPAR="%$SORTPAR"
fi

#-f̃p[^̓t@CږƏo̓t@Cږɕ
#-f a:b,c:d -> iFldList=a,c oFldList=b,d
ARRY=(${FLD//[,]/ })
iFldList=""
oFldList=""
for FN in "${ARRY[@]}"; do
  FN1=${FN%:*}
  FN2=${FN#*:}
  if [ "$FN1" = "$FN2" ] ; then
    echo "#MSG# $$ \"$0\" \"option -f must take fieldName:newFieldName\"" >/dev/stderr
    exit 1
  fi
  iFldList=$iFldList,$FN1
  oFldList=$oFldList,$FN2
done
iFldList=${iFldList#,}
oFldList=${oFldList#,}

#[Nt@C
TD="$TMPD/xtmvavg-$$"

#gbv
trap endByInt INT QUIT TERM HUP

#=====================================================
# yXebvPz
# ̓t@C̊esړ(-n̒l)duplicateA
# ł̘Aԍ(##mvSeq##)쐬B
# ̘AԂ͊VȂ閈ɊJnԍ炵ĂB
#-----------------------------------------------------
#  z  ($INPUT: ȉ̍߂Ƃ͂̓̓f[^ɂĐĂ)
# 1 10
# 2 20
# 3 30
# 4 40
# 5 50
#  
#  z ##mvSeq##  ($TD-xxbase)
# 1 10 1001
# 1 10 1002
# 1 10 1003
# 2 20 1002
# 2 20 1003
# 2 20 1004
# 3 30 1003
# 3 30 1004
# 3 30 1005
# 4 40 1004
# 4 40 1005
# 4 40 1006
# 5 50 1005
# 5 50 1006
# 5 50 1007
#=====================================================
xtnumber -k $KEY -s $SORTFLD$SORTPAR -S 10000000 -a '##seqNo##' -i $INPUT |
xtsetchr -v $MVCNT -a days |
xtduprec -f days |
xtcal -k $KEYPAR'##seqNo##' -c '$##seqNo##+keyLine()' -a '##mvSeq##' |
xtcut -r -f 'days,##seqNo##' -o "$TD-xxbase"

#=====================================================
# yXebvQz
# ̃XebvR##mvSeq##L[ɂĈړς߂邪
# ̍ہAړ(-n̒l)ɖȂ͈̂Ӗ
# ȂB
# Ōړ(-n̒l)##mvSeq##IłB
#-----------------------------------------------------
# ##mvSeq## ##cnt##  ($TD-xx2)
# 1003 3
# 1004 3
# 1005 3
#=====================================================
xtcut   -f $KEYPAR'##mvSeq##' -i $TD-xxbase | 
xtcount -k $KEYPAR'##mvSeq##' -a '##cnt##' |
xtsel   -c '$##cnt##=='$MVCNT -o $TD-xx2

#=====================================================
# yXebvRz
# ##mvSeq##L[ɂĈړς߂B
# ̍ہALŋ߂##mvSeq##̌ړ(-n̒l)
# ŝ݂IԁB
#-----------------------------------------------------
# ##mvSeq## ##cnt##  ($TD-xx3)
# 1003 20
# 1004 30
# 1005 40
#=====================================================
xtcut    -f $KEYPAR'##mvSeq##',$iFldList -i $TD-xxbase |
xtagg    -k $KEYPAR'##mvSeq##' -f $FLD -c avg |
xtcommon -k $KEYPAR'##mvSeq##' -m $TD-xx2 -o $TD-xx3

#=====================================================
# yXebvSz
# XebvPŋ߂f[^A##mvSeqɑΉ
# IAXebvRŋ߂ړϒlB
#-----------------------------------------------------
# ,z,ړ ($OUTPUT)
# 1 10 *
# 2 20 *
# 3 30 20
# 4 40 30
# 5 50 40
#=====================================================
xtcut  -f $KEYPAR'##mvSeq##',$SORTFLD,$iFldList -i $TD-xxbase |
xtbest -k $KEYPAR$SORTFLD -s '##mvSeq##' -R 1 |
xtjoin -n -k $KEYPAR'##mvSeq##' -m $TD-xx3 -f $oFldList |
xtcut  -r -f '##mvSeq##' -o $OUTPUT

#[Nt@C폜
rm -f $TD-xx*

#bZ[W\
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
