#!/usr/bin/env bash

#*****************************************************************************
# xtfld2rec.sh
# ږƒl̍sWJ
# Y.Hamuro
# 1.0  VK쐬 2004/12/06
#*****************************************************************************

#G[bZ[W
function help {
cat >/dev/stderr <<EOF
------------------------
xtfld2rec.sh version 1.0
------------------------
Tv)ږƒlsɓWJ(NXWv̋t)B
) xtfld2rec.sh -f sɓWJ鍀ږXg
                   -k f[^ꂽږɑ΂Vږ
                   -v WJ̒lɑ΂Vږ
                   [-i ̓t@C] [-oo̓t@C]
                   [-T [NfBNg] [-V] [-h]

      -V : R}h̊bZ[W\B
      -h : wv̕\


) xtfld2rec.sh -f amt200401,amt200402 -k N -v  -i dat.xt -o rsl.xt
) xtfld2rec.sh -f 'amt*' -k N -v  -i dat.xt -o rsl.xt
EOF
exit 1
}

#ftHgł́AR}h̃bZ[WOFF
export mssQuiet=1

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
} 

#p[^̃`FbNZbg
while getopts ":f:k:v:i:o:Vh" opt; do
  case $opt in
    f  ) fld=$OPTARG ;;
    k  ) keyName=$OPTARG ;;
    v  ) valName=$OPTARG ;;
    i  ) input=$OPTARG ;;
    o  ) output=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$tmpD" = "" ]; then
   tmpD=/tmp
fi
if [ "$input" = "" ]; then
  input=/dev/stdin
fi
if [ "$output" = "" ]; then
  output=/dev/stdout
fi
if [ "$fld" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$keyName" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -k is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$valName" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi

#[Nt@C
TD=$tmpD/xtfld2rec-$$

#gbv
trap endByInt INT QUIT TERM HUP

#f[^̃Rs[
cat <$input >$TD-xxbase

#ΏۍڃXg̍쐬
xtbest -R 0 -i $TD-xxbase |
xtcut -f $fld |
xt2txt -F -o $TD-xxfld
fldList=`cat $TD-xxfld`

xtbest -R 0 -i $TD-xxbase |
xtcut -r -f $fld |
xt2csv -F -o $TD-xxfldr
fldRlist=`cat $TD-xxfldr`

echo $fldList
for fldName in $fldList ; do
  xtcut -f $fldRlist,$fldName:$valName -i $TD-xxbase |
  xtsetchr -v $fldName -a $keyName |
  xtcut -f $fldRlist,$keyName,$valName -o $TD-xxsep-$fldName
done

xtcat -c -i $TD-xxsep-\* -o $output

rm -rf $TD-xx*

#bZ[W\
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
