#!/usr/bin/env bash

################################################################################
# xtrfm
# RFMʬ
# 2003/07/22 Y.Hamuro 
# 2004/01/21 top /bin/bash -> /usr/bin/env bash ѹ(ĻΤŦ)
# 2004/01/21 إפǥСɽ褦ѹ(1.0.1)
# 1.1 ǥ쥯ȥѻ,ȥåɲá 2004/11/09
################################################################################

#===============================================================================
#إץå( -hͿ줿Ȥɽ )
#-------------------------------------------------------------------------------
# -hͿ줿Ȥɽ롣
# "cat >/dev/stderr <<EOR""EOF"ιԤޤǤΥƥȤΤޤ޲̤ɽ
# ˡˤơάǽʥѥ᡼ϳ("[]")ǳ뤳ȡ
#===============================================================================
function help {
cat >/dev/stderr <<EOF
---------------------
xtrfm.sh version 1.1
---------------------
) RFMʬϤΥǡ
ˡ) xtrfm [-c ܵID̾] [-d չ̾] [-D ] [-m ۹̾]
              [-p] [-R RecencyΥ饹] [-F FrequencyΥ饹]
              [-M MonetaryΥ饹] [-iϥե̾] [-o ϥե̾]
  -c ܵID̾ : ܵID򼨤̾ꤹ(ʣܤλǽ)
                    ά"ܵ"Ȥ̾Ѥ롣
  -d չ̾   : ܵҤˬ򼨤̾ꤹ롣
                    ά""Ȥ̾Ѥ롣
  -D      : Recency׻뤿δYYYYMMDDηǻꤹ롣
                    RecencyϡִաסݡָܵҤκǽˬפǷ׻
                    ˤ롣
                    άդѤ롣
  -m ۹̾   : ܵҤιۤ򼨤̾ꤹ롣
                    ά""Ȥ̾Ѥ롣
  -R              : Recency򲿸ĤΥ饹ʬ䤹뤫(ǥեȤ5)
  -F              : Frequency򲿸ĤΥ饹ʬ䤹뤫(ǥեȤ5)
  -M              : Monetary򲿸ĤΥ饹ʬ䤹뤫(ǥեȤ5)
  -i ϥե̾ : 磻ɥɤѤǤ롣
  -o ϥե̾ : ϥե̾

) MUSASHI-SCENARIOǤϤ٤꤬ǤRFMʬmssRFM.sh롣
1) xtrfm -i dat.xt -o rsl.xt
2) xtrfm -c custID -d date -m amount -D 20030101 -p 20020101_20021231 -R 10 -F 10 -M 10 -i dat.xt -o rsl.xt
EOF
exit 1
}

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#===============================================================================
#ѥ᡼Υå
# Ȥѥ᡼ϡͤѿ˥åȤȤʤѥ᡼ϡ
# ѿ"1"򥻥åȤ롣
#-------------------------------------------------------------------------------
# getoptsΰˤĤ
#   ǽΥ(:)ϡʥץϻˡoptѿ"?"򥻥åȤ롣
#   ΤȤˤꡢΥʸ"\?)"˰äꡢhelp¹Ԥ뤳Ȥˤʤ롣
#   ꤷѥ᡼"ե٥å+"(ex."i:")ͿȰȤ
#   ѥ᡼ȤưʤξϡΤʤѥ᡼Ȥư
#   ex. "i:a:thv" -> "-i", "-a"ϰȤѥ᡼
#                    "-t", "-h", "-v"ϰȤʤѥ᡼
#   OPTARGѿ˥åȤ롣
#
# while & case νˤĤ
#   while롼(whiledoneޤǤΥ֥å)󤴤Ȥˡ桼Ϥ
#   ѥ᡼ĤŤĥågetoptsΰ(嵭)˴Ť
#   opt,OPTARGѿ򥻥åȤ롣
#   optѿˤϡ桼Ϥѥ᡼ΥɤåȤ졢
#   OPTARGѿˤϡΥɤȤʤ顢ͤåȤ롣
#   桼ʥѥ᡼Ϥϡoptѿ"?"åȤ졢
#   "\? )"ΰʸ¹Ԥ롣
#
# caseʸȤ
#   "case $opt in  case"ϡoptѿƤ x )פxͤƱԤ
#   ޥɤ¹Ԥ롣 x )פθˤʣΥޥɤ򵭽ҲǽǤ뤬
#   ǸΥޥɤθ";;"(ü)Ĥɬפ롣
#===============================================================================
  while getopts ":c:d:D:m:p:R:F:M:i:o:T:Vh" opt; do
    case $opt in
      c  ) cFld=$OPTARG ;;
      d  ) dFld=$OPTARG ;;
      D  ) today=$OPTARG ;;
      m  ) mFld=$OPTARG ;;
      p  ) period=$OPTARG ;;
      R  ) bucketR=$OPTARG ;;
      F  ) bucketF=$OPTARG ;;
      M  ) bucketM=$OPTARG ;;
      i  ) INPUT=$OPTARG ;;
      o  ) OUTPUT=$OPTARG ;;
      T  ) TMPD=$OPTARG ;;
      V  ) mssQuiet=0 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done

#-------------------------------------------------------------------------------
# OPTIND򣱸롣->νˤꡢ嵭ѥ᡼$nǻ
# ǽȤʤ롣
#-------------------------------------------------------------------------------
  shift $(($OPTIND -1 ))

#-------------------------------------------------------------------------------
# ѥ᡼Υå
#-------------------------------------------------------------------------------
  if [ "$cFld" = "" ]; then
     cFld="ܵ"
  fi
  if [ "$dFld" = "" ]; then
     dFld=""
  fi
  if [ "$today" = "" ]; then
     today=`date +%Y%m%d`
  fi
  if [ "$mFld" = "" ]; then
     mFld=""
  fi
  if [ "$period" = "" ]; then
     periodFrom="0"
     periodTo="99999999"
  else
     periodFrom=${period%_*}
     periodTo=${period#*_}
  fi
  if [ "$bucketR" = "" ]; then
    bucketR=5
  fi
  if [ "$bucketF" = "" ]; then
    bucketF=5
  fi
  if [ "$bucketM" = "" ]; then
    bucketM=5
  fi
  if [ "$INPUT" = "" ]; then
    INPUT=/dev/stdin
  fi
  if [ "$OUTPUT" = "" ]; then
    OUTPUT=/dev/stdout
  fi
  if [ "$TMPD" = "" ]; then
     TMPD=/tmp
  fi

#-------------------------------------------------------------------------------
# Ƽ
#-------------------------------------------------------------------------------
# եΥץեå
# $$ϥץֹ
wf=$TMPD/xtrfm-$$

#ȥåȯư
trap endByInt INT QUIT TERM HUP
#-------------------------------------------------------------------------------
# ᥤ
#-------------------------------------------------------------------------------
# 1. ϥǡʻ礷
# 2. ɬפʹ(ܵ,,)ȴ
# 3. ǡ򤷡
# 4. ̶ܵ۹פ롣
xtcat -i "$INPUT" |
xtsel -c "\$$dFld>$periodFrom && \$$dFld<$periodTo" |
xtcut -f $cFld,$dFld,$mFld |
xtagg -k $cFld,$dFld -f $mFld -c sum -o $wf-xx01

#Ź٥饹
xtcut -f $cFld -i $wf-xx01 |
xtcount -k $cFld -a Frequency |
xtbucket -n $bucketF -f Frequency:Fclass -o $wf-xxF

#ۥ饹
xtcut -f $cFld,$mFld -i $wf-xx01 |
xtagg -k $cFld -f $mFld:Monetary -c sum |
xtbucket -n $bucketM -f Monetary:Mclass -o $wf-xxM

#Recency饹
xtsetchr -v "$today" -a today -i $wf-xx01 |
xtcut -f $cFld,$dFld,today |
xtagg -k $cFld -f $dFld -c max |
xtcal -c "day($today,\$$dFld)" -a Recency |
xtbucket -r -n $bucketR -f Recency:Rclass -o $wf-xxR

#ĤΥե
xtjoin -nN -k $cFld -m $wf-xxF -f Frequency,Fclass -i $wf-xxR |
xtjoin -nN -k $cFld -m $wf-xxM -f Monetary,Mclass |
xtcut -f $cFld,Recency,Frequency,Monetary,Rclass,Fclass,Mclass -o $OUTPUT

#-------------------------------------------------------------------------------
# 
#-------------------------------------------------------------------------------
# եκ
rm $wf-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================

