
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "件数均等化バケット分割"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define KEYT "キー項目名リスト"
#define KEYC "バケット分割を行う単位となる項目名リスト"

/*-f*/
#define FLDT "分割する項目名リスト"
#define FLDC "ここで指定した項目の値に基づいて分割をおこなう"
#define FLDF NULL

/*-n*/
#define NUMT "分割数"
#define NUMC "分割するバケットの数を指定する"

/*-F*/
#define FMTT "出力形式"
#define FMTC "バケットの名前を出力形式"
#define FMTS "バケット番号,数値範囲,バケット番号+数値範囲"

/*-c*/
#define TYPT "バケットタイプ"
#define TYPC "バケットの数値範囲の決め方を指定する"
#define TYPS "件数均等化バケット,数値範囲均等化バケット"

/*-r*/
#define REVT "逆順"
#define REVC "バケット番号を出力するとき、数値の大きい順にバケット番号を1からふっていく"

/*-O*/
#define RNGT "バケット範囲出力ファイル"
#define RNGC "各項目(-f)の各バケットの数値範囲を出力するファイル名"

/*-a*/
#define FNMT C_FNMT
#define FNMC C_FNMC

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "キー項目名リストで指定した項目を単位にして、-fので指定した数値項目を、できるだけ件数が均等になるようなバケットに分割する。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtbucket -f 金額:金額バケット,数量:数量バケット -n 5 -i dat.xt -o rsl.xt\n\
xtbucket -f 金額:金額バケット,数量:数量バケット -n 5 -F 1 -i dat.xt -o rsl.xt\n\
xtbucket -k 顧客 -f 金額:金額バケット,数量:数量バケット -n 5 -i dat.xt -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtagg,xtstatistics,xtshare"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
