/*============================================================================*/
/* xtrjoin -k -r%s|n -m -K -R field1%e|n,field2%e|n -f  -n -z -t              */
/*----------------------------------------------------------------------------*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 :  2004/08/01                                                  */
/* 1.1 : ʸ羮ӤΥХ 2004/10/05                                */
/*       λʤξΥХ                                       */
/*============================================================================*/

#include <musashi.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include <xtrjoinHelp.h>
struct mssComHelp comHelp={
  "xtrjoin",      /* ޥ̾       */
  "1.1",          /* С       */
  HELPT,          /* ޥɥȥ */ 
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
}; 

extern struct mssGlobalVariables mssGV;

/*--Хѿ*/
static struct mssFPW *op;
static MssOptKEY *OPTTKY;
static MssOptKEY *OPTMKY;
static MssOptFLD *OPTFLD;
static MssOptFLD *OPTVAL;
static MssOptFLD *OPTRNG;
static int NSflg; /*ϰ(1)ʸϰ(0) */

struct KeyInfo {
  int keyCmp;
  int rngCmp;
  int rngFlg; /* 0: ʾ̤ 1:礭ʲ */
};

/**
 * # FUNCTION #
 * ɤ߹ޤƤTraMstΥͤӤ
 */
void setKeyInfo(
  struct KeyInfo *keyInfo,
  struct mssFldRec    *frT,
  struct mssFldRecDbl *frdM){
  int cmp;
  int i;
  int fnT;
  int fnM;
  int kb;
  char *rsT,*rsMst,*rsMed;
  double  rnT,rnMst,rnMed;

  if(frT->eof){
    keyInfo->keyCmp=1; /*T>M*/
    keyInfo->rngCmp=9; /*T>M*/
  }
  if(frdM->eof){
    keyInfo->keyCmp=-1; /*T<M*/
    keyInfo->rngCmp= 9; /*T<M*/
  }

  for(i=0; i<OPTTKY->flds->cnt; i++){
    fnT=MssFlds2num(OPTTKY->flds,i);
    fnM=MssFlds2num(OPTMKY->flds,i);
    cmp = strcmp(*(frT->pnt+fnT),
                 *(frdM->pnt[frdM->old]+fnM));
    if(cmp>0){
      keyInfo->keyCmp=1; /*T>M*/
      keyInfo->rngCmp=9; /*T>M*/
      return;
    }else if(cmp<0){
      keyInfo->keyCmp=-1; /*T<M*/
      keyInfo->rngCmp= 9; /*T<M*/
      return;
    }
  }

  keyInfo->keyCmp=0; /*T=M*/

  kb=mssKeyBreak( frdM, OPTMKY);
  rsT   = *(frT->pnt+MssFlds2num(OPTVAL->flds,0));
  rsMst = *(frdM->pnt[frdM->old]+MssFlds2num(OPTRNG->flds,0));
  if(kb) rsMed = "\xFF\xFF\xFF\xFF";
  else   rsMed = *(frdM->pnt[frdM->new]+MssFlds2num(OPTRNG->flds,0));

  if( NSflg==1 ){ /*ϰϤξ*/
    rnT  =atof(rsT  );
    rnMst=atof(rsMst);
    if(kb) rnMed = DBL_MAX;
    else   rnMed = atof(rsMed);

    if(keyInfo->rngFlg){     /* 礭ʲ */
//printf("st,ed=%g,%g\n",rnMst,rnMed);
           if(rnT> rnMed) keyInfo->rngCmp= 1;
      else if(rnT<=rnMst) keyInfo->rngCmp=-1;
      else                keyInfo->rngCmp= 0;
    }else{                   /* ʾ̤ */
           if(rnT>=rnMed) keyInfo->rngCmp= 1;
      else if(rnT< rnMst) keyInfo->rngCmp=-1;
      else                keyInfo->rngCmp= 0;
    }
  }else{          /*ʸϰϤξ*/
    if(keyInfo->rngFlg){     /* 礭ʲ */
           if( strcmp(rsT, rsMed) > 0 ) keyInfo->rngCmp= 1;
      else if( strcmp(rsT, rsMst) <=0 ) keyInfo->rngCmp=-1;
      else                              keyInfo->rngCmp= 0;
    }else{                   /* ʾ̤ */
           if( strcmp(rsT, rsMed) >=0 ) keyInfo->rngCmp= 1;
      else if( strcmp(rsT, rsMst) < 0 ) keyInfo->rngCmp=-1;
      else                              keyInfo->rngCmp= 0;
    }
  }
}

/**
 * # FUNCTION #
 * ޥܤȤơcntĤNULLͤȤƽ񤭽Ф
 * βԤϤ롣
 */
static void writeMstNul(int cnt){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteNull(op); mssWriteDlm(op);
  }
  mssWriteNull(op); mssWriteRet(op);
}

/**
 * # FUNCTION #
 * ȥ󥶥ܤȤstrcntĤǤ񤭽Ф
 * ϥڡϤ롣
 */
static void writeTraFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt; i++){
    mssWriteStr(*(str+i),op);
    mssWriteDlm(op);
  }
}

/**
 * # FUNCTION #
 * ޥܤȤstrcntĤǤ񤭽Ф
 * βԤϤ롣
 */
void writeMstFld(int cnt, char **str){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
    mssWriteDlm(op);
  }
  mssWriteStr(*(str+MssFlds2num(OPTFLD->flds,i)),op);
  mssWriteRet(op);
}

/**
 * # FUNCTION #
 * ߤΥȥ󥶥ȥޥ礷η̤Ϥ롣
 * frkT⤷frkMΤ줫NULLͿ뤳ȤˤꡢouterJOINԤ
 * η̤Ϥ롣
 */
static void writeTM(struct mssFldRec *frT,struct mssFldRecDbl *frdM){

  /*ޥEOFλ*/
  if(frdM==NULL){
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstNul(OPTFLD->flds->cnt);
    mssGV.outCnt++;

  /*ȥ顢ޥξ*/
  }else{
    writeTraFld(frT->fldCnt,frT->pnt);
    writeMstFld(OPTFLD->flds->cnt,frdM->pnt[frdM->old]);
    mssGV.outCnt++;
  }
}

int readT(struct mssFPR *fprT, struct mssFldRec *frT){
  int statT;

  statT=mssReadFldRec(fprT,frT);
  if(statT!=EOF) mssGV.inCnt ++;
  return(statT);
}

/*============================================================================*/
/* version 1.00 2000/07/07  hamuro                                    */
/*============================================================================*/
int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optTKY={
    OKEY,   /* ץ󥿥                                             */
    "k",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    TKYT,   /* ΥץΥȥ(Helpɽ)                         */
    TKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϰӤ()                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLD optVAL={
    OFLD,   /* ץ󥿥                                             */
    "v",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "i",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n",    /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    VALT,   /* ΥץΥȥ(Helpɽ)                         */
    VALC,   /* ΥץΥ(Helpɽ)                         */
    VALF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };


/*----------------------------------------------------------------------------*/
/* ȥ                                                               */
/*----------------------------------------------------------------------------*/
  MssOptKEY optMKY={
    OKEY,   /* ץ󥿥                                             */
    "K",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    2,      /* ǥե(Υץ󤬻ꤵʤäȤư) */
            /* 1:ƤιԤۤ륭ͤȤư                             */
            /* 2:ƤιԤƱͤȤư)                            */
            /* 0:¾(嵭ΰ̣᤬ʤ)                               */
    MKYT,   /* ΥץΥȥ(Helpɽ)                         */
    MKYC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϰϹ()                                                       */
/*----------------------------------------------------------------------------*/
  MssOptFLD optRNG={
    OFLD,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    1,      /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    0,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    0,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    "n",    /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    RNGT,   /* ΥץΥȥ(Helpɽ)                         */
    RNGC,   /* ΥץΥ(Helpɽ)                         */
    RNGF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ȥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optMST={
    OINF,   /* ץ󥿥                                             */
    "m",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    MSTT,   /* ΥץΥȥ(Helpɽ)                         */
    MSTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*                                                                    */
/*----------------------------------------------------------------------------*/
  MssOptFLD optFLD={
    OFLD,   /* ץ󥿥                                             */
    "f",    /* (ʣʸԲ)                                   */
    1,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssFieldMaxCnt, /* ǽʺܿ                                 */
    "m",    /* оݤȤϥǡΥ(GUI)                  */
    1,      /* ɽĤ뤫ɤ(0:Բ,1:)                      */
    1,      /* ̾Ǥ뤫ɤ(0:Բ,1:)                    */
    NULL,   /* ܥץ(%ʲ)ǻǽʸ                        */
            /* ex) ԲĤξNULL, "nr": "-f ̾%rn"λǽ     */
    FLDT,   /* ΥץΥȥ(Helpɽ)                         */
    FLDC,   /* ΥץΥ(Helpɽ)                         */
    FLDF    /* ե饰ˤĤƤ(Helpɽ)ʣξϥޤǶڤ   */
  };

/*----------------------------------------------------------------------------*/
/* ϰϤ֤礭ʲפȤե饰                                     */
/*----------------------------------------------------------------------------*/
  MssOptFLG optREV={
    OFLG,   /* ץ󥿥                                             */
    "r",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    REVT,   /* ΥץΥȥ(Helpɽ)                         */
    REVC    /* ΥץΥ(Helpɽ)                         */
  };


/*----------------------------------------------------------------------------*/
/* outerJoin                                                              */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTNL={
    OFLG,   /* ץ󥿥                                             */
    "n",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TNLT,   /* ΥץΥȥ(Helpɽ)                         */
    TNLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/*ޥrangeޥåʤϤե饰                             */
/*----------------------------------------------------------------------------*/
  MssOptFLG optRNL={
    OFLG,   /* ץ󥿥                                             */
    "N",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    RNLT,   /* ΥץΥȥ(Helpɽ)                         */
    RNLC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    1,      /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };
    
/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optTKY,&optVAL,&optMKY,&optMST,&optRNG,&optFLD,&optTNL,&optRNL,
               &optREV,&optINF,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdT; /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdM; /*ȥե<head>Ǽ¤*/
  struct mssHeader    *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fprT;/*ϥե빽¤                */
  struct mssFPR       *fprM;/*ȥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  struct mssFields    *sfT; /*ȹܹ¤                  */
  struct mssFields    *sfM; /*ȹܹ¤                  */
  int sortedT;              /*Ⱥѥå                */
  int sortedM;              /*Ⱥѥå                */
  struct KeyInfo       keyInfo;
  int statT;                /*mssReadFRK(Tra)Υơ*/
  int statM;                /*mssReadFRK(Mst)Υơ*/
  int fcT;                  /*ϥǡιܿ*/
  int fcM;                  /*ȥǡιܿ*/

  /*key break joinˤ*/
  struct mssFldRec    *frT=NULL;
  struct mssFldRecDbl *frdM=NULL;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */

  /*-KꤵƤʤ-k򥳥ԡ*/
  if(!optMKY.set){
    mssCpyOptKey(&optMKY,&optTKY);
  }

  /*-RꤵƤʤ-v򥳥ԡ*/
  if(!optRNG.set){
    mssCpyOptFld(&optRNG,&optVAL);
  }else{

    /*-v-RΥץ(%n)ۤäƤ-v˹碌*/
    if(*optVAL.fldOpt != NULL){
      if( *optRNG.fldOpt != NULL){  /* ξȤⲿ餫Υץ */
        **optRNG.fldOpt = **optVAL.fldOpt;
      }else{                        /* -v Τߥץ󤢤 */
        *optRNG.fldOpt = mssStrdup(*optVAL.fldOpt);
      }
    }else{
      if( *optRNG.fldOpt != NULL){  /* -R Τߥץ󤢤 */
        *optRNG.fldOpt=NULL;
      }
    }
  }

  fprT=mssOpenFPR(optINF.str,4);    /*ե륪ץ*/
  fprM=mssOpenFPR(optMST.str,128);  /*ޥե륪ץ*/
  hdT=mssReadHeader(fprT);          /*̾ɤ߹*/
  hdM=mssReadHeader(fprM);          /*̾ɤ߹*/
 
  mssSetOptKey(&optTKY, hdT);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optVAL, hdT);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptKey(&optMKY, hdM);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optRNG, hdM);       /* ץܤإåܤ˴ϢŤ*/
  mssSetOptFld(&optFLD, hdM);       /* ץܤإåܤ˴ϢŤ*/
  
  /*traȹܤκ*/
  sfT=mssInitFields();
  mssAddFieldsByFields(sfT,optTKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssAddFieldsByFields(sfT,optVAL.flds);/* -r ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfT);        /* ֹͥϿˤդ   */
  sortedT=mssChkSorted(sfT,hdT);        /* ȺѤå                 */
  
  /*mstȹܤκ*/
  sfM=mssInitFields();
  mssAddFieldsByFields(sfM,optMKY.flds);/* -k ܤ򥽡ȹܤȤƥå    */
  mssAddFieldsByFields(sfM,optRNG.flds);/* -R ܤ򥽡ȹܤȤƥå    */
  mssSetFieldsSortPriority(sfM);        /* ֹͥϿˤդ   */
  sortedM=mssChkSorted(sfM,hdM);        /* ȺѤå                 */
  
/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdT);

  /*ϥإåܤɲ*/
  mssAddFieldsByFields(hdo->flds,hdT->flds);

  /*̾ɲä*/
  mssAddFieldsByStrList(hdo->flds,optFLD.newNam,optFLD.cnt);

  /*ȤɬפʤsfΥȾȿ*/
  if(!sortedT){
    mssSetFieldsSort(hdo->flds,sfT);
  }

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*Хѿå*/
  fcT=hdT->flds->cnt;
  fcM=hdM->flds->cnt;
  OPTTKY=&optTKY;
  OPTMKY=&optMKY;
  OPTFLD=&optFLD;
  OPTVAL=&optVAL;
  OPTRNG=&optRNG;
  op=fpw;

  /*ϰϤʸϰϤ򥻥åȤ(ǥեȤϿϰ)*/
  NSflg=0;
  if(mssIsFldOptOn(&optVAL,0,'n') ){
    NSflg=1;
  }

  if(!sortedT){
    fprT=mssReopenFPRsort(fprT,4,sfT,hdT->flds->cnt,optTMP.str);
  }
  if(!sortedM){
    fprM=mssReopenFPRsort(fprM,4,sfM,hdM->flds->cnt,optTMP.str);
  } 


  frT=mssInitFldRec(fcT);
  frdM=mssInitFRD(fcM);

  /*ȥեϡǽ2ɤߤ*/
  statM=mssReadFRD(fprM,frdM);
  if(statM!=EOF) statM=mssReadFRD(fprM,frdM);

  statT=readT(fprT,frT);

  keyInfo.keyCmp=0;
  keyInfo.rngCmp=0;
  keyInfo.rngFlg=optREV.set;
  while(1){

    /*TraEndλ*/
    if(statT==EOF){
      break;
    }

    /*MstEndλ*/
    if(statM==EOF){
      if(optTNL.set){
        writeTM(frT, NULL);
        statT=readT(fprT,frT);
        continue;
      }else{
        break;
      }
    }

    /*  */
    setKeyInfo(&keyInfo,frT,frdM);

    if(keyInfo.keyCmp == 1){       /*-k,-Kˤ T>M*/
      statM=mssReadFRD(fprM,frdM);
    }else if(keyInfo.keyCmp ==-1){ /*-k,-Kˤ T<M*/
      if(optTNL.set){
        writeTM(frT, NULL);
      }
      statT=readT(fprT,frT);
    }else{                         /*-k,-Kˤ T==M*/

      /*-k,-KƱϰϤӤ٤*/
      while(1){
        if( keyInfo.rngCmp==9 ){        /* ƱǤʤ */
          break;
        } else if( keyInfo.rngCmp== 1){ /* Tr>Mr */
          statM=mssReadFRD(fprM,frdM);
          if(statM==EOF) break;
        } else if( keyInfo.rngCmp==-1){ /* Tr<Mr */
          if(optRNL.set){
            writeTM(frT, NULL);
          }
          statT=readT(fprT,frT);
          if(statT==EOF) break;
        }else{            /* Tr=Mr MrθߤϰäƤ*/
          writeTM(frT,frdM);
          statT=readT(fprT,frT);
          if(statT==EOF) break;
        }
        setKeyInfo(&keyInfo,frT,frdM);
      }
    }
  }
  mssFreeFldRec(frT);
  mssFreeFRD(frdM);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν              */
  mssCloseFPR(fprT);      /*ϥեΥ      */
  mssCloseFPR(fprM);      /*ϥեΥ      */
  mssCloseFPW(fpw);       /*ϥեΥ      */
  mssFreeFields(sfT);     /*ȹܹ¤Τΰ賫  */
  mssFreeFields(sfM);     /*ȹܹ¤Τΰ賫  */
  mssFreeHeader(hdT);     /*ϥإåΰ賫          */
  mssFreeHeader(hdM);     /*ϥإåΰ賫          */
  mssFreeHeader(hdo);     /*ϥإåΰ賫          */
  mssFreeOption(opt);     /*ץΰ賫          */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
