/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : (2003/08/07)                                                 */
/*============================================================================*/

#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ppm2xtHelp.h>
struct mssComHelp comHelp={
  "ppm2xt",       /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};

extern struct mssGlobalVariables mssGV;

/*βԤޤɤ߹ߡμʸ֤*/
int skipComment(FILE *fpr){
  int c;

  while(1){
    c=fgetc(fpr);
    if(c==EOF) break;

    if(c=='\n'){
      break;
    }
  }
  return(c); /*to avoid warning message*/
}

/*
 * PPMե뤫顢Ĥͤbuf˥åȤ롣
 * ĤͤȤϥǥߥ(' ','\t','\n'Ƕڤ줿ʸΤ
 */
int readOneValuePPM(char *buf, FILE *fpr ){
  int c;
  int cnt=0;

  while(1){
    c=fgetc(fpr);
    if(c==EOF) break;

    /*Ƚ*/
    if(cnt==0 && c=='#') {
      c=skipComment(fpr);
      if(c==EOF) break;
    }

    /*ʣΥǥߥϥåפ*/
    if( cnt==0 && (c==' ' || c=='\t' || c=='\n') ){
      if(c=='\n') mssGV.inCnt++;
      continue;
    }

    /*ǥߥΥå*/
    if(c==' ' || c=='\t' || c=='\n'){
      if(c=='\n') mssGV.inCnt++;
      *(buf+cnt)='\0';
      break;
    }

    /*Ķ뤳ȤϤʤϤ*/
    if(cnt>=8){
      mssShowErrMsg("detected the too large number of a pixel element");
      mssEnd(mssErrorNoDefault);
    }

    *(buf+cnt++)=(unsigned char)c;
  }
  return(c);
}

int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptSTR optINF={
    OSTR,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե                                                   */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen, /* ʸκĹ                                    */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optINF,&optOTF,NULL};

  FILE *fpr;
  struct mssHeader *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPW    *fpw; /*ϥե빽¤*/
  char buf[20];
  char bufr[20];
  char bufg[20];
  char bufb[20];
  int magicNo;
  int xlen,ylen,depth;

  int x,y;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  if (optINF.set) {
    fpr=fopen(optINF.str,"r");
    if(fpr==NULL){
      mssShowErrMsg("cannot open file: %s",optINF.str);
      mssEnd(mssErrorNoDefault);
    }
  } else {
    fpr=stdin;
  }

/*prnOption(opt);*/
/*prnHeader(hdi);*/

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  hdo=mssInitHeader(NULL,NULL);
  mssAddFieldsByStr( hdo->flds, "X");
  mssAddFieldsByStr( hdo->flds, "Y");
  mssAddFieldsByStr( hdo->flds, "Red");
  mssAddFieldsByStr( hdo->flds, "Green");
  mssAddFieldsByStr( hdo->flds, "Blue");
  mssSetFldInfoSort(*(hdo->flds->fi+1),1,0,1);
  mssSetFldInfoSort(*(hdo->flds->fi+0),2,0,1);

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,0,0);
  mssWriteHeader(hdo,fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/
  /*----- PPMإåɤ߹*/
  /*ޥåʥС*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  if( strlen(buf)!=2 ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  if( *buf!='P' ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  magicNo=atoi(buf+1);
  if( magicNo!=3 ){
    mssShowErrMsg("this command can handle only an ascii format of PPM");
    mssEnd(mssErrorNoDefault);
  }

  /*XĹ*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  xlen=atoi(buf);

  /*YĹ*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  ylen=atoi(buf);

  /*ͤκ*/
  if(EOF == readOneValuePPM(buf,fpr) ){
    mssShowErrMsg("invalid PPM header");
    mssEnd(mssErrorNoDefault);
  }
  depth=atoi(buf);
 
  /*----- ǡɤ߹*/
  for(y=0; y<ylen; y++){
    for(x=0; x<xlen; x++){
      /*red*/
      if(EOF == readOneValuePPM(bufr,fpr) ){
        mssShowErrMsg("inconsistent data size and PPM header");
        mssEnd(mssErrorNoDefault);
      }

      /*green*/
      if(EOF == readOneValuePPM(bufg,fpr) ){
        mssShowErrMsg("inconsistent data size and PPM header");
        mssEnd(mssErrorNoDefault);
      }

      /*blue*/
      if(EOF == readOneValuePPM(bufb,fpr) ){
        mssShowErrMsg("inconsistent data size and PPM header");
        mssEnd(mssErrorNoDefault);
      }
      mssWriteInt(x,fpw);
      mssWriteDlm(fpw);
      mssWriteInt(y,fpw);
      mssWriteDlm(fpw);
      mssWriteInt(atoi(bufr),fpw);
      mssWriteDlm(fpw);
      mssWriteInt(atoi(bufg),fpw);
      mssWriteDlm(fpw);
      mssWriteInt(atoi(bufb),fpw);
      mssWriteRet(fpw);
      mssGV.outCnt++;
    }
  }

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν*/
  fclose(fpr);            /*ϥեΥ*/
  mssCloseFPW(fpw);       /*ϥեΥ*/
  mssFreeHeader(hdo);     /*ϥإåΰ賫*/
  mssFreeOption(opt);     /*ץΰ賫*/
  mssShowEndMsg();        /*λå*/
  mssEnd(mssExitSuccess); /*λ*/
  return(0); /* to avoid warning message*/
}
