 
#ifndef WIDGETBASE_H
#define WIDGETBASE_H
/**********************************************************************

  widgetsbase.h

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qapplication.h>
#include <qpushbutton.h>
#include <qfont.h>
#include <qtabwidget.h>
#include <qtable.h>
#include <qcanvas.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qstringlist.h>
#include <qcombobox.h>
#include <qvaluelist.h>
#include <qptrlist.h>
#include "canvas.h"
#include "soolist.h"
#include "tabledialog.h"


typedef QValueList<int>     IntList;


class WidgetsBase : public QWidget
{
    Q_OBJECT

public:
    WidgetsBase( QWidget *parent=0, const char *name=0 );
    
protected:

    QGridLayout* WidgetsBaseLayout;
    QTabWidget*  TabWidget2;
    QHBoxLayout* Layout2;
    QHBoxLayout* Layout3;
    QWidget* tab_2;
    QWidget* tab_3;
    QWidget* tab_4;
    QTable* table_key;
    QTable* table_file;
    
    QCanvas* canvas_key;
    
    FigureEditor* editor;

    QGridLayout* tabLayout_4;
    QGridLayout* tabLayout_3;
    QGridLayout* tabLayout_2;
    
    QWidget*     hbutton1;
    QHBoxLayout* Hbox1;
    QWidget*     hbutton2;
    QHBoxLayout* Hbox2;

    QLabel*      dirLabel;
    
    QPushButton* openbutton;
    QPushButton* quitbutton;
    QPushButton* keymakebutton;
    QPushButton* keyanabutton;
    
    QPushButton* integbutton;
    QPushButton* sepabutton;
    QPushButton* sortbutton;
    QPushButton* morebutton;
    QPushButton* addpartbutton;
    QPushButton* rmvpartbutton;
    QComboBox*   boxuse;
    QComboBox*   boxuseno;
    QComboBox*   clusternum;

    QFileDialog* fileDialog;
    QStringList  filelist;
    QString      dirpath;
    QString      dirpath4work;
    
    QStringList  partlist;
    QStringList  partlistno;

    bool         keymake_state;
    
    SooList     solist;
    SooListList solistlist;

    IntList     checklist;
    
    int         numSentIndex;
    
    tableDPtrList tableDlist;

public slots:
    void  loadFilename();
    void  makeKeyword();
    void  anaKeyword();
    void  boxuseHighlighted( int index );
    void  rmvSoByPart();
    void  addSoByPart();
    void  integSo();
    void  sepaSo();
    void  sortList();
    void  moreInfo();
};

#endif
