/**********************************************************************

  textdialog.cpp

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qlabel.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qfont.h>
#include <qcolor.h>
#include <qtextcodec.h>
#include <qregexp.h>

#include <qmessagebox.h>

#include "textdialog.h"
#include "soolist.h"


textDialog::textDialog( QString filename , QStringList wordlist )
    : QDialog()

{

    setCaption( filename );
    resize( 540, 440 );
    
    QTextCodec* codec = QTextCodec::codecForName("eucJP");

    tableButtonBox = new QVBoxLayout( this, 11, 6, "table button box layout" );

    fileLabel = new QLabel ( "  keyword :   " , this , "dirLabel" );
    fileLabel->setFrameStyle( QFrame::Panel );
    QString labeltext( "  keyword :   " );
    tableButtonBox->addWidget( fileLabel );

    textedit = new QTextEdit( this, "text data" );
    textedit->setReadOnly(TRUE);
    
    QFile f( filename );
    if ( f.open(IO_ReadOnly) ) {    // ե򳫤Τ
        QTextStream t( &f );        // ƥȥȥ꡼Ѥ
        t.setEncoding( QTextStream::UnicodeUTF8 );
        

        while ( !t.eof() ) {        // եޤ...
	      textedit->append( "////////////////////\n" );
	      textedit->append( "//////////\n" );
              QString s = t.readLine();       // line of text excluding '\n'
	      s = s.replace( QRegExp( codec->toUnicode("") ), "\n//////////\n" );
              s.append( "\n" );
	      textedit->append( s );
        }

        f.close();
    }

    
    int colorDist = 128 / wordlist.count();
    int colorIndex = 0;
    int selNum = 1;
    for( QStringList::Iterator itSL = wordlist.begin(); itSL != wordlist.end(); ++itSL ){
        int para  = 0;
        int index = 0;
        QString target = (*itSL);
	labeltext.append( target );
	labeltext.append( "   " );
        //QFont font;

        int gval = 127 + colorDist * colorIndex;
        if( gval > 256 ) gval = 255;
        if( gval < 0 )   gval = 0;
        int bval = 255 - colorDist * colorIndex;
        if( bval > 256 ) gval = 255;
        if( bval < 0 )   gval = 0;	
        QColor selectColor( 0, gval, bval );
        while( textedit->find( target , TRUE, FALSE, TRUE, &para, &index) ){
	    textedit->setSelection( para, index, para, index+target.length(), selNum );
	    textedit->setSelectionAttributes( selNum , selectColor , TRUE );
	
	    index++;
	    selNum++;

        }
	colorIndex++;
    }
    
    
    fileLabel->setText( labeltext );
    
    tableButtonBox->addWidget( textedit );

    buttonBox = new QHBoxLayout( 0, 0, 6, "button box layout" );


    QSpacerItem *spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding,
						 QSizePolicy::Minimum );
    buttonBox->addItem( spacer );

    closeButton = new QPushButton( this, "closebutton" );
    closeButton->setText( "close" );
    closeButton->setDefault( TRUE );
    buttonBox->addWidget( closeButton );

    
    tableButtonBox->addLayout( buttonBox );

    connect( closeButton, SIGNAL( clicked() ), this, SLOT( accept() ) );

}

textDialog::~textDialog()
{
    if( fileLabel != NULL ){
        delete fileLabel;
    }
    if( textedit != NULL ){
        delete textedit;
    }
    if( closeButton != NULL ){
        delete closeButton;
    }
    if( buttonBox != NULL ){
        delete buttonBox;
    }
    if( tableButtonBox != NULL ){
        delete tableButtonBox;
    }

}



void textDialog::accept()
{

    QDialog::accept();
}
