/**********************************************************************

  tabledialog.h

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qtextcodec.h>

#include <qmessagebox.h>

#include "tabledialog.h"
#include "textdialog.h"
#include "soolist.h"

void tableDialog::moreInfo()
{
    for( int ptrindex = ptrtableDList->count()-1 ; ptrindex >= 0 ; ptrindex-- ){
	 if( TRUE == ptrtableDList->at( uint(ptrindex) )->getKillFlag() ){
    	     ptrtableDList->remove( uint(ptrindex) );
    	 }
    }


    int currentRow = table_key->currentRow();
    if( currentRow < 0 )                  return;
    if( currentRow >= int(soolist.count()) )   return;
    QString indexStr = table_key->text( currentRow , 0 );
    if( indexStr == "" )                  return;
    int index = indexStr.toInt();

    bool sit = FALSE;
    SooList::Iterator itLsave;
    for( SooList::Iterator itL = soolist.begin(); itL != soolist.end(); ++itL ){
         if( (*itL).getIndex() == index ){
	     itLsave = itL;
             sit = TRUE;
         }
    }
    if( sit == FALSE ) return;
    
    QStringList wordlisttot;
    for( int ptrindex = ptrtableDList->count()-1 ; ptrindex >= 0 ; ptrindex-- ){
         if( NULL != ptrtableDList->at( uint(ptrindex) ) ){
    	     QStringList tmplist = ptrtableDList->at( uint(ptrindex) )->getWordOrgList();
	     
	     for( QStringList::Iterator itSL = tmplist.begin(); itSL != tmplist.end(); ++itSL ){
	          wordlisttot.append( (*itSL) );
	     }
    	 }
    }
    
    textDialog *textD = new textDialog( (*itLsave).getFileNameUni() , wordlisttot );
    textD->show();

}

tableDialog::tableDialog( SooList tmpsoolist , tableDPtrList* tmptableDList )
    : QDialog()

{

    //tableDlist.setAutoDelete( TRUE );
    
    soolist = tmpsoolist;
    ptrtableDList = tmptableDList;

    if( soolist.count() <= 0 ) accept();

    SooList::Iterator itL = soolist.begin();
    QString baseFromSo = (*itL).getWordBase();
    setCaption( baseFromSo );
    resize( 540, 440 );

    
    QTextCodec* codec = QTextCodec::codecForName("eucJP");
    
    tableButtonBox = new QVBoxLayout( this, 11, 6, "table button box layout" );

    table_key = new QTable( this, "data table" );
    //table_key->setNumCols( 10 );
    table_key->setNumCols( 5 );
    table_key->setNumRows( soolist.count() );
    QHeader *header_key = table_key->horizontalHeader();
    header_key->setLabel( 0, QObject::tr( "index" ), 60 );
    header_key->setLabel( 1, QObject::tr( "filename" ), 120 );
    header_key->setLabel( 2, QObject::tr( "word" ) );
    header_key->setLabel( 3, QObject::tr( "kana" ) );
    header_key->setLabel( 4, QObject::tr( "part" ) );
    header_key->setMovingEnabled(TRUE);
    table_key->setColumnReadOnly( 0 , TRUE );
    table_key->setColumnReadOnly( 1 , TRUE );
    table_key->setColumnReadOnly( 2 , TRUE );
    table_key->setColumnReadOnly( 3 , TRUE );
    table_key->setColumnReadOnly( 4 , TRUE );

    tableButtonBox->addWidget( table_key );

    long index_table = 0;
    for( SooList::Iterator itL = soolist.begin(); itL != soolist.end(); ++itL ){

         QString dirPlusFile = (*itL).getFileName();
	 QStringList list = QStringList::split( "/" , dirPlusFile );
	 QStringList::Iterator it = list.end(); it--;
	 QString fileNotDir = (*it);
    
         table_key->setText( index_table , 0 , QString::number( (*itL).getIndex() ) );
	 table_key->setText( index_table , 1 , fileNotDir );
         table_key->setText( index_table , 2 , (*itL).getWordOrg() );
         table_key->setText( index_table , 3 , (*itL).getWordKana() );
         table_key->setText( index_table , 4 , (*itL).getWordPart() );

         index_table++;
    }

    
    buttonBox = new QHBoxLayout( 0, 0, 6, "button box layout" );


    QSpacerItem *spacer = new QSpacerItem( 0, 0, QSizePolicy::Expanding,
						 QSizePolicy::Minimum );
    buttonBox->addItem( spacer );
    
    moreButton = new QPushButton( this, "morebutton" );
    moreButton->setText( codec->toUnicode("ܺ") );
    //moreButton->setDefault( TRUE );
    buttonBox->addWidget( moreButton );

    closeButton = new QPushButton( this, "closebutton" );
    closeButton->setText( "close" );
    closeButton->setDefault( TRUE );
    buttonBox->addWidget( closeButton );

    
    tableButtonBox->addLayout( buttonBox );

    connect( closeButton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( moreButton, SIGNAL( clicked() ), this, SLOT( moreInfo() ) );

    killFlag = FALSE;
}

 tableDialog::~tableDialog()
{
    if( table_key != NULL ){
        delete table_key;
    }
    if( moreButton != NULL ){
        delete moreButton;
    }
    if( closeButton != NULL ){
        delete closeButton;
    }
    if( buttonBox != NULL ){
        delete buttonBox;
    }
    if( tableButtonBox != NULL ){
        delete tableButtonBox;
    }

}

QStringList tableDialog::getWordOrgList()
{
    QStringList wordlist;
       
    for( uint index_table = 0 ; index_table < soolist.count() ; index_table++ ){
    
         QString tmpWordOrg = table_key->text( index_table , 2 );
	 bool sit = FALSE;
         for( QStringList::Iterator itSL = wordlist.begin(); itSL != wordlist.end(); ++itSL ){
             if( (*itSL) == tmpWordOrg ){
		sit = TRUE;
             }
         }
         if( sit == FALSE ){
	     wordlist.append( tmpWordOrg );
	 }

    }

    return wordlist;
}


void tableDialog::accept()
{

    killFlag = TRUE;
    
    QDialog::accept();
}


void tableDialog::done(int r)
{

    killFlag = TRUE;

    QDialog::done( r );
}
