 
#ifndef CANVAS_H
#define CANVAS_H
/**********************************************************************

  canvas.h

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
**********************************************************************/
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qintdict.h>
#include <qcanvas.h>
#include <qstring.h>

class TextItem;
class EdgeItem;
class NodeItem;

class TextItem: public QCanvasText
{
public:
    TextItem( NodeItem*, const QString & t , QCanvas *canvas );
    static int count() { return c; }
private:
    static int c;
};

class EdgeItem: public QCanvasLine
{
public:
    EdgeItem( NodeItem*, NodeItem*, QCanvas *canvas );
    void setFromPoint( int x, int y ) ;
    void setToPoint( int x, int y );
    static int count() { return c; }
    void moveBy(double dx, double dy);
private:
    static int c;
};

class NodeItem: public QCanvasEllipse
{
public:
    NodeItem( QCanvas *canvas );
    ~NodeItem() {}
    void addText( TextItem *tttt ) { textList.append( tttt ); }
    void addInEdge( EdgeItem *edge ) { inList.append( edge ); }
    void addOutEdge( EdgeItem *edge ) { outList.append( edge ); }
    void moveBy(double dx, double dy);
private:
    QPtrList<TextItem> textList;
    QPtrList<EdgeItem> inList;
    QPtrList<EdgeItem> outList;
};


class FigureEditor : public QCanvasView {
    Q_OBJECT
public:
    FigureEditor(QCanvas&, QWidget* parent=0, const char* name=0, WFlags f=0);
    void clear();
protected:
    void contentsMousePressEvent(QMouseEvent*);
    void contentsMouseMoveEvent(QMouseEvent*);
signals:
    void status(const QString&);
private:
    QCanvasItem* moving;
    QPoint moving_start;
};

#endif

