
/**********************************************************************

  canvas.cpp

  Author    : fuja2 ( fuja2 at bj8 dot so-net dot ne dot jp )
  created at: Sun. Apr.11  23:59:03 JST 2004
  edited  at: 

  Copyright (C) 2004  Kazuo Sonobe, All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**********************************************************************/
#include <qdatetime.h>
#include <qmainwindow.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qmenubar.h>
#include <qapplication.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qlabel.h>
#include <qimage.h>
#include <qprogressdialog.h>
#include <qstring.h>
#include <qcolor.h>
#include "canvas.h"
#include <stdlib.h>

static QBrush* tb = new QBrush( Qt::yellow );
static QPen*   tp = new QPen( Qt::black );


static const int imageRTTI = 984376;
class ImageItem: public QCanvasRectangle
{
public:
    ImageItem( QImage img, QCanvas *canvas );
    int rtti () const { return imageRTTI; }
    bool hit( const QPoint&) const;
protected:
    void drawShape( QPainter & );
private:
    QImage image;
    QPixmap pixmap;
};
ImageItem::ImageItem( QImage img, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(img)
{
    setSize( image.width(), image.height() );
#if !defined(Q_WS_QWS)
    pixmap.convertFromImage(image, OrderedAlphaDither);
#endif
}
void ImageItem::drawShape( QPainter &p )
{
// Qt/Embedded Ǥϡ® QPixmap Ȥ QImage 褹뤳ȤǤ롣
// ¾ΥץåȥեǤ QPixmap Ȥɬפ
#if defined(Q_WS_QWS)
    p.drawImage( int(x()), int(y()), image, 0, 0, -1, -1, OrderedAlphaDither );
#else
    p.drawPixmap( int(x()), int(y()), pixmap );
#endif
}
bool ImageItem::hit( const QPoint &p ) const
{
    int ix = p.x()-int(x());
    int iy = p.y()-int(y());
    if ( !image.valid( ix , iy ) )
        return FALSE;
    QRgb pixel = image.pixel( ix, iy );
    return qAlpha( pixel ) != 0;
}



int TextItem::c = 0;
//void TextItem::moveBy(double , double )
//{
//    //⤷ʤ
//    //QCanvasText::move( dx , dy );
//}
TextItem::TextItem( NodeItem *node, const QString & t , QCanvas *canvas )
    : QCanvasText( t , canvas )
{
    c++;
    QColor selectColor( 0, 0, 255 );
    setColor( selectColor );
    node->addText( this );
    setX( double(node->x()) );
    setY( double(node->y()) );
    //move( double(node->x()) , double(node->y()) );
    setZ( 129 );
}

int EdgeItem::c = 0;
void EdgeItem::moveBy(double, double)
{
    //⤷ʤ
}
EdgeItem::EdgeItem( NodeItem *from, NodeItem *to, QCanvas *canvas )
    : QCanvasLine( canvas )
{
    c++;
    setPen( *tp );
    setBrush( *tb );
    from->addOutEdge( this );
    to->addInEdge( this );
    setPoints( int(from->x()), int(from->y()), int(to->x()), int(to->y()) );
    setZ( 127 );
}
void EdgeItem::setFromPoint( int x, int y )
{
    setPoints( x,y, endPoint().x(), endPoint().y() );
}
void EdgeItem::setToPoint( int x, int y )
{
    setPoints( startPoint().x(), startPoint().y(), x, y );
}
void NodeItem::moveBy(double dx, double dy)
{
    QCanvasEllipse::moveBy( dx, dy );
    
    QPtrListIterator<TextItem> itT( textList );
    TextItem *tttt;
    while (( tttt = itT.current() )) {
        ++itT;
        tttt->setX( double(x()) );
	tttt->setY( double(y()) );
    }
    
    QPtrListIterator<EdgeItem> it1( inList );
    EdgeItem *edge;
    while (( edge = it1.current() )) {
        ++it1;
        edge->setToPoint( int(x()), int(y()) );
    }
    QPtrListIterator<EdgeItem> it2( outList );
    while (( edge = it2.current() )) {
        ++it2;
        edge->setFromPoint( int(x()), int(y()) );
    }
}
NodeItem::NodeItem( QCanvas *canvas )
    : QCanvasEllipse( 60, 60, canvas )
{
    setPen( *tp );
    setBrush( *tb );
    setZ( 128 );
}
FigureEditor::FigureEditor(
        QCanvas& c, QWidget* parent,
        const char* name, WFlags f) :
    QCanvasView(&c,parent,name,f)
{
}
void FigureEditor::contentsMousePressEvent(QMouseEvent* e)
{
    QPoint p = inverseWorldMatrix().map(e->pos());
    QCanvasItemList l=canvas()->collisions(p);
    for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
        if ( (*it)->rtti() == imageRTTI ) {
            ImageItem *item= (ImageItem*)(*it);
            if ( !item->hit( p ) )
                 continue;
        }
        moving = *it;
        moving_start = p;
        return;
    }
    moving = 0;
}
void FigureEditor::clear()
{
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }
}
void FigureEditor::contentsMouseMoveEvent(QMouseEvent* e)
{
    if ( moving ) {
        QPoint p = inverseWorldMatrix().map(e->pos());
        moving->moveBy(p.x() - moving_start.x(),
                       p.y() - moving_start.y());
        moving_start = p;
        canvas()->update();
    }
}

