#!/usr/bin/env bash

#*****************************************************************************
# xtbseq.sh
# uhAwV[PX̍쐬
# Y.Hamuro
# 1.0b 2004/03/08
# 1.0  -u ̒ǉ,gbvΉ 2004/11/26
#*****************************************************************************

#G[bZ[W
function help {
cat >/dev/stderr <<EOF
----------------------
xtbseq.sh version 1.0
----------------------
Tv) uhAwV[PX쐬B

) xtbseq.sh -c ڋqږ -d tږ -b uhږ
                -B Aw [-u]
                [-A IAwO̗X(default=0)]
                [-C IAw̗X(default=0)]
                [-it@C] [-oo̓t@C] [-T [NfBNg]
                [-V] [-h]
      -u : uh̘Awj[NȘAŵ݂Ɍ肷
      -V : R}h̊bZ[W\B
      -h : wv̕\

l) ̓t@C̍ږƂ"targetBrand","seqNo","term"3͗psB

1) xtbseq.sh -c ڋq -d t -b uh -B 3 -i dat.xt -o rsl.xt
2) xtbseq.sh -c ڋq -d t -b uh -B 3 -u -i dat.xt -o rsl.xt
3) xtbseq.sh -c ڋq -d t -b uh -B 3 -A 5 -C 3 -i dat.xt -o rsl.xt
EOF
exit 1
}

#bZ[WpɃR}hCۑ
cmdLine="$0 $*"

#ftHgł́AR}h̃bZ[WOFF
export mssQuiet=1

#VOiɂI
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}


brandUniq="0"
#p[^̃`FbNZbg
  while getopts ":c:d:b:B:A:C:i:o:uVh" opt; do
    case $opt in
      c  ) CUST=$OPTARG ;;
      d  ) DATE=$OPTARG ;;
      b  ) BRAND=$OPTARG ;;
      B  ) minSeqCnt=$OPTARG ;;
      A  ) aVisit=$OPTARG ;;
      C  ) cVisit=$OPTARG ;;
      i  ) input=$OPTARG ;;
      o  ) output=$OPTARG ;;
      T  ) tmpD=$OPTARG ;;
      u  ) brandUniq="1" ;;
      V  ) mssQuiet=0 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$tmpD" = "" ]; then
    tmpD=/tmp
  fi
  if [ "$input" = "" ]; then
    input=/dev/stdin
  fi
  if [ "$output" = "" ]; then
    output=/dev/stdout
  fi
  if [ "$CUST" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -c is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$DATE" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$BRAND" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -b is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$minSeqCnt" = "" ]; then
    echo "#ERROR# $$ \"$0\" \"option -B is mandatory\"" >/dev/stderr
    exit 1
  fi
  if [ "$aVisit" = "" ]; then
    aVisit=0
  fi
  if [ "$cVisit" = "" ]; then
    cVisit=0
  fi

#[Nt@C
TD=$tmpD/mss-xtbseq1-$$

#gbv
trap endByInt INT QUIT TERM HUP

# ==============================================================================
# 菇O) ̃XNvgŗp鍀ڈȊO̍ږXg쐬
# ------------------------------------------------------------------------------
# ex)
# ̓f[^̍ : ڋq,t,uh,z,
#     p鍀 : ڋq,t,uh
#  OTHERFIELD=",z,"
# ==============================================================================
echo "#MSG# $$ \"$0\" \"preprocessing\"" >/dev/stderr
mkfifo $TD-xxfifo

echo "$CUST,$DATE,$BRAND" |
tr ',' '\n' |
gawk '{print $1,NR}' |
sort >$TD-xxfld2

xtbest -R 0 <$TD-xxfifo |
xt2txt -F |
tr ' ' '\n' |
gawk '{print $1,NR}' |
sort >$TD-xxfld1 &

function setOtherField {
  xtcommon -t -r -k 1 -m $TD-xxfld2 -i $TD-xxfld1 -o $TD-xxfld3

  if [ -s  $TD-xxfld3 ] ; then
    xtsort -t -k 2%n -i $TD-xxfld3 |
    xtcut -t -f 1 |
    tr '\n' ',' |
    sed 's/,$//' >$TD-xxfld4
    OTHERFIELD=",`cat $TD-xxfld4`"
  else
    OTHERFIELD=""
  fi
}

# ==============================================================================
# 菇P) tA(custDateSeqNo)̍쐬
# ------------------------------------------------------------------------------
# 쐬f[^C[W
#  ڋq,t,uh,uhA
# a 20030101 A 1
# a 20030104 A 2
# a 20030108 A 3
# a 20030112 B 4
# a 20030113 A 5 +
# a 20030113 B 5 +->t͓ԍ
# a 20030115 B 6
# a 20030118 B 7
# ==============================================================================
echo "#MSG# $$ \"$0\" \"creating date sequence number\"" >/dev/stderr

tee $TD-xxfifo <$input |

# uhw͍lɓȂ(j[Nɂ)
xtuniq -k $CUST,$DATE,$BRAND |

# ڋqtŘAԂӂ
xtnumber -k $CUST,$DATE -B -a '##custDateSeqNo##' -o $TD-xxds

# ==============================================================================
# 菇Q) uhAw͈̓}X^[̍쐬
# ------------------------------------------------------------------------------
#   Ow(aVisit)  uhminSeqCntȏAw  w(cVisit)
#
# uhAwƂ
#   ɕ̃uhwĂĂAƃJEg
#
# ex1)  AA(AB)(AC)A ATAwĂ(ʓ͓̍w)
#
# ------------------------------------------------------------------------------
# 쐬f[^C[W
# :1.ڋq 2.JntA 3.ItA 4.uh 5.seqNo 6.term
# a -4 0 A 2 a   -> Ow-40ڂ܂(Ow͂ȂƂ)
# a  1 3 A 2 b   -> a15ڗXAuh̘Aw
# a  4 8 A 2 c   -> w48ڂ܂
# ==============================================================================
echo "#MSG# $$ \"$0\" \"creating range master file\"" >/dev/stderr

# ڋquhʂɘAt(custDateSeqNo)ɓԍ
# (custDateSeqNoƂłƂƂ́Auh̘AwłȂ)
xtcal -k $CUST,$BRAND -s $DATE%r -c \
  'if(keyLine()==1,
     1,
     if((prvField($##custDateSeqNo##)-1)==$##custDateSeqNo##,
       prvResult(),
       prvResult()+1))' -a seqNo -i $TD-xxds |

# uhAwɂ͓seqNotĂ̂ŁA̍swminSeqCnt
# ȏ̂̂̂ݑI(uhAw̑I)
xtsel -k $CUST,$BRAND,seqNo -c 'keyCnt()>='$minSeqCnt -o $TD-xxc

#Lŋ߂uhAw̍ŏƍŌcustDateSeqNo߂
xtbest -k $CUST,$BRAND,seqNo -s '##custDateSeqNo##%n'  -R 1 -i $TD-xxc -o $TD-xxmin
xtbest -k $CUST,$BRAND,seqNo -s '##custDateSeqNo##%nr' -R 1 -i $TD-xxc -o $TD-xxmax

# uhAw̑OaVisit͈̔̓}X^[쐬(term="a")
xtcal  -c '$##custDateSeqNo##-1'           -a to -i $TD-xxmin |
xtcal  -c '$##custDateSeqNo##-'$aVisit -a from |
xtcut  -f $CUST,from,to,$BRAND:targetBrand,seqNo |
xtsetchr -v a -a term -o $TD-xxd

# uhAw͈̔̓}X^[쐬(term="b")
xtjoin -k $CUST,$BRAND,seqNo -m $TD-xxmax -f '##custDateSeqNo##':to -i $TD-xxmin |
xtcut  -f $CUST,'##custDateSeqNo##':from,to,$BRAND:targetBrand,seqNo |
xtsetchr -v b -a term -o $TD-xxe

# uhAw̌cVisit͈̔̓}X^[쐬(term="c")
xtcal  -c '$##custDateSeqNo##+1'           -a from -i $TD-xxmax |
xtcal  -c '$##custDateSeqNo##+'$cVisit -a to |
xtcut  -f $CUST,from,to,$BRAND:targetBrand,seqNo |
xtsetchr -v c -a term -o $TD-xxf

#LR̃t@C𕹍A͈̓}X^[ƂB
xtcat -i $TD-xxd,$TD-xxe,$TD-xxf |
xtsort -k $CUST,from,to,targetBrand,seqNo,term -o $TD-xxm

# ==============================================================================
# 菇R) L菇PƂQō쐬ꂽt@CgA
#         AuhV[PXf[^쐬
# ------------------------------------------------------------------------------
#  ڋq,t,uh,tA
# a 20030101 A 1
# a 20030104 A 2
# a 20030108 A 3
# a 20030112 B 4
# a 20030113 A 5
# a 20030113 B 5
# a 20030115 B 6
# a 20030118 B 7
#
# L̃t@C̓tAԂƉL̃t@C̘AԂ͈̔͂˂킹A
# ͈͓ɓĂ(closed range)L̃t@C4-6joinB
# uhAԂ͈̔͂ɑ鎞́AQso͂B
#
# :1.ڋq 2.JntA 3.ItA 4.uh 5.seqNo 6.term
# a -4 0 A 2 a
# a  1 3 A 2 b
# a  4 8 A 2 c
#
# ʂ͈ȉ̒ʂBƂ͓Kɕ׊
#  
# a 20030101 A 1 A 2 b
# a 20030104 A 2 A 2 b
# a 20030108 A 3 A 2 b
# a 20030112 B 4 A 2 c
# a 20030113 A 5 A 2 c
# a 20030113 B 5 A 2 c
# a 20030115 B 6 A 2 c
# a 20030118 B 7 A 2 c
# ==============================================================================
echo "#MSG# $$ \"$0\" \"creating brand sequence pattern\"" >/dev/stderr

# {XNvgŗpĂȂږ̃Zbg
setOtherField

if [ "$brandUniq" = "0" ]; then

# uhAԂ͈͂œ˂킹XCb`ԍ
xtnrjoin -k $CUST -v '##custDateSeqNo##%n' -m $TD-xxm -R from,to%e -f targetBrand,seqNo,term -i $TD-xxds |

# Kvڂ𔲂
xtcut -f $CUST,targetBrand,seqNo,term,$DATE,$BRAND$OTHERFIELD |

# ₷̂߂̃\\[g
xtsort -k $CUST,targetBrand,seqNo,term,$DATE >$output

else

# uhAԂ͈͂œ˂킹XCb`ԍ
xtnrjoin -k $CUST -v '##custDateSeqNo##%n' -m $TD-xxm -R from,to%e -f targetBrand,seqNo,term -i $TD-xxds |

# Kvڂ𔲂
xtcut -f $CUST,targetBrand,seqNo,term,$DATE,$BRAND$OTHERFIELD -o $TD-xxrsl

#j[NłȂAw}X^[̍쐬
xtselstr -f term -v b -i $TD-xxrsl |
xtcut -f custID,targetBrand,seqNo,$BRAND |
xtuniq -k custID,targetBrand,seqNo,$BRAND |
xtcount -k custID,targetBrand,seqNo -a '##cnt##' |
xtsel -c '$##cnt##>1' -o $TD-xxbunq

xtcommon -k custID,targetBrand,seqNo -m $TD-xxbunq -r -i $TD-xxrsl |

# ₷̂߂̃\\[g
xtsort -k $CUST,targetBrand,seqNo,term,$DATE >$output
fi

#[Nt@C폜
rm -f $TD-xx*

#bZ[W\
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
# ==============================================================================
