#!/usr/bin/env bash

#*****************************************************************************
# xtnfold version 1.1
# 򺹸ѤΥǡåȤκ
# T.Nakahara
# 2002/01/12
# Y.Hamuro
# 2002/01/29 -tɲ, -dΥǥ쥯ȥ꤬Ǹ/ǽäƤɬѤʤ
# 2003/02/03 ߤΥޥɤб(1.0.1)
# 2004/01/21 top /bin/bash -> /usr/bin/env bash ѹ(ĻΤŦ)
# 2004/01/21 إפǥСɽ褦ѹ(1.0.2)
# 2004/11/29 ȥåɲ(1.1), -t 
#*****************************************************************************
#顼å
function help {
cat >/dev/stderr <<EOF
------------------------
xtnfold.sh version 1.1
------------------------
) 򺹸ѤΥǡåȤ롣
) xtnfold.sh -i ե -d ϥǥ쥯ȥ -n fold -c 饹
                 [-o ȥ졼˥󥰥ե̾] [-O ƥȥե̾]
                 [-S μ] [-t] [-V]
       -V : ޥɤδλåɽ롣
       -h : إפɽ
) -cǻꤵ줿ܤˤز롣
      -o⤷-OάС"##.train","##.test"Ȥե̾ˤʤ롣
) xtnfold.sh -i dat -d fold -n 5 -c Class -o fold##.train -O fold##.test
EOF
exit 1
}

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#ѥ᡼Υå
rName='##-train.xt'
sName='##-test.xt'
while getopts ":i:d:n:c:S:k:o:O:Vh" opt; do
  case $opt in
    i  ) input=$OPTARG ;;
    d  ) path=$OPTARG ;;
    n  ) fold=$OPTARG ;;
    c  ) cls=$OPTARG ;;
    S  ) sed=$OPTARG ;;
    o  ) rName=$OPTARG ;;
    O  ) sName=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$input" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -i is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$path" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$fold" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$cls" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -c is mandatory\"" >/dev/stderr
fi
if [ "$sed" = "" ]; then
   sed=-1
fi
if [ "$tmpD" = "" ]; then
  tmpD=/tmp
fi


#ȥ졼˥󥰤ȥƥȤƱ̾å
if [ "$rName" = "$sName" ]; then
  echo "#ERROR# $$ \"$0\" \"file names for training and test must be different\"" >/dev/stderr
  exit 1
fi

#ϥեå
if [ ! -f $input ]; then
  echo "#ERROR# $$ \"$0\" \"file not found : $input\"" >/dev/stderr
  exit 1
fi

#-dΤ"/"Ȥ
path=`echo $path | sed 's/\/*$//'`

#եΥץեå
wf=$tmpD/mss-xtnfold-$$

#ȥåȯư
trap endByInt INT QUIT TERM HUP

#ϥǥ쥯ȥ꤬¸ߤʤʤ
if [ ! -d $path ]; then
   mkdir -p $path
fi

#clsʬ뤿foldˤ碌clsֹդ
xtrand -a "##rand##" -S $sed -i $input |
xtcal  -k$cls -s "##rand##%n" -c 'down(keyLine()/(keyCnt()/'$fold'+0.00001),1)' -a "##val##" >$wf-03

#clsֹˤ碌Ƥ줾Υե˽Ϥ
loop=0
while [ "$loop" -lt "$fold" ]; do
  xtsel -c'$##val## -eq '$loop -i$wf-03\
        -u$wf-trn-$(($loop+1)) -o $wf-tst-$(($loop+1))
  loop=$((loop+1)) 
done;

loop=1
while [ $loop -le $fold ] ; do
  trnName=`echo $rName | sed 's/##/'$loop'/'`
  tstName=`echo $sName | sed 's/##/'$loop'/'`
  tprName=$wf-trn-$loop
  tpsName=$wf-tst-$loop

  xtcut -rf "##val##,##rand##" -i$tprName -o"$path"/$trnName
  xtcut -rf "##val##,##rand##" -i$tpsName -o"$path"/$tstName

  loop=$((loop+1)) 
done;

#ե
rm $wf-*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
# ==============================================================================
