#!/usr/bin/env bash

#*****************************************************************************
# xtmvavg.sh
# ưʿѻХץ
# Y.Hamuro
# 1.0b 2004/05/07
# 1.0 -kɲ,-fλˡѹ,ȥåб 2004/11/09
#*****************************************************************************

function help {
cat >/dev/stderr <<EOF
--------------------------
xtmvavg.sh version 1.0
--------------------------
) ưʿѤ׻롣
) xtmvavg.sh -k ̾ -s ¤ٴ̾ꥹ -f ׹̾:̾
                 -n ư [-i ϥե̾] [-oϥե̾]
                  [-T ǥ쥯ȥ̾] [-V] [-h]

      -V : ޥɤδλåɽ롣
      -h : إפɽ

1) xtmvavg.sh -s  -f :ưʿ -n 3 -i input.xt -o output.xt
2) xtmvavg.sh -s %r -f :ʿ,:ʿ -n 5 -i input2.xt -o output2.xt
3) xtmvavg.sh -k Ź -s  -f :ʿ -n 4 <input3.xt >output3.xt

1ϥǡ
--------------
input.xt
--------------
 
1 10
2 20
3 30
4 40
5 50
--------------
output.xt
--------------
  ưʿ
1 10 *
2 20 *
3 30 20
4 40 30
5 50 40
--------------
3 : (10+20+30)/3 = 20
4 : (20+30+40)/3 = 30
5 : (30+40+50)/3 = 40
EOF
exit 1
}

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
}

#ѥ᡼Υåå
while getopts ":k:s:f:n:a:i:o:T:Vh" opt; do
  case $opt in
    k  ) KEY=$OPTARG ;;
    s  ) SORT=$OPTARG ;;
    f  ) FLD=$OPTARG ;;
    n  ) MVCNT=$OPTARG ;;
    i  ) INPUT=$OPTARG ;;
    o  ) OUTPUT=$OPTARG ;;
    T  ) TMPD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$SORT" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -s is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$FLD" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$MVCNT" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$INPUT" = "" ]; then
   INPUT=/dev/stdin
fi
if [ "$OUTPUT" = "" ]; then
 OUTPUT=/dev/stdout
fi
if [ "$TMPD" = "" ]; then
   TMPD=/tmp
fi
if [ "$KEY" = "" ]; then
  KEY="#same#"
  KEYPAR=""
else
  KEYPAR=${KEY},
fi

#-sΥѥ᡼%ʬ -s %r -> SORTFLD= SORTPAR=r
SORTFLD=${SORT%\%*}
SORTPAR=${SORT#*%}
if [ "$SORTFLD" = "$SORTPAR" ]; then
  SORTPAR=""
else
  SORTPAR="%$SORTPAR"
fi

#-fΥѥ᡼ϥե̾Ƚϥե̾ʬ䤹
#-f a:b,c:d -> iFldList=a,c oFldList=b,d
ARRY=(${FLD//[,]/ })
iFldList=""
oFldList=""
for FN in "${ARRY[@]}"; do
  FN1=${FN%:*}
  FN2=${FN#*:}
  if [ "$FN1" = "$FN2" ] ; then
    echo "#MSG# $$ \"$0\" \"option -f must take fieldName:newFieldName\"" >/dev/stderr
    exit 1
  fi
  iFldList=$iFldList,$FN1
  oFldList=$oFldList,$FN2
done
iFldList=${iFldList#,}
oFldList=${oFldList#,}

#ե̾
TD="$TMPD/xtmvavg-$$"

#ȥåȯư
trap endByInt INT QUIT TERM HUP

#=====================================================
# ڥƥåף
# ϥեγƹԤư(-n)ʬduplicate
# ǤϢֹ(##mvSeq##)롣
# Ϣ֤ϴʤ˳ֹ򤺤餷Ƥ
#-----------------------------------------------------
#    ($INPUT: ʲιȤϤϥǡˤƤ)
# 1 10
# 2 20
# 3 30
# 4 40
# 5 50
#  
#   ##mvSeq##  ($TD-xxbase)
# 1 10 1001
# 1 10 1002
# 1 10 1003
# 2 20 1002
# 2 20 1003
# 2 20 1004
# 3 30 1003
# 3 30 1004
# 3 30 1005
# 4 40 1004
# 4 40 1005
# 4 40 1006
# 5 50 1005
# 5 50 1006
# 5 50 1007
#=====================================================
xtnumber -k $KEY -s $SORTFLD$SORTPAR -S 10000000 -a '##seqNo##' -i $INPUT |
xtsetchr -v $MVCNT -a days |
xtduprec -f days |
xtcal -k $KEYPAR'##seqNo##' -c '$##seqNo##+keyLine()' -a '##mvSeq##' |
xtcut -r -f 'days,##seqNo##' -o "$TD-xxbase"

#=====================================================
# ڥƥåף
# Υƥåף##mvSeq##򥭡ˤưưʿѤ뤬
# κݡư(-n)ʤΤϰ̣
# ʤ
# Ƿư(-n)##mvSeq##Ǥ
#-----------------------------------------------------
# ##mvSeq## ##cnt##  ($TD-xx2)
# 1003 3
# 1004 3
# 1005 3
#=====================================================
xtcut   -f $KEYPAR'##mvSeq##' -i $TD-xxbase | 
xtcount -k $KEYPAR'##mvSeq##' -a '##cnt##' |
xtsel   -c '$##cnt##=='$MVCNT -o $TD-xx2

#=====================================================
# ڥƥåף
# ##mvSeq##򥭡ˤưưʿѤ롣
# κݡ嵭ǵ᤿##mvSeq##ηư(-n)
# ԤΤߤ֡
#-----------------------------------------------------
# ##mvSeq## ##cnt##  ($TD-xx3)
# 1003 20
# 1004 30
# 1005 40
#=====================================================
xtcut    -f $KEYPAR'##mvSeq##',$iFldList -i $TD-xxbase |
xtagg    -k $KEYPAR'##mvSeq##' -f $FLD -c avg |
xtcommon -k $KEYPAR'##mvSeq##' -m $TD-xx2 -o $TD-xx3

#=====================================================
# ڥƥåף
# ƥåףǵ᤿ǡ顢##mvSeqб
# 򤷡ƥåףǵ᤿ưʿͤ礹롣
#-----------------------------------------------------
# ,,ưʿ ($OUTPUT)
# 1 10 *
# 2 20 *
# 3 30 20
# 4 40 30
# 5 50 40
#=====================================================
xtcut  -f $KEYPAR'##mvSeq##',$SORTFLD,$iFldList -i $TD-xxbase |
xtbest -k $KEYPAR$SORTFLD -s '##mvSeq##' -R 1 |
xtjoin -n -k $KEYPAR'##mvSeq##' -m $TD-xx3 -f $oFldList |
xtcut  -r -f '##mvSeq##' -o $OUTPUT

#ե
rm -f $TD-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
