#!/usr/bin/env bash

#*****************************************************************************
# xtfld2rec.sh
# ̾ͤιŸ
# Y.Hamuro
# 1.0   2004/12/06
#*****************************************************************************

#顼å
function help {
cat >/dev/stderr <<EOF
------------------------
xtfld2rec.sh version 1.0
------------------------
)̾ͤԤŸ(פε)
) xtfld2rec.sh -f ԤŸ̾ꥹ
                   -k ǡ줿̾Ф뿷̾
                   -v ŸͤФ뿷̾
                   [-i ϥե̾] [-oϥե̾]
                   [-T ǥ쥯ȥ̾] [-V] [-h]

      -V : ޥɤδλåɽ롣
      -h : إפɽ


) xtfld2rec.sh -f amt200401,amt200402 -k ǯ -v  -i dat.xt -o rsl.xt
) xtfld2rec.sh -f 'amt*' -k ǯ -v  -i dat.xt -o rsl.xt
EOF
exit 1
}

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
} 

#ѥ᡼Υåå
while getopts ":f:k:v:i:o:Vh" opt; do
  case $opt in
    f  ) fld=$OPTARG ;;
    k  ) keyName=$OPTARG ;;
    v  ) valName=$OPTARG ;;
    i  ) input=$OPTARG ;;
    o  ) output=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$tmpD" = "" ]; then
   tmpD=/tmp
fi
if [ "$input" = "" ]; then
  input=/dev/stdin
fi
if [ "$output" = "" ]; then
  output=/dev/stdout
fi
if [ "$fld" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$keyName" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -k is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$valName" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -n is mandatory\"" >/dev/stderr
  exit 1
fi

#ե̾
TD=$tmpD/xtfld2rec-$$

#ȥåȯư
trap endByInt INT QUIT TERM HUP

#ǡΥԡ
cat <$input >$TD-xxbase

#оݹܥꥹȤκ
xtbest -R 0 -i $TD-xxbase |
xtcut -f $fld |
xt2txt -F -o $TD-xxfld
fldList=`cat $TD-xxfld`

xtbest -R 0 -i $TD-xxbase |
xtcut -r -f $fld |
xt2csv -F -o $TD-xxfldr
fldRlist=`cat $TD-xxfldr`

for fldName in $fldList ; do
  xtcut -f $fldRlist,$fldName:$valName -i $TD-xxbase |
  xtsetchr -v $fldName -a $keyName |
  xtcut -f $fldRlist,$keyName,$valName -o $TD-xxsep-$fldName
done

xtcat -c -i $TD-xxsep-\* -o $output

rm -rf $TD-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
