#!/usr/bin/env bash

#*****************************************************************************
# xtcross.sh
# ץǡκ
# Y.Hamuro
# 1.0b 2003/01/07
# 1.0  ȥåɲ, 2004/11/09
#*****************************************************************************

#顼å
function help {
cat >/dev/stderr <<EOF
------------------------
xtcross.sh version 1.0
------------------------
)ɽ롣
) xtcross.sh -k Ԥˤʤ̾ -f ˤʤ̾ -d ͤι̾
                [-i ϥե̾] [-oϥե̾]
                [-T ǥ쥯ȥ̾] [-V] [-h]

      -V : ޥɤδλåɽ롣
      -h : إפɽ


) xtcross.sh -k ܵ -f ʬ -d  -i dat.xt -o rsl.xt
EOF
exit 1
}

#ǥեȤǤϡޥɤΥåOFF
export mssQuiet=1

#λåѤ˥ޥɥ饤¸
cmdLine="$0 $*"

#ʥˤ뽪λ
function endByInt {
  rm -f $TD-xx*
  echo "#ERROR# $$" \"$cmdLine\" \""end by signal(ctr^C)"\" >/dev/stderr
  exit 1
} 

#ѥ᡼Υåå
rName='fold##.data'
sName='fold##.test'
while getopts ":k:f:d:i:o:Vh" opt; do
  case $opt in
    k  ) row=$OPTARG ;;
    f  ) col=$OPTARG ;;
    d  ) dat=$OPTARG ;;
    i  ) input=$OPTARG ;;
    o  ) output=$OPTARG ;;
    T  ) tmpD=$OPTARG ;;
    V  ) mssQuiet=0 ;;
    h  ) help ;;
    \? ) help ;;
  esac
done
shift $(($OPTIND -1 ))

if [ "$tmpD" = "" ]; then
   tmpD=/tmp
fi
if [ "$input" = "" ]; then
  input=/dev/stdin
fi
if [ "$output" = "" ]; then
  output=/dev/stdout
fi
if [ "$row" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -k is mandatory\"" >/dev/stderr
  exit 1
fi
if [ "$col" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -f is mandatory\"" >/dev/stderr
   exit 1
fi
if [ "$dat" = "" ]; then
  echo "#ERROR# $$ \"$0\" \"option -d is mandatory\"" >/dev/stderr
  exit 1
fi

#ե̾
TD=$tmpD/xtcross-$$

#ȥåȯư
trap endByInt INT QUIT TERM HUP

#ɬ׹ܤڤФtmpե¸
xtcut -f $row,$col,$dat -i $input |
xtdelnul -f $row,$col,$dat -o $TD-xxbase

#ˡܵҤΥꥹȺ
xtcut -f $row -i $TD-xxbase |
xtuniq -k $row -o $TD-xxcust

#ˡʬꥹȤκ -> ץȺ
xtcut -f $col -i $TD-xxbase |
xtuniq -k $col |
xt2txt |
gawk '{print "joinCls",$1}' > $TD-xxsh

#ʬ˥եʬ䤹
xtsep -d $TD-xxsep-'$('$col')' -i $TD-xxbase

#ʬΥեܵҤ򥭡joinؿ
function joinCls {
  xtjoin -n -k $row -m $TD-xxsep-$1 -f $dat:$1 -i $TD-xxcust -o $TD-xxp
  cp $TD-xxp $TD-xxcust
}

#ǥץȼ¹
. $TD-xxsh

cat <$TD-xxcust >$output

rm -rf $TD-xx*

#λåɽ
echo "#END# $$" \"$cmdLine\" >/dev/stderr
exit 0
#===============================================================
