/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private String pending;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char c) {
        this(c, '\"', '\\');
    }

    public CSVParser(char c, char c2) {
        this(c, c2, '\\');
    }

    public CSVParser(char c, char c2, char c3) {
        this(c, c2, c3, false);
    }

    public CSVParser(char c, char c2, char c3, boolean bl) {
        this.separator = c;
        this.quotechar = c2;
        this.escape = c3;
        this.strictQuotes = bl;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String string) throws IOException {
        return this.parseLine(string, true);
    }

    public String[] parseLine(String string) throws IOException {
        return this.parseLine(string, false);
    }

    private String[] parseLine(String string, boolean bl) throws IOException {
        if (!bl && this.pending != null) {
            this.pending = null;
        }
        if (string == null) {
            if (this.pending != null) {
                String string2 = this.pending;
                this.pending = null;
                return new String[]{string2};
            }
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl2 = false;
        if (this.pending != null) {
            stringBuilder.append(this.pending);
            this.pending = null;
            bl2 = true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.escape) {
                if (!this.isNextCharacterEscapable(string, bl2, i)) continue;
                stringBuilder.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(string, bl2, i)) {
                    stringBuilder.append(string.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl3 = bl2 = !bl2;
                if (this.strictQuotes || i <= 2 || string.charAt(i - 1) == this.separator || string.length() <= i + 1 || string.charAt(i + 1) == this.separator) continue;
                stringBuilder.append(c);
                continue;
            }
            if (c == this.separator && !bl2) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder(128);
                continue;
            }
            if (this.strictQuotes && !bl2) continue;
            stringBuilder.append(c);
        }
        if (bl2) {
            if (bl) {
                stringBuilder.append("\n");
                this.pending = stringBuilder.toString();
                stringBuilder = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (stringBuilder != null) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && string.charAt(n + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && (string.charAt(n + 1) == this.quotechar || string.charAt(n + 1) == this.escape);
    }
}

