/*
 * unistd.h
 */


#ifndef unistd_h
#define unistd_h


#include<sys/types.h>
#include<stddef.h>
#include<share/unistd.h>


enum{
	/* Version Test Symbolic Constants. */
	_POSIX_VERSIO=200112L,
	_POSIX2_VERSION=200112L,

	/* Execution-Time Symbolic Constants. */
	_POSIX_ASYNC_IO=-1,
	_POSIX_PRIO_IO=-1,
	_POSIX_SYNC_IO=-1,

	/* Symbolic constants for the access() function. */
	F_OK=1<<0,
	R_OK=1<<1,
	W_OK=1<<2,
	X_OK=1<<3,

	/* Symbolic constants for the confstr() function. */
	_CS_PATH=0,
	_CS_POSIX_V6_ILP32_OFF32_CFLAGS,
	_CS_POSIX_V6_ILP32_OFF32_LDFLAGS,
	_CS_POSIX_V6_ILP32_OFF32_LIBS,
	_CS_POSIX_V6_ILP32_OFFBIG_CFLAGS,
	_CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS,
	_CS_POSIX_V6_ILP32_OFFBIG_LIBS,
	_CS_POSIX_V6_LP64_OFF64_CFLAGS,
	_CS_POSIX_V6_LP64_OFF64_LDFLAGS,
	_CS_POSIX_V6_LP64_OFF64_LIBS,
	_CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS,
	_CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS,
	_CS_POSIX_V6_LPBIG_OFFBIG_LIBS,
	_CS_POSIX_V6_WIDTH_RESTRICTED_ENVS,

	/* Symbolic constants as possible values for the function argument to the lockf() function. */
	F_LOCK=0,
	F_TEST,
	F_TLOCK,
	F_ULOCK,

	/* Symbolic constants for the pathconf() function. */
	_PC_ALLOC_SIZE_MIN=0,
	_PC_ASYNC_IO,
	_PC_CHOWN_RESTRICTED,
	_PC_FILESIZEBITS,
	_PC_LINK_MAX,
	_PC_MAX_CANON,
	_PC_MAX_INPUT,
	_PC_NAME_MAX=255,
	_PC_NO_TRUNC,
	_PC_PATH_MAX=_PC_NAME_MAX,
	_PC_PIPE_BUF,
	_PC_PRIO_IO,
	_PC_REC_INCR_XFER_SIZE,
	_PC_REC_MAX_XFER_SIZE,
	_PC_REC_MIN_XFER_SIZE,
	_PC_REC_XFER_ALIGN,
	_PC_SYNC_IO,
	_PC_VDISABLE,

	/* Symbolic constants for the sysconf() function. */
	_SC_2_C_BIND=0,
	_SC_2_C_DEV,
	_SC_2_C_VERSION,
	_SC_2_CHAR_TERM,
	_SC_2_FORT_DEV,
	_SC_2_FORT_RUN,
	_SC_2_LOCALEDEF,
	_SC_2_PBS,
	_SC_2_PBS_ACCOUNTING,
	_SC_2_PBS_CHECKPOINT,
	_SC_2_PBS_LOCATE,
	_SC_2_PBS_MESSAGE,
	_SC_2_PBS_TRACK,
	_SC_2_SW_DEV,
	_SC_2_UPE,
	_SC_2_VERSION,
	_SC_ADVISORY_INFO,
	_SC_ARG_MAX,
	_SC_AIO_LISTIO_MAX,
	_SC_AIO_MAX,
	_SC_AIO_PRIO_DELTA_MAX,
	_SC_ASYNCHRONOUS_IO,
	_SC_BC_BASE_MAX,
	_SC_BC_DIM_MAX,
	_SC_BC_SCALE_MAX,
	_SC_BC_STRING_MAX,
	_SC_CHILD_MAX,
	_SC_CLK_TCK,
	_SC_COLL_WEIGHTS_MAX,
	_SC_CPUTIME,
	_SC_DELAYTIMER_MAX,
	_SC_EXPR_NEST_MAX,
	_SC_FILE_LOCKING,
	_SC_FSYNC,
	_SC_GETGR_R_SIZE_MAX,
	_SC_GETPW_R_SIZE_MAX,
	_SC_HOST_NAME_MAX,
	_SC_JOB_CONTROL,
	_SC_LINE_MAX,
	_SC_LOGIN_NAME_MAX,
	_SC_MAPPED_FILES,
	_SC_MEMLOCK,
	_SC_MEMLOCK_RANGE,
	_SC_MEMORY_PROTECTION,
	_SC_MESSAGE_PASSING,
	_SC_MQ_OPEN_MAX,
	_SC_MQ_PRIO_MAX,
	_SC_NGROUPS_MAX,
	_SC_OPEN_MAX,
	_SC_PRIORITIZED_IO,
	_SC_PRIORITY_SCHEDULING,
	_SC_RE_DUP_MAX,
	_SC_REALTIME_SIGNALS,
	_SC_REGEXP,
	_SC_RTSIG_MAX,
	_SC_SAVED_IDS,
	_SC_SEMAPHORES,
	_SC_SEM_NSEMS_MAX,
	_SC_SEM_VALUE_MAX,
	_SC_SHARED_MEMORY_OBJECTS,
	_SC_SHELL,
	_SC_SIGQUEUE_MAX,
	_SC_SPAWN,
	_SC_SPORADIC_SERVER,
	_SC_STREAM_MAX,
	_SC_SYNCHRONIZED_IO,
	_SC_THREAD_ATTR_STACKADDR,
	_SC_THREAD_ATTR_STACKSIZE,
	_SC_THREAD_CPUTIME,
	_SC_THREAD_DESTRUCTOR_ITERATIONS,
	_SC_THREAD_KEYS_MAX,
	_SC_THREAD_PRIO_INHERIT,
	_SC_THREAD_PRIO_PROTECT,
	_SC_THREAD_PRIORITY_SCHEDULING,
	_SC_THREAD_PROCESS_SHARED,
	_SC_THREAD_SAFE_FUNCTIONS,
	_SC_THREAD_SPORADIC_SERVER,
	_SC_THREAD_STACK_MIN,
	_SC_THREAD_THREADS_MAX,
	_SC_TIMEOUTS,
	_SC_THREADS,
	_SC_TIMER_MAX,
	_SC_TIMERS,
	_SC_TTY_NAME_MAX,
	_SC_TZNAME_MAX,
	_SC_V6_ILP32_OFF32,
	_SC_V6_ILP32_OFFBIG,
	_SC_V6_LP64_OFF64,
	_SC_V6_LPBIG_OFFBIG,
	_SC_VERSION,

	/* Symbolic constants for file streams. */
	STDIN_FILENO=0,
	STDOUT_FILENO,
	STDERR_FILENO,
};


/* Function declarations. */
extern unsigned     alarm(unsigned);
extern int          chdir(const char *);
extern int          close(int);
extern int          dup(int);
extern int          dup2(int, int);
extern int          execve(const char *, char *const [], char *const []);
extern int          execl(const char *, const char *, ...);
extern int          execle(const char *, const char *, ...);
extern int          execlp(const char *, const char *, ...);
extern int          execv(const char *, char *const []);
extern int          execvp(const char *, char *const []);
extern void        _exit(int);
extern pid_t        fork(void);
extern char        *getcwd(char *, size_t);
extern gid_t        getegid(void);
extern uid_t        geteuid(void);
extern gid_t        getgid(void);
extern pid_t        getpid(void);
extern int          getgroups(int, gid_t []);
extern pid_t        getpgrp(void);
extern pid_t        getppid(void);
extern uid_t        getuid(void);
extern off_t        lseek(int, off_t, int);
extern ssize_t      read(int, void *, size_t);
extern int          rmdir(const char *);
extern int          setegid(gid_t);
extern int          seteuid(uid_t);
extern int          setgid(gid_t);
extern int          setpgid(pid_t, pid_t);
extern pid_t        setsid(void);
extern int          setuid(uid_t);
extern unsigned     sleep(unsigned);
extern ssize_t      write(int, const void *, size_t);
extern int          unlink(const char *);

/* ̤ */
extern int          access(const char *, int);
extern int          chown(const char *, uid_t, gid_t);
extern size_t       confstr(int, char *, size_t);
extern int          fchown(int, uid_t, gid_t);
extern long         fpathconf(int, int);
extern int          fsync(int);
extern int          ftruncate(int, off_t);
extern int          gethostname(char *, size_t);
extern char        *getlogin(void);
extern int          getlogin_r(char *, size_t);
extern int          getopt(int, char * const [], const char *);
extern int          isatty(int);
extern int          link(const char *, const char *);
extern long         pathconf(const char *, int);
extern int          pause(void);
extern int          pipe(int [2]);
extern ssize_t      readlink(const char *, char *, size_t);
extern long         sysconf(int);
extern pid_t        tcgetpgrp(int);
extern int          tcsetpgrp(int, pid_t);
extern char        *ttyname(int);
extern int          ttyname_r(int, char *, size_t);


/* ץޥ */
#define ROUNDUP(a,b) (((uint)(a)+(b)-1)/(b)*(b))
#define ROUNDDOWN(a,b) ((uint)(a)/(b)*(b))

/* ץؿ */
extern int brk(void*);
extern int reboot(int);
extern void *sbrk(ptrdiff_t);
extern void sync();


#endif
