/*
 * string.h
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef string_h
#define string_h


#include<sys/types.h>
#include<stddef.h>


extern inline int memcmp(const void *s1,const void *s2,size_t n)
{
	int i=0;


	while(((char*)s1)[i]==((char*)s2)[i])
		if(++i>=n)return 0;

	if(((char*)s1)[i]>((char*)s2)[i])return 1;
	return -1;
}

extern inline int strcmp(const char *s1,const char *s2)
{
	while(*s1==*s2++)
		if(*s1++=='\0')return 0;

	if(*s1>*--s2)return 1;
	return -1;
}

extern inline char *strcpy(char *s1,const char *s2)
{
	char *p=s1;


	while((*p++=*s2++)!='\0');

	return s1;
}

extern inline size_t strlen(const char *s)
{
	const char *p=s;


	while(*p++!='\0');

	return (size_t)(p-s-1);
}

extern inline char *strncpy(char *s1,const char *s2,size_t n)
{
	int i=n;


	while(--i<n)s1[i]=s2[i];

	return s1;
}

extern inline char *strchr(const char *s,int c)
{
	do
	{
		if(*s==(char)c)return (char*)s;
	}while(*s++!='\0');

	return NULL;
}

extern inline char *strcat(char *s1,const char *s2)
{
	char *p=s1;


	for(;*p!='\0';++p);
	while((*p++=*s2++)!='\0');

	return s1;
}

extern void    *memcpy(void *, const void *, size_t);
extern void    *memset(void *, int, size_t);
extern char    *strerror(int);

/* ̤ */
extern void    *memchr(const void *, int, size_t);
extern void    *memmove(void *, const void *, size_t);
extern int      strcoll(const char *, const char *);
extern size_t   strcspn(const char *, const char *);
extern char    *strncat(char *, const char *, size_t);
extern int      strncmp(const char *, const char *, size_t);
extern char    *strpbrk(const char *, const char *);
extern char    *strrchr(const char *, int);
extern size_t   strspn(const char *, const char *);
extern char    *strstr(const char *, const char *);
extern char    *strtok(char *, const char *);
extern size_t   strxfrm(char *, const char *, size_t);


#endif
