/*
 * rt8139.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * RTL8139 Ethernet controller.
 */


#include<types.h>
#include<pci.h>
#include<device.h>
#include<mm.h>
#include<lib.h>
#include<interrupt.h>
#include<errno.h>
#include<mp.h>
#include<lock.h>
#include<net/net.h>
#include<net/ether.h>
#include<net/ip.h>
#include<net/arp.h>


/*************************************************************************
 *
 * 
 *
 *************************************************************************/


enum{
	/* Receive buffer size. */
	RX_BUF_SIZE8K= 1024*8,
	RX_BUF_SIZE16k=1024*16,
	RX_BUF_SIZE32k=1024*32,
	RX_BUF_SIZE64k=1024*64,
	RX_BUF_SIZE=RX_BUF_SIZE8K,		/* ѹġ */

	/* Receive status bits in buffer. */
	RST_MULTI = 	1<<15,
	RST_PHYS =  	1<<14,
	RST_BROAD = 	1<<13,
	RST_BAD_SYMBOL =1<<5,
	RST_RUNT =      1<<4,
	RST_TOO_LONG =  1<<3,
	RST_CRC_ERR =   1<<2,
	RST_BAD_ALIGN = 1<<1,
	RST_OK =  		1<<0,

	/* Transmit status register. */
	REG_TS_OWN=1<<13,

	/* Command register. */
	REG_COM_RST= 1<<4,	/* Reset */
	REG_COM_RE=  1<<3,	/* Receiver enable. */
	REG_COM_TE=  1<<2,	/* Transmitter enable. */
	REG_COM_BUFE=1<<0,	/* Receive buffer empty. */

	/* Transmit configuration register. */
	REG_TRC_MAXDMA=7<<8,	/* Max DMA burst size 2048bytes. */
	REG_TRC_IFG=   3<<24,	/* Interframe gap time. */

	/* Receive configration register. */
	REG_RCC_AAP=   1<<0,
	REG_RCC_APM=   1<<1,
	REG_RCC_AM=    1<<2,
	REG_RCC_AB=    1<<3,
	REG_RCC_WRAP=  1<<7,
	REG_RCC_MAXDMA=7<<8,	/* Unlimited. */
	REG_RCC_RB8K=  0<<11,	/* 8K+16byte. */
	REG_RCC_RB16K= 1<<11,	/* 16K+16byte. */
	REG_RCC_RB32K= 2<<11,	/* 32K+16byte. */
	REG_RCC_RB64K= 3<<11,	/* 64K+16byte. */
	REG_RCC_RXFTH= 7<<13,	/* No rx threshold. */

	/* Interrupt mask register. */
	REG_INM_ROK=  1<<0,
	REG_INM_RER=  1<<1,
	REG_INM_TOK=  1<<2,
	REG_INM_TER=  1<<3,
	REG_INM_RXOVW=1<<4,
	REG_INM_PUN=  1<<5,
	REG_INM_FOVW= 1<<6,
	REG_INM_LENCH=1<<13,
	REG_INM_TMOUT=1<<14,
	REG_INM_SERR= 1<<15,
	REG_INM_ALL=REG_INM_ROK|REG_INM_RER|REG_INM_TOK|REG_INM_TER|REG_INM_RXOVW|
	            REG_INM_PUN|REG_INM_FOVW|REG_INM_TMOUT|REG_INM_SERR,

	/* 93C46 command register. */
	REG_9346_ENB=3<<6,
	REG_9346_DSB=0,

	/* Configuration register 1. */
	REG_CONFIG1_DVRLOAD=1<<5,
	REG_CONFIG1_LWACT=  1<<4,
	REG_CONFIG1_VPD=    1<<0,
};


/* Operation register. */
typedef struct{
	uchar           idr[6];			/* 0x00 */
	ushort reserv0;
	uchar volatile  mar0;			/* 0x08 */
	uchar volatile  mar1;			/* 0x09 */
	uchar volatile  mar2;			/* 0x0a */
	uchar volatile  mar3;			/* 0x0b */
	uchar volatile  mar4;			/* 0x0c */
	uchar volatile  mar5;			/* 0x0d */
	uchar volatile  mar6;			/* 0x0e */
	uchar volatile  mar7;			/* 0x0f */
	uint volatile   tsd[4];			/* 0x10 */
	uint volatile   tsad[4];		/* 0x20 */
	uint volatile   rbstart;		/* 0x30 */
	ushort volatile erbcr;			/* 0x34 */
	uchar volatile  ersr;			/* 0x36 */
	uchar volatile  cr;				/* 0x37 */
	ushort volatile capr;			/* 0x38 */
	ushort volatile cbr;			/* 0x3a */
	ushort volatile imr;			/* 0x3c */
	ushort volatile isr;			/* 0x3e */
	uint volatile   tcr;			/* 0x40 */
	uint volatile   rcr;			/* 0x44 */
	uint volatile   tctr;			/* 0x48 */
	uint volatile   mpc;			/* 0x4c */
	uchar volatile  cr9346;			/* 0x50 */
	uchar volatile  config0;		/* 0x51 */
	uchar volatile  config1;		/* 0x52 */
	uchar reserv1;
	uint volatile   timerint;		/* 0x54 */
	uchar volatile  msr;			/* 0x58 */
	uchar volatile  config3;		/* 0x59 */
	uchar volatile  config4;		/* 0x5a */
	uchar reserv2;
	ushort volatile mulint;			/* 0x5c */
	uchar volatile  rerid;			/* 0x5e */
	uchar reserv3;
	ushort volatile tsadall;		/* 0x60 */
	ushort volatile bmcr;			/* 0x62 */
	ushort volatile bmsr;			/* 0x64 */
	ushort volatile anar;			/* 0x66 */
	ushort volatile anlpar;			/* 0x68 */
	ushort volatile aner;			/* 0x6a */
	ushort volatile dis;			/* 0x6c */
	ushort volatile fcsc;			/* 0x6e */
	ushort volatile nwaytr;			/* 0x70 */
	ushort volatile rec;			/* 0x72 */
	ushort volatile cscr;			/* 0x74 */
	ushort reserv4;
	uint volatile   phy1_parm;		/* 0x78 */
	uint volatile   tw_parm;		/* 0x7c */
	uchar volatile  phy2_parm;		/* 0x80 */
	uchar reserv5[3];
	uchar volatile  crc0;			/* 0x84 */
	uchar volatile  crc1;			/* 0x85 */
	uchar volatile  crc2;			/* 0x86 */
	uchar volatile  crc3;			/* 0x87 */
	uchar volatile  crc4;			/* 0x88 */
	uchar volatile  crc5;			/* 0x89 */
	uchar volatile  crc6;			/* 0x8a */
	uchar volatile  crc7;			/* 0x8b */
	uint64 volatile wakeup0;		/* 0x8c */
	uint64 volatile wakeup1;		/* 0x94 */
	uint64 volatile wakeup2;		/* 0x9c */
	uint64 volatile wakeup3;		/* 0xa4 */
	uint64 volatile wakeup4;		/* 0xac */
	uint64 volatile wakeup5;		/* 0xb4 */
	uint64 volatile wakeup6;		/* 0xbc */
	uint64 volatile wakeup7;		/* 0xc4 */
	uchar volatile  lsbcrc0;		/* 0xcc */
	uchar volatile  lsbcrc1;		/* 0xcd */
	uchar volatile  lsbcrc2;		/* 0xce */
	uchar volatile  lsbcrc3;		/* 0xcf */
	uchar volatile  lsbcrc4;		/* 0xd0 */
	uchar volatile  lsbcrc5;		/* 0xd1 */
	uchar volatile  lsbcrc6;		/* 0xd2 */
	uchar volatile  lsbcrc7;		/* 0xd3 */
	uint volatile   flash;			/* 0xd4 */
	uchar volatile  sym_err;		/* 0xd8 */
}RT_REG;


/* ȥ餴Ȥθͭ */
typedef struct{
	RT_REG        *reg;			/* Register address. */
	uint           rbuf;		/* Receive buffer address. */
	int            crtRbuf;		/* Current receive buffer offset. */
	uint           tbuf[4];		/* Transfer buffer address. */
	int            tlock;		/* Transfer buffer lock gate. */
	uchar          crtTdes;		/* Current transfer descriptor. */
	uchar volatile endTdes;		/* Ե档 */
	uchar          mac[6];		/* Mac ID. */
}LOCAL_INFO;


/*
 * ꡼١IOߡ
 * Ϣ³ƽ񤭹Ԥɬס
 */
static int dmmy;
#define WRITE_REG(reg,value) reg=value;dmmy=(int)reg


/*************************************************************************
 *
 * 
 *
 *************************************************************************/


enum{
	TR_THRESH=60<<11,
};


/*
 * PUBLIC
 * Init transfer buffer.
 * parameters : LOCAL_INFO address
 * return : 0 or error number
 */
static int initTransBuf(LOCAL_INFO *linf)
{
	void *mem;
	int i;

	/* Set transfer buffer address. */
	for(i=0;i<4;++i)
	{
		if((mem=kmalloc(ETHER_FRAME_SIZE_MAX))==NULL)return -ENOMEM;
		linf->tbuf[i]=linf->reg->tsad[i]=(uint)mem;
		memcpy(((ETHER_FRAME*)mem)->srcmac,linf->mac,6);
	}

	return 0;
}


/*
 * PUBLIC
 * Reset transfer registers.
 * parameters : register
 * return : 0 or error number
 */
static int resetTransfer(LOCAL_INFO *linf)
{
	/* Set transmit configration register. */
	linf->reg->tcr=REG_TRC_MAXDMA;

	linf->crtTdes=linf->endTdes=0;
	linf->tlock=0;

	return 0;
}


/*
 * PUBLIC
 * Transfer end handle.
 * parameters : LOCAL_INFO address
 */
static void endTransfer(LOCAL_INFO *linf)
{
	++linf->endTdes;
}

static void errorTransfer(LOCAL_INFO *linf)
{
	uint state;
	int crt;


	crt=linf->endTdes/4;
	++linf->endTdes;

	state=linf->reg->tsd[crt];
}


/*
 * PUBLIC
 * Transfer ethernet frame.
 * parameters : LOCAL_INFO address,TRANS_BUF_INFO address,destination mac address
 */
static inline void transferFrame(LOCAL_INFO *linf,TRANS_BUF_INFO *tbi,char *dstmac)
{
	int crt;
	int size;
	ETHER_FRAME *frame;


	size=sizeof(ETHER_FRAME)+tbi->size[0]+tbi->size[1]+tbi->size[2];

	enter_spinlock(&linf->tlock);
	{
		crt=linf->crtTdes%4;
		frame=(ETHER_FRAME*)linf->tbuf[crt];

		/* Copy destination mac address. */
		memcpy(frame->dstmac,dstmac,6);

		frame->type=swapWord(tbi->type);

		/* Copy data frame. */
		memcpy(frame->data,tbi->data[0],tbi->size[0]);
		memcpy(frame->data+tbi->size[0],tbi->data[1],tbi->size[1]);
		memcpy(frame->data+tbi->size[0]+tbi->size[1],tbi->data[2],tbi->size[2]);
/***************************************************************************************/
{
ARP_HEADER *arp;
uchar *srcip,*dstip;

printk("TRANSFER size=%d,type=%x\n"
       "srcmac=%d-%d-%d-%d-%d-%d\n"
       "dstmac=%d-%d-%d-%d-%d-%d\n",
       size,swapWord(frame->type),
       frame->srcmac[0],frame->srcmac[1],frame->srcmac[2],frame->srcmac[3],frame->srcmac[4],frame->srcmac[5],
       frame->dstmac[0],frame->dstmac[1],frame->dstmac[2],frame->dstmac[3],frame->dstmac[4],frame->dstmac[5]);
arp=(ARP_HEADER*)frame->data;
srcip=(uchar*)&arp->srcIp;
dstip=(uchar*)&arp->dstIp;
printk("ARP HEADER htype=%x,ptype=%x,hsize=%x,psize=%x,opecode=%x\n"
		"source mac=%d-%d-%d-%d-%d-%d,IP=%d-%d-%d-%d\n"
		"dest   mac=%d-%d-%d-%d-%d-%d,IP=%d-%d-%d-%d\n",
       swapWord(arp->hardType),swapWord(arp->protType),arp->hardAddrLen,arp->protAddrLen,
       swapWord(arp->opeCode),
       arp->srcMac[0],arp->srcMac[1],arp->srcMac[2],arp->srcMac[3],arp->srcMac[4],arp->srcMac[5],
       srcip[0],srcip[1],srcip[2],srcip[3],
       arp->dstMac[0],arp->dstMac[1],arp->dstMac[2],arp->dstMac[3],arp->dstMac[4],arp->dstMac[5],
       dstip[0],dstip[1],dstip[2],dstip[3]);
}
/***************************************************************************************/
		linf->reg->tsd[crt]=((size>ETHER_FRAME_SIZE_MIN)?size:ETHER_FRAME_SIZE_MIN)|TR_THRESH;
		++linf->crtTdes;

		while(linf->endTdes==linf->crtTdes-4);
	}
	exit_spinlock(&linf->tlock);
}


/*************************************************************************
 *
 * 
 *
 *************************************************************************/


typedef struct{
	ushort state;		/* Receive state. */
	ushort size;		/* Frame size */
	ETHER_FRAME ether;
}RECEIVE_FRAME;


/*
 * PUBLIC
 * Read receive buffer.
 * parameters : device number,LOCAL_INFO address
 */
static void readReceiveBuf(int num,LOCAL_INFO *linf)
{
	RT_REG *reg;
	RECEIVE_FRAME *frame;


	reg=linf->reg;

	do
	{
		frame=(RECEIVE_FRAME*)(linf->rbuf+linf->crtRbuf);

		/* μΤΥ쥷֥ХåեΥåȡ */
		if((linf->crtRbuf+=ROUNDUP(frame->size+4,4))>=RX_BUF_SIZE)
			linf->crtRbuf-=RX_BUF_SIZE;
		reg->capr=linf->crtRbuf-16;
/**********************************************************************************/
printk("RECEIVE FRAME state=%x,size=%x\n",frame->state,frame->size);
printk("ETHER FRAME type=%x\n"
       "source mac=%d-%d-%d-%d-%d-%d\n"
       "dest   mac=%d-%d-%d-%d-%d-%d\n",
       swapWord(frame->ether.type),
       frame->ether.srcmac[0],frame->ether.srcmac[1],frame->ether.srcmac[2],
       frame->ether.srcmac[3],frame->ether.srcmac[4],frame->ether.srcmac[5],
       frame->ether.dstmac[0],frame->ether.dstmac[1],frame->ether.dstmac[2],
       frame->ether.dstmac[3],frame->ether.dstmac[4],frame->ether.dstmac[5]);
/**********************************************************************************/
		/* ե졼ƥץȥϤ */
		switch(swapWord(frame->ether.type))
		{
			case DIX_TYPE_IP:
/*				receiveIp((IP_HEADER*)frame->ether.data);*/
				break;
			case DIX_TYPE_ARP:
				receiveArp(num,(ARP_HEADER*)frame->ether.data);
				break;
		}
	}while((reg->cr&REG_COM_BUFE)==0);
}


/*
 * PUBLIC
 * Init receive buffer.
 * parameters : LOCAL_INFO address
 * return : 0 or error number
 */
static int initReceiveBuf(LOCAL_INFO *linf)
{
	void *mem;
	int memsize;


	/* Set receive buffer. */
	switch(RX_BUF_SIZE)
	{
		case RX_BUF_SIZE8K:
			memsize=8*1024+4096;
			break;
		case REG_RCC_RB16K:
			memsize=16*1024+4096;
			break;
		case REG_RCC_RB32K:
			memsize=32*1024+4096;
			break;
		case REG_RCC_RB64K:
			memsize=64*1024+4096;
			break;
	}

	/* Init receive buffer. */
	if((mem=kmalloc(memsize))==NULL)return -ENOMEM;
	linf->reg->rbstart=(uint)mem;
	linf->rbuf=(uint)mem;
	linf->crtRbuf=0;

	return 0;
}


/*
 * PUBLIC
 * Init receive registers.
 * parameters : register
 */
static void resetReceive(RT_REG *reg)
{
	/* Set receive configration register. */
	WRITE_REG(reg->rcr,REG_RCC_MAXDMA|REG_RCC_RXFTH|REG_RCC_APM|REG_RCC_AB|REG_RCC_AM|REG_RCC_WRAP);

	/* Set multicast. */
	WRITE_REG(reg->mar0,0xff);
	WRITE_REG(reg->mar1,0xff);
	WRITE_REG(reg->mar2,0xff);
	WRITE_REG(reg->mar3,0xff);
	WRITE_REG(reg->mar4,0xff);
	WRITE_REG(reg->mar5,0xff);
	WRITE_REG(reg->mar6,0xff);
	WRITE_REG(reg->mar7,0xff);

	/* Set read buffer pointer. */
	switch(RX_BUF_SIZE)
	{
		case RX_BUF_SIZE8K:
			WRITE_REG(reg->rcr,reg->rcr|REG_RCC_RB8K);
			break;
		case REG_RCC_RB16K:
			WRITE_REG(reg->rcr,reg->rcr|REG_RCC_RB16K);
			break;
		case REG_RCC_RB32K:
			WRITE_REG(reg->rcr,reg->rcr|REG_RCC_RB32K);
			break;
		case REG_RCC_RB64K:
			WRITE_REG(reg->rcr,reg->rcr|REG_RCC_RB64K);
			break;
	}

	/* Init packet counter. */
	WRITE_REG(reg->mpc,0);

	/* Clear multiple interrtupt register. */
	WRITE_REG(reg->mulint,reg->mulint&0xf000);
}


/*************************************************************************
 *
 * ꥻå
 *
 *************************************************************************/


/*
 * PUBLIC
 * Reset rt8139.
 */
static void resetRt(RT_REG *reg)
{
	reg->cr=REG_COM_RST;
	while((reg->cr&REG_COM_RST)!=0)mili_timer(5);
}


/*
 * PUBLIC
 * Init rt8139.
 * parameters : RT_REG address
 * return : 0 or error number
 */
static int initRt(LOCAL_INFO *linf)
{
	RT_REG *reg;


	reg=linf->reg;

	/* Soft reset. */
	resetRt(reg);

	/* Enable transfer and receive. */
	reg->cr=REG_COM_RE|REG_COM_TE;

	/* Init receive registers. */
	resetReceive(reg);

	/* Init transfer registers. */
	resetTransfer(linf);

	/* ߥޥꡣ */
	linf->reg->imr=REG_INM_ROK|REG_INM_RER|REG_INM_TOK|REG_INM_TER|REG_INM_RXOVW|
	               REG_INM_PUN|REG_INM_FOVW|REG_INM_LENCH|REG_INM_TMOUT|REG_INM_SERR;

	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/* PRIVATE */
static LOCAL_INFO *local[2];


/*
 * PRIVATE
 * Interrupt handler.
 * parameters : device number,LOCAL_INFO address
 */
static inline void intrHandler(int num,LOCAL_INFO *linf)
{
	int state;
	RT_REG *reg;


	reg=linf->reg;

	for(;;)
	{
		state=reg->isr;
/***********************************/
printk("state=%x\n",state);
/**********************************/
		if(state&REG_INM_ROK)readReceiveBuf(num,linf);
		else if(state&REG_INM_TOK)endTransfer(linf);
		else if(state&REG_INM_TER)errorTransfer(linf);
		else if(state&REG_INM_SERR)initRt(linf);
		else if((state&REG_INM_ALL)==0)break;
		else if(state==0xffff)break;
		else WRITE_REG(reg->mpc,0);

		reg->isr=state;
	}
}


/*
 * PRIVATE
 * Interrupt handler head.
 */
static int intr0()
{
	intrHandler(0,local[0]);

	return 0;
}

static int intr1()
{
	intrHandler(1,local[1]);

	return 0;
}


/* PUBLIC */
int (*intr[])()={intr0,intr1};


/*************************************************************************
 *
 * ӥ롼
 *
 *************************************************************************/


static int open()
{
	return 0;
}


static int write(void *linf,size_t tbi,size_t dstmac)
{
	transferFrame((LOCAL_INFO*)linf,(TRANS_BUF_INFO*)tbi,(char*)dstmac);

	return 0;
}


static int ioctl(int filedes,void *cmd)
{
	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


enum{
	/* Vender ID,Device ID. */
	VID_REALTEK=					0x10EC,
		DID_REALTEK_8129=			0x8129,
		DID_REALTEK_8139=			0x8139,
	VID_DELTA=						0x1500,
		DID_DELTA_8139=				0x1360,

	/* PCI Configuration Space Registers. */
	RT_PCI_IOAR=	0x10,
	RT_PCI_MEMAR=	0x14,
};


/*
 * PRIVATE
 * Init interrupt.
 * parameters : device number,PCI_INFO address,LOCAL_INFO address
 * return : 0 or error number
 */
static int initIntr(int devnum,PCI_INFO *pci,LOCAL_INFO *linf)
{
	int rest;
	int irq;


	/* ߤꡣ */
	irq=read_pci_config(pci,PCI_CONF_INTRLIN)&0xff;
	local[devnum]=linf;
	irq_entry[irq]=intr[devnum];

	/* MPƥξ硣 */
	if(MFPS_addres)
	{
		if((rest=SetPciIrqInIoapic(pci,irq))<0)return rest;
		releasePciIrqIoapicMask(pci);
	}
	else release_irq_mask(irq);

	return 0;
}


/*
 * PRIVATE
 * PCIǽꡣ
 * parameters : PCI_INFO,LOCAL_INFO pointer address
 * return : 0 or error number
 */
static int initPCI(PCI_INFO *pci,LOCAL_INFO *linf)
{
	int com;
	uint membase;


	/* ݡȡ꡼١ХޥON */
	com=read_pci_config(pci,PCI_CONF_COMMAND);
	com|=PCI_COMMAND_IOACS|PCI_COMMAND_MEMACS|PCI_COMMAND_BSMST;
	writew_pci_config(pci,com,PCI_CONF_COMMAND);

	/* 쥸ꥢ١ɥ쥹ꡣ */
	membase=getPciMemAddress(0x100);
	writedw_pci_config(pci,RT_PCI_MEMAR,membase);
	if(read_pci_config(pci,RT_PCI_MEMAR)!=membase)return -EDERRE;
	linf->reg=(RT_REG*)membase;

	return 0;
}


/*
 * GLOBAL
 * parameters : device number
 * return : next device number or error number
 */
int initRt8139(int devnum)
{
	char *nic_name;
	char *dev_name;
	int rest;
	int vendID,devID;
	PCI_INFO pci={0,0,0,0};
	DEV_INFO *devinf;


	/* NicPCI鸡 */
	while(search_pci_class(PCI_CLASS_ETHER,&pci)==0)
	{
		/* VenderID  DeviceID γǧ */
		nic_name=NULL;
		vendID=pci.vidDid&0xffff;
		devID=pci.vidDid>>16;
		switch(vendID)
		{
			case VID_REALTEK:
				switch(devID)
				{
					case DID_REALTEK_8129:
						nic_name="RealTek 8129 10/100BaseTX";
						break;
					case DID_REALTEK_8139:
						nic_name="RealTek 8139 10/100BaseTX";
						break;
				}
				break;
			case VID_DELTA:
				switch(devID)
				{
					case DID_DELTA_8139:
						nic_name="Delta Electronics 8139 10/100BaseTX";
						break;
				}
				break;
		}

		if(nic_name!=NULL)
		{
			/* Init device information. */
			if((devinf=kmalloc(sizeof(DEV_INFO)))==NULL)return -ENOMEM;
			devinf->sector_size=0;
			devinf->begin_blk=0;
			devinf->last_blk=0;
			devinf->open=open;
			devinf->write=write;
			devinf->ioctl=ioctl;
			if((dev_name=kmalloc(6))==NULL)return -ENOMEM;
			sprintk(dev_name,"eth%d",devnum);
			devinf->name=dev_name;

			if((devinf->linf=kmalloc(sizeof(LOCAL_INFO)))==NULL)return -ENOMEM;

			/* Init PCI. */
			if((rest=initPCI(&pci,devinf->linf))<0)return rest;

			/* Get MAC address. */
			memcpy(((LOCAL_INFO*)devinf->linf)->mac,((LOCAL_INFO*)devinf->linf)->reg->idr,6);

			/* Init receive buffer. */
			initReceiveBuf(devinf->linf);

			/* Init transfer buffer. */
			if((rest=initTransBuf(devinf->linf))<0)return rest;

			/* Init chip. */
			initRt(devinf->linf);

			/* Init interrrupt. */
			if(initIntr(devnum,&pci,devinf->linf)<0)return devnum;

			regist_device(devinf);

			/* Set device structure. */
			setEtherDevice(devnum,devinf,((LOCAL_INFO*)devinf->linf)->mac);

			printk("%s : %s\n",devinf->name,nic_name);

			++devnum;
		}

		++pci.dev;
		pci.func=0;
	}

	return devnum;
}
