/*
 * ip.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Internet Protocol.
 */


#include<types.h>
#include<lib.h>
#include<net/net.h>
#include<net/ip.h>
#include<net/icmp.h>


/**************************************************************************
 *
 * å
 *
 **************************************************************************/


/*
 * PRIVATE
 * åη׻
 * parameters : data,size
 * return : check sum
 */
static inline ushort calcSum(ushort *data,int size)
{
	uint sum=0;


	while((size-=sizeof(ushort))>=0)
		sum+=swapWord(*data++);
	while((sum>>16)!=0)
		sum=(sum&0xffff)+((sum>>16)&0xffff);

	return sum;
}


/*
 * PUBLIC
 * å֤ͤ
 * parameters : IP header,size
 * return : check sum
 */
static inline ushort getSum(IP_HEADER *head,int size)
{
	head->chksum=0;
	return ~calcSum((ushort*)head,size);
}


/*
 * PUBLIC
 * åγǧ
 * parameters : data,size
 * return : 0 or failed=not 0
 */
static int checkSum(IP_HEADER *head,int size)
{
	ushort tmp;


	tmp=head->chksum;
	head->chksum=0;

	return tmp+calcSum((ushort*)head,size)-0xffff;
}


/**************************************************************************
 *
 * ӥ롼
 *
 **************************************************************************/


enum{
	/* ץȥֹ档 */
	IP_ICMP_PROTOCOL=1,
	IP_TCP_PROTOCOL=6,
	IP_UDP_PROTOCOL=7,
};


/*
 * GROBAL
 * Receive IP datagram.
 * parameters : IP header
 */
void receiveIp(IP_HEADER *head)
{
/*****************************************************************************************/
	printk("IP version=%x,head len=%x,TOS=%x,length=%x,id=%x,fragment=%x\n"
	       "TTL=%x,protocol=%x,sourceIP=%x,destIP=%x\n",
	       head->verhead&0xf,head->verhead>>4,head->tos,head->len,head->id,head->frag,
	       head->ttl,head->prot,head->srcip,head->dstip);
/*******************************************************************************************/
	/* åγǧ */
	if(checkSum(head,sizeof(IP_HEADER)))return;

	/* ̥ץȥ */
	switch(head->prot)
	{
		case IP_ICMP_PROTOCOL:
			receiveIcmp((ICMP_HEADER*)((char*)head+(head->verhead&0xf)*4),head->len);
			break;
		case IP_TCP_PROTOCOL:
			break;
		case IP_UDP_PROTOCOL:
			break;
	}
}
