/*
 * ether.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Ethernet controller manager.
 */


#include<user/include/share/user_config.h>
#include<types.h>
#include<lib.h>
#include<device.h>
#include<errno.h>
#include<net/rt8139.h>
#include<net/ether.h>


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


ETHER_DEVICE ethDev[ETHER_DEVICE_MAX];


static int etherNum=0;		/* Eathernet device number. */


/*
 * GLOBAL
 * Set ethernet driver infomation.
 * parameters : ethernet number,DEV_INFO address,mac address
 * return : 0 or error number.
 */
int setEtherDevice(int ethnum,DEV_INFO *devinf,char *mac)
{
	if(ethnum>=ETHER_DEVICE_MAX)return -E2BIG;

	ethDev[ethnum].dev=devinf;
	memcpy(ethDev[ethnum].mac,mac,6);

	/*
	 * IPɥ쥹ꡣ
	 * Note!
	 *  ѹͽꡣ
	 */
	switch(ethnum)
	{
		case 0:
			ethDev[0].ip=IP_ADDRESS0;
			break;
		case 1:
			ethDev[1].ip=IP_ADDRESS1;
			break;
	}

	return 0;
}


int initEther()
{
	int rest;


	if((rest=initRt8139(etherNum))>etherNum)etherNum=rest;
	else if(rest<0)return rest;

	/* ͥåȥȥ顼ʤɥ饤Сʤ */
	if(etherNum==0)
		printk("No ethernet driver or no ethernet controler!\n");

	return 0;
}
