/*
 * rt8139.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * RTL8139 Ethernet controller.
 */


#include"types.h"
#include"pci.h"
#include"device.h"
#include"mm.h"
#include"lib.h"
#include"errno.h"


enum{
	/* Oparation register offset. */
/*	REG_IDR0=		0x00,
	REG_IDR1=		0x01,
	REG_IDR2=		0x02,
	REG_IDR3=		0x03,
	REG_IDR4=		0x04,
	REG_IDR5=		0x05,
	REG_MAR0=		0x08,
	REG_MAR1=		0x09,
	REG_MAR2=		0x0A,
	REG_MAR3=		0x0B,
	REG_MAR4=		0x0C,
	REG_MAR5=		0x0D,
	REG_MAR6=		0x0E,
	REG_MAR7=		0x0F,
	REG_TSD0=		0x10,
	REG_TSD1=		0x14,
	REG_TSD2=		0x18,
	REG_TSD3=		0x1C,
	REG_TSAD0=		0x20,
	REG_TSAD1=		0x24,
	REG_TSAD2=		0x28,
	REG_TSAD3=		0x2C,
	REG_RBSTART=	0x30,
	REG_ERBCR=		0x34,
	REG_ERSR=		0x36,
	REG_CR=			0x37,
	REG_CAPR=		0x38,
	REG_CBR=		0x3a,
	REG_IMR=		0x3c,
	REG_ISR=		0x3e,
	REG_TCR=		0x40,
	REG_RCR=		0x44,
	REG_TCTR=		0x48,
	REG_MPC=		0x4c,
	REG_9346CR=		0x50,
	REG_CONFIG0=	0x51,
	REG_CONFIG1=	0x52,
	REG_TimerInt=	0x54,
	REG_MSR=		0x58,
	REG_CONFIG3=	0x59,
	REG_CONFIG4=	0x5a,
	REG_MULINT=		0x5c,
	REG_RERID=		0x5e,
	REG_TSAD=		0x60,
	REG_BMCR=		0x62,
	REG_BMSR=		0x64,
	REG_ANAR=		0x66,
	REG_ANLPAR=		0x68,
	REG_ANER=		0x6a,
	REG_DIS=		0x6c,
	REG_FCSC=		0x6e,
	REG_NWAYTR=		0x70,
	REG_REC=		0x72,
	REG_CSCR=		0x74,
	REG_PHY1_PARM=	0x78,
	REG_TW_PARM=	0x7c,
	REG_PHY2_PARM=	0x80,
	REG_CRC0=		0x84,
	REG_CRC1=		0x85,
	REG_CRC2=		0x86,
	REG_CRC3=		0x87,
	REG_CRC4=		0x88,
	REG_CRC5=		0x89,
	REG_CRC6=		0x8a,
	REG_CRC7=		0x8b,
	REG_Wakeup0=	0x8c,
	REG_Wakeup1=	0x94,
	REG_Wakeup2=	0x9c,
	REG_Wakeup3=	0xa4,
	REG_Wakeup4=	0xac,
	REG_Wakeup5=	0xb4,
	REG_Wakeup6=	0xbc,
	REG_Wakeup7=	0xc4,
	REG_LSBCRC0=	0xcc,
	REG_LSBCRC1=	0xcd,
	REG_LSBCRC2=	0xce,
	REG_LSBCRC3=	0xcf,
	REG_LSBCRC4=	0xd0,
	REG_LSBCRC5=	0xd1,
	REG_LSBCRC6=	0xd2,
	REG_LSBCRC7=	0xd3,
	REG_FLASH=		0xd4,
	REG_SYM_ERR=	0xd8,
	REG_FER=		0xf0,
	REG_FEMR=		0xf4,
	REG_FPSR=		0xf8,
	REG_FFER=		0xfc,
*/
	/* Vender ID,Device ID. */
	VID_REALTEK=					0x10EC,
		DID_REALTEK_8129=			0x8129,
		DID_REALTEK_8139=			0x8139,
	VID_DELTA=						0x1500,
		DID_DELTA_8139=				0x1360,

	/* PCI Configuration Space Registers. */
	RT_PCI_IOAR=	0x10,
	RT_PCI_MEMAR=	0x14,
};


/* RTK8139ͭ */
typedef struct{
	uint mBase;		/* Base memory address. */
	uint pBase;		/* Base IO address. */
}LOCAL_INFO;


/*************************************************************************
 *
 *
 *
 *************************************************************************/

typedef struct{
	idr0;		0x00,
	idr1;		0x01,
	idr2;		0x02,
	idr3;		0x03,
	idr4;		0x04,
	idr5;		0x05,
	mar0;		0x08,
	mar1;		0x09,
	mar2;		0x0a,
	mar3;		0x0b,
	mar4;		0x0c,
	mar5;		0x0d,
	mar6;		0x0e,
	mar7;		0x0f,
	tsd0;		0x10,
	tsd1;		0x14,
	tsd2;		0x18,
	tsd3;		0x1c,
	tsad0;		0x20,
	tsad1;		0x24,
	tsad2;		0x28,
	tsad3;		0x2c,
	rbstart;	0x30,
	erbcr;		0x34,
	ersr;		0x36,
	cr;			0x37,
	capr;		0x38,
	cbr;		0x3a,
	imr;		0x3c,
	isr;		0x3e,
	tcr;		0x40,
	rcr;		0x44,
	tctr;		0x48,
	mpc;		0x4c,
	9346cr;		0x50,
	config0;	0x51,
	config1;	0x52,
	timerint;	0x54,
	msr;		0x58,
	config3;	0x59,
	config4;	0x5a,
	mulint;		0x5c,
	rerid;		0x5e,
	tsad;		0x60,
	bmcr;		0x62,
	bmsr;		0x64,
	anar;		0x66,
	anlpar;		0x68,
	aner;		0x6a,
	dis;		0x6c,
	fcsc;		0x6e,
	nwaytr;		0x70,
	rec;		0x72,
	cscr;		0x74,
	phy1_parm;	0x78,
	tw_parm;	0x7c,
	phy2_parm;	0x80,
	crc0;		0x84,
	crc1;		0x85,
	crc2;		0x86,
	crc3;		0x87,
	crc4;		0x88,
	crc5;		0x89,
	crc6;		0x8a,
	crc7;		0x8b,
	wakeup0;	0x8c,
	wakeup1;	0x94,
	wakeup2;	0x9c,
	wakeup3;	0xa4,
	wakeup4;	0xac,
	wakeup5;	0xb4,
	wakeup6;	0xbc,
	wakeup7;	0xc4,
	lsbcrc0;	0xcc,
	lsbcrc1;	0xcd,
	lsbcrc2;	0xce,
	lsbcrc3;	0xcf,
	lsbcrc4;	0xd0,
	lsbcrc5;	0xd1,
	lsbcrc6;	0xd2,
	lsbcrc7;	0xd3,
	flash;		0xd4,
	sym_err;	0xd8,
	fer;		0xf0,
	femr;		0xf4,
	fpsr;		0xf8,
	ffer;		0xfc,
}RT_REG *reg;


/*
 * PUBLIC
 *
 */


/*
 * PUBLIC
 * Init base memory of register.
 * parameters : base address
 */



/*************************************************************************
 *
 * ƥॳ
 *
 *************************************************************************/

static int open()
{
	return 0;
}


static int read(void *buf,size_t size,size_t begin)
{
	return 0;
}


static int write(void *buf,size_t size,size_t begin)
{
	return 0;
}


static int ioctl(int filedes,void *cmd)
{
	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/

/*
 * PRIVATE
 * Init interrupt.
 * parameters :
 * return :
 */


/*
 * PRIVATE
 * ǥХͭǽꡣ
 * parameters : PCI_INFO
 * return : LOCAL_INFO or NULL
 */
static LOCAL_INFO *initPCI(PCI_INFO *pci)
{
	int pciCom;
	uint port_base,mem_base;
	LOCAL_INFO *linf;


	if((linf=kmalloc(sizeof(LOCAL_INFO)))==NULL)return NULL;
	pciCom=read_pci_config(pci->bus,pci->dev,pci->func,PCI_CONF_COMMAND);
	port_base=read_pci_config(pci->bus,pci->dev,pci->func,RT_PCI_IOAR)&~1;
/***********************************************************************************/
writedw_pci_config(pci->bus,pci->dev,pci->func,RT_PCI_MEMAR,0xfef00000);
mem_base=read_pci_config(pci->bus,pci->dev,pci->func,RT_PCI_MEMAR);
printk("pci command=%x,port base=%x,memory base=%x\n",pciCom,port_base,mem_base);
printk("%x,%x\n",inb(REG_RERID+port_base),*((char*)mem_base+REG_RERID));

/***********************************************************************************/

	/* ݡȡ꡼١ХޥON */

	linf->mBase=mem_base;
	linf->pBase=port_base;

	return linf;
}


/*
 * GLOBAL
 * parameters : device number
 * return : next device number or error number
 */
int initRt8139(int devnum)
{
	char *nic_name;
	char *dev_name;
	int vendID,devID;
	PCI_INFO pci={0,0,0,0};
	DEV_INFO *devinf;


	/* Search PCI configuration register. */
	while(search_pci_class(PCI_CLASS_ETHER,&pci)==0)
	{
		/* VenderID  DeviceID γǧ */
		nic_name=NULL;
		vendID=pci.vidDid&0xffff;
		devID=pci.vidDid>>16;
		switch(vendID)
		{
			case VID_REALTEK:
				switch(devID)
				{
					case DID_REALTEK_8129:
						nic_name="RealTek 8129 10/100BaseTX";
						break;
					case DID_REALTEK_8139:
						nic_name="RealTek 8139 10/100BaseTX";
						break;
				}
				break;
			case VID_DELTA:
				switch(devID)
				{
					case DID_DELTA_8139:
						nic_name="Delta Electronics 8139 10/100BaseTX";
						break;
				}
				break;
		}

		if(nic_name!=NULL)
		{
			/* Init device information. */
			if((devinf=kmalloc(sizeof(DEV_INFO)))==NULL)return -ENOMEM;
			devinf->sector_size=0;
			devinf->begin_blk=0;
			devinf->last_blk=0;
			devinf->open=open;
			devinf->read=read;
			devinf->write=write;
			devinf->ioctl=ioctl;
			if((dev_name=kmalloc(6))==NULL)return -ENOMEM;
			sprintk(dev_name,"eth%d",devnum++);
			devinf->name=dev_name;
			if((devinf->linf=initPCI(&pci))==NULL)return  -ENOMEM;

			regist_device(devinf);

			printk("%s : %s\n",devinf->name,nic_name);
		}

		++pci.dev;
	}

	return devnum;
}
