/*
 * pci.h (C) 2002 Minoru Murashima
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * PCI
 */


#ifndef pci_h
#define pci_h


#ifndef ASM_FILE


#include"types.h"


enum{
	/* Configuration registers. */
	PCI_CONF_VENDER=	0x0,
	PCI_CONF_DEVICE=	0x2,
	PCI_CONF_COMMAND=	0x4,
	PCI_CONF_STATUS=	0x6,
	PCI_CONF_REVIVION=	0x8,
	PCI_CONF_CLASS=		0x9,
	PCI_CONF_CACHE=		0xc,
	PCI_CONF_LATENCY=	0xd,
	PCI_CONF_HEDTYPE=	0xe,
	PCI_CONF_BIST=		0xf,
	PCI_CONF_INTRLIN=	0x3c,
	PCI_CONF_INTRPIN=	0x3d,

	/* Command register bit. */
	PCI_COMMAND_IOACS=		1<<0,
	PCI_COMMAND_MEMACS=		1<<1,
	PCI_COMMAND_BSMST=		1<<2,		/* Bus Master enable */
	PCI_COMMAND_SPCYC=		1<<3,
	PCI_COMMAND_MEMWINV=	1<<4,
	PCI_COMMAND_VGASNOOP=	1<<5,
	PCI_COMMAND_PRTYERR=	1<<6,
	PCI_COMMAND_ADDRSTP=	1<<7,
	PCI_COMMAND_SYSERR=		1<<8,
	PCI_COMMAND_FSTBCK=		1<<9,

	/* Class coad. */
	PCI_CLASS_IDE_BSMST=0x010180,		/* IDE bus master. */
	PCI_CLASS_ETHER=	0x020000,		/* Ethernet. */
};


typedef struct{
	uint vidDid;		/* VenderID(0-15bit) + deviceID(16-31bit) */
	int bus;
	int dev;
	int func;
}PCI_INFO;


extern uint read_pci_config(int,int,int,int);
extern void writedw_pci_config(int,int,int,int,uint);
extern void writew_pci_config(int,int,int,int,ushort);
extern void writeb_pci_config(int,int,int,int,uchar);
extern int search_pci_class(int,PCI_INFO*);
extern uint getPciMemAddress(int);


#endif


#endif
