/*
 * stdio.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<string.h>
#include<stdarg.h>
#include<system.h>
#include<stdio.h>


/***************************************************************************
 *
 * ʸϴؿ
 *
 ***************************************************************************/

/*
 * PRIVATE
 * ʸѴƥХåե¸롣
 * parameters :
 * return : converted string size
 */
static int convertString(const char *str,char *buf,int buf_size,uint *arg)
{
	enum{BUF_SIZE=12};

	char tmp_buf[BUF_SIZE];
	int ivalue;
	uint uvalue;
	int i,j,size;


	if(buf_size==0)return 0;

	for(i=0;*str!='\0';++str)
	{
		if(*str=='%')
		{
			switch(*++str)
			{
				case 'd':		/* Ѵ */
					ivalue=*arg++;
					if(ivalue>=0)
						for(j=BUF_SIZE-1;;--j)
						{
							tmp_buf[j]=ivalue%10+'0';
							if(!(ivalue/=10))break;
						}
					else
						for(j=BUF_SIZE-1;;--j)
						{
							tmp_buf[j]=(ivalue%10)*-1+'0';
							if(!(ivalue/=10))
							{
								tmp_buf[--j]='-';
								break;
							}
						}

					size=BUF_SIZE-j;
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 'u':		/* ̵Ѵ */
					uvalue=*arg++;
					for(j=BUF_SIZE-1;;--j)
					{
						tmp_buf[j]=uvalue%10+'0';
						if(!(uvalue/=10))break;
					}

					size=BUF_SIZE-j;
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 'x':		/* 16ʿѴ */
					uvalue=*arg++;
					for(j=BUF_SIZE-1;;--j)
					{
						tmp_buf[j]=uvalue%16+'0';
						if(tmp_buf[j]>'9')tmp_buf[j]+='a'-'9'-1;
						if(!(uvalue/=16))break;
					}

					size=BUF_SIZE-j;
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],&tmp_buf[j],size);
					i+=size;
					break;

				case 's':		/* ʸɽ */
					size=strlen((char*)*arg);
					if(size>=(buf_size-i))goto END;
					memcpy(&buf[i],(void*)*arg,size);
					++arg;
					i+=size;
					break;

				case '%':
					if((buf_size-i)<=1)goto END;
					buf[i++]='%';
					break;

				default:
					if((buf_size-i)<=2)goto END;
					buf[i++]='%';
					buf[i++]=*str;
			}
		}
		else if(*str=='\n')
		{
			if((buf_size-i)<=2)goto END;
			buf[i++]='\n';
			buf[i++]='\r';
		}
		else buf[i++]=*str;
	}

END:
	tmp_buf[i]='\0';

	return i;
}


int printf(const char *str,...)
{
	enum{BUF_SIZE=1024};

	char buf[BUF_SIZE];
	int size;


	size=convertString(str,buf,BUF_SIZE,(uint*)&str+1);

	return write(STDOUT_FILENO,buf,size);
}


int rename(const char *old, const char *new)
{
	int rest;
	
	
	if((rest=syscall3(SYS_RENAME,(int)old,(int)new))<0)
	{
		sys_info->errorNo=-rest;
		return -1;
	}
	
	return 0;
}
