/*
 * fs.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef fs_h
#define fs_h


#include"types.h"
#include"proc.h"


#ifndef ASM_FILE


enum{
	/* File type */
	NORMAL_FILE=1,
	DIRECTORY=2,
	SYMBOL_LINK=3,
	DEVICE_FILE=4,
};


/* ե륷ƥ।ե᡼¤ */
typedef struct{
	const char *name;
	uint (*mount)(int);							/* prm:device inode  ret:root directory block or error=0 */
	int (*umount)(int);							/* prm:device inode  ret:0 or error=-1 */
	int (*open)(const char*,int,uint);			/* prm:path,device inode,directory block, ret:inode block or error=-1 */
	int (*close)(int,uint);						/* prm:file device inode,inode  ret:0 or error=-1 */
	int (*read)(int,uint,void*,size_t,size_t);	/* prm:device inode,inode,bffer,read bytes,begin byte  ret:read bytes or error=-1 */
	int (*write)(int,uint,void*,size_t,size_t);	/* prm:device inode,inode,bffer,write bytes,begin byte  ret:write bytes or error=-1 */
	int (*ioctr)(int,uint,int,void*);			/* prm:device inode,inode,command,parameter  ret:0 or error=-1 */
	int (*rename)(int,uint,const char*);		/* prm:device inode,inode,name  ret:0 or error=-1 */
	int (*creat)(const char*,int,uint);			/* prm:path,device inode,parent directory block  ret:directory block or error=0 */
	int (*opendir)(const char*,int,uint);		/* prm:path,device inode,parent directory block  ret:directory block or error=0 */
	int (*mkdir)(const char*,int,uint);			/* prm:path,device inode,parent directory block  ret:directory block or error=0 */
}FS;

/* ե륪ץؿѹ¤ */
typedef struct{
	ushort din;			/* device inode number */
	uint inode;			/* inode֥å */
}OPEN_F;


extern FS *fs_info[];


extern void init_fs();
extern int mount_dev_fs(int);
extern int regist_fs(FS*);
extern int init_file_struct(PROC*);
extern int cpy_file_struct(PROC*,PROC*);
extern int get_inode(int);
extern int mount_root_fs(const char*,const char*);
extern int exec_open(const char*,OPEN_F*);
extern int exec_read(OPEN_F*,void*,size_t,size_t);
extern int sys_open();
extern int sys_close();
extern int sys_read();
extern int sys_write();
extern int sys_ioctr();
extern int sys_lseek();
extern int sys_mkdir();
extern int sys_creat();
extern int sys_rename();
extern int sys_unlink();
extern int sys_lock();
extern int sys_mount();
extern int sys_umount();
extern int chdir();


#endif


#endif
