/*
 * elf.c
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include"types.h"
#include"lib.h"
#include"mm.h"
#include"fs.h"


enum{EI_NIDENT=16};

typedef unsigned int Elf32_Addr;
typedef unsigned short Elf32_Half;
typedef unsigned int Elf32_Off;
typedef int Elf32_Sword;
typedef unsigned int Elf32_Word;


/* ELF Header define valus */
enum{
	/* e_type */
	ET_REL=	1,		/* Relocatable file */
	ET_EXEC=2,		/* Executable file */
	ET_DYN=	3,		/* Shared object file */

	/* e_machine */
	EM_386=3,		/* Intel 80386 */

	P_HEDDER_SIZE=32	/* ץإå */
};

/* ELF Header */
typedef struct{
	unsigned char e_ident[EI_NIDENT];
	Elf32_Half e_type;					/* ե륿ס */
	Elf32_Half e_machine;				/* cpuƥ㡣 */
	Elf32_Word e_version;
	Elf32_Addr e_entry;					/* ȥ꡼꡼ɥ쥹 */
	Elf32_Off e_phoff;					/* ץإåե륪եåȡ */
	Elf32_Off e_shoff;
	Elf32_Word e_flags;
	Elf32_Half e_ehsize;
	Elf32_Half e_phentsize;
	Elf32_Half e_phnum;					/* ץإå */
	Elf32_Half e_shentsize;
	Elf32_Half e_shnum;
	Elf32_Half e_shstrndx;
}Elf32_Ehdr;

char magic_number[]={0x7f,'E','L','F','\0'};

/* Program Header */
typedef struct{
	Elf32_Word p_type;		/* ȥס */
	Elf32_Off p_offset;		/* ե륪եåȡ */
	Elf32_Addr p_vaddr;		/* ꡼ɥ쥹 */
	Elf32_Addr p_paddr;
	Elf32_Word p_filesz;	/* ȥ */
	Elf32_Word p_memsz;
	Elf32_Word p_flags;		/* ȥե饰 */
	Elf32_Word p_align;
}Elf32_Phdr;


/*
 * ELFХʥɤ롣
 * parameters : open file struct
 * return : 0 or error=-1
 */
int load_elf(OPEN_F *open_f)
{
	Elf32_Ehdr *header;


	/* إåγǧ */
	if((header=(Elf32_Ehdr*)kmalloc(sizeof(Elf32_Ehdr)))==NULL)return -1;
	if(exec_read(open_f,header,sizeof(Elf32_Ehdr),0)!=sizeof(Elf32_Ehdr))goto ERR;
	if(strcmp(magic_number,header->e_ident)!=0)goto ERR;					/* ޥåʥСǧ */
	if((header->e_type!=ET_EXEC)||(header->e_machine!=EM_386))goto ERR;		/* סcpuǧ */


	return 0;

ERR:
	kfree(header);

	return -1;
}
