/*
 * mm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꡼ץ
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"lock.h"
#include"interrupt.h"
#include"proc.h"
#include"mp.h"
#include"segment.h"
#include"errno.h"
#include"mm.h"
#include"device.h"
/****************************/
extern void test_program();
/*****************************/


enum{
	PAGE_NUM=0x400,				/* Number of pages in a table or a directory */
	MAX_REF_PAGE_STORE=255,		/* Max refrence counts of page store */
	HEAP_NUM=11,				/* kmallocMEM¤κ */

	INT_BIT=sizeof(int)*8,		/* Number of integer bit */
};


/*
 * ʪ꡼ơ֥link struct
 * page tableprocessݻ
 */
typedef struct PAGE_TBL_ADD{
	uint *page_table;
	PROC *proc;
	struct PAGE_TBL_ADD *next;
}PAGE_TBL_ADD;

/*
 * ʪ꡼ơ֥빽¤
 * Page
 */
typedef struct PHYS_PAGE{
	ushort ref_count;				/* reference count */
	ushort heap_num;				/* Heap number */
	PAGE_TBL_ADD *page_tbl_add;		/* Link of page table address struct */
	struct PHYS_PAGE *next;
	struct PHYS_PAGE *prev;
}PHYS_PAGE;

typedef struct FREE{
	char* last;
	struct FREE *prev;
	struct FREE *next;
}FREE;

typedef struct{
	uint size;
	FREE *free;
	int gate;
}HEAP;


/* ꡼setup.S */
uint all_memory_size;

/* ꡼ơ֥ */
/*
 * free_mem_top (kernel mem)  (user mem) free_mem_end
 */
static PHYS_PAGE free_mem_top={0,0,NULL,NULL,NULL};		/* ʪ꡼󥯥ȥå */
static PHYS_PAGE free_mem_end={0,0,NULL,NULL,NULL};		/* ʪ꡼󥯥 */
/*
 * used_mem_top (new kernel mem)  (old kernel mem)  (new user mem)  (old user mem) used_mem_end
 */
static PHYS_PAGE used_mem_top={0,0,NULL,NULL,NULL};		/* ʲġʪ꡼󥯥ȥå */
static PHYS_PAGE used_mem_end={0,0,NULL,NULL,NULL};		/* ʲġʪ꡼󥯥 */
static PHYS_PAGE *used_usrmem_new=NULL;					/* Υ桼ʪ꡼ */

static int page_alloc_gate=0;							/* PHYS_PAGE lock gate */

/* kfreeʼ */
static FREE guard[HEAP_NUM];

/* kmallocѹ¤ */
static HEAP heap[]={
	{0,NULL,0},
	{0x8,   &guard[1], 0},
	{0x10,  &guard[2], 0},
	{0x20,  &guard[3], 0},
	{0x40,  &guard[4], 0},
	{0x80,  &guard[5], 0},
	{0x100, &guard[6], 0},
	{0x200, &guard[7], 0},
	{0x400, &guard[8], 0},
	{0x800, &guard[9], 0},
	{0x1000,&guard[10],0}
};

/* Page store table */
static size_t page_store_size=0;			/* Page store size */
static uchar *page_store_ref_table=NULL;	/* For refrence */
static uint *page_store_use_table=NULL;		/* For search */
static int unuse_store_table=0;				/* Unuse store table number */
static int page_sotre_gate=0;				/* Lock gate for page store handling */

static void *alloc_kernel_page();
static void *alloc_user_page(uint*);
static void link_page(void*);
static void unlink_page(void*);
static int buckup_used_page(void*);

static uint find_all_memsize();
static void init_physical_page_table();
static int init_page_backstore(char*);


/*
 * Physical addressPHYS_PAGE address֤
 * parameters : Physical address
 * return : PHYS_PAGE address
 */
extern inline PHYS_PAGE *get_physpage_from_addr(void *addr)
{
	return (PHYS_PAGE*)((uint)addr/PAGE_SIZE*sizeof(PHYS_PAGE)+PHYSICAL_PAGE_TABLE_ADD);
}


/*
 * PHYS_PAGE addressPhysical addres֤
 * parameters : PHYS_PAGE address
 * return : Physical address
 */
extern inline void *get_addr_from_physpage(PHYS_PAGE *memtable)
{
	return (void*)(((uint)memtable-PHYSICAL_PAGE_TABLE_ADD)/sizeof(PHYS_PAGE)*PAGE_SIZE);
}


/*
 * Page tableread write flag򥯥ꥢ
 * parameters : Page table address
 */
extern inline void clear_rwflag(uint *page)
{
	int i;


	for(i=0;i<PAGE_SIZE/sizeof(uint);++i)page[i]&=0xfffffffd;
}


/*
 * page_store_use_tableγbitޡ
 * parameters : Number
 */
extern inline void mark_page_store_use(int num)
{
	page_store_use_table[num/INT_BIT]|=1<<num%INT_BIT;
}


/*
 * page_store_use_tableγbit򥯥ꥢ
 * parameters : Number
 */
extern inline void clear_page_store_use(int num)
{
	page_store_use_table[num/INT_BIT]&=~(1<<num%INT_BIT);
}


/***********************************************************************************
 *
 * ؿ
 *
 ***********************************************************************************/


/*
 * ꡼ƥν
 */
void init_mm()
{
	/* Find size of physical memory  */
	printk("Memory size = %d MB\n",find_all_memsize()/0x100000);

	/* ʪ꡼ơ֥ */
	init_physical_page_table();

	/* ڡѵΰν */
	init_page_backstore(NULL);
}


/*
 * Find size of all physical memory
 */
uint find_all_memsize()
{
	enum{EXIST_MEM_SIZE=0x800000};		/* ꡼¬ñ */

	uint volatile *point;


	/* ꡼ñ̤Ȥ¬ꤹ*/
	for(point=(uint*)EXIST_MEM_SIZE-1;;point+=EXIST_MEM_SIZE/sizeof(uint))
	{
		*point=0x5a5a5a5a;
		if(*point!=0x5a5a5a5a)break;
		else
		{
			*point=0xf0f0f0f0;
			if(*point!=0xf0f0f0f0)break;
		}
	}

	return (all_memory_size=(uint)point-EXIST_MEM_SIZE+sizeof(uint));
}


/***********************************************************************************
 *
 * ꡼ؿ
 *
 ***********************************************************************************/


/*
 * ʪ꡼ơ֥롣
 */
void init_physical_page_table()
{
	int i,last;
	PHYS_PAGE *p=(PHYS_PAGE*)PHYSICAL_PAGE_TABLE_ADD;


	/* ǽ1Mbyteʬ꡼Ƥ0ˡ */
	memset(p,0,0x100000/PAGE_SIZE*sizeof(PHYS_PAGE));

	/* Ĥե꡼ꤹ롣 */
	for(i=0x100000/PAGE_SIZE,last=all_memory_size/PAGE_SIZE;i<last;++i)
	{
		p[i].ref_count=0;
		p[i].heap_num=0;
		p[i].page_tbl_add=NULL;
		p[i].next=&p[i+1];
		p[i].prev=&p[i-1];
	}
	free_mem_top.next=&p[0x100000/PAGE_SIZE];
	free_mem_end.prev=&p[i-1];
	p[0x100000/PAGE_SIZE].prev=&free_mem_top;
	p[i-1].next=&free_mem_end;

	/* ꡼ơ֥ʬ꡼ƤʲԲġˡ */
	last=ROUNDUP(PHYSICAL_PAGE_TABLE_ADD+all_memory_size/PAGE_SIZE*sizeof(PHYS_PAGE),PAGE_SIZE)/PAGE_SIZE;
	if(&p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE]==free_mem_top.next)
		free_mem_top.next=&p[last];
	else p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE-1].next=&p[last];

	/* Used link롣 */
	used_mem_top.next=&used_mem_end;
	used_mem_end.prev=&used_mem_top;
	used_usrmem_new=&used_mem_end;
}


/*
 * ֤ͥʪڡƤ롣
 * ƤڡϲԲ
 * return : Allocate addres or NULL
 */
void *alloc_kernel_page()
{
	void *address=NULL;
	bool used=0;
	PHYS_PAGE *p;


	enter_spinlock(&page_alloc_gate);
	{
		if(((p=free_mem_top.next)!=&free_mem_end)&((address=get_addr_from_physpage(p))<(void*)KERNEL_DATA_END))
		{
			p->ref_count=1;
			free_mem_top.next=p->next;
			p->next->prev=&free_mem_top;
		}
		else if(((p=used_mem_top.next)!=&used_mem_end)&(used_usrmem_new!=p))
		{
			address=get_addr_from_physpage(p);
			used_mem_top.next=p->next;
			p->next->prev=&used_mem_top;
			used=1;
		}
	}
	exit_spinlock(&page_alloc_gate);

	/* ꡼ƤХååפ롣 */
	if(used&&(buckup_used_page(address)==-1))return NULL;

	return address;
}


/*
 * 桼֤ʪڡƤ롣
 * Ƥڡϲ
 * parameters : ڡơ֥륢ɥ쥹
 * return : Allocate addres or NULL
 */
void *alloc_user_page(uint *page_tbl)
{
	void *address=NULL;
	bool used=0;
	PHYS_PAGE *p;
	PAGE_TBL_ADD *ptadd;


	enter_spinlock(&page_alloc_gate);
	{
		if((p=free_mem_end.prev)!=&free_mem_top)
		{
			address=(void*)get_addr_from_physpage(p);
			p->ref_count=1;
			free_mem_end.prev=p->prev;
			p->prev->next=&free_mem_end;

		}
		else if((p=used_mem_end.prev)!=&used_mem_top)
		{
			address=(void*)get_addr_from_physpage(p);
			used_mem_end.prev=p->prev;
			p->prev->next=&used_mem_end;
			used=1;
			if(used_usrmem_new==p)used_usrmem_new=&used_mem_end;
		}
		else
		{
			exit_spinlock(&page_alloc_gate);
			return NULL;
		}

		/* used link˲ä롣 */
		if(address<(void*)KERNEL_DATA_END)
		{
			p->prev=&used_mem_top;
			p->next=used_mem_top.next;
			used_mem_top.next=p;
			p->next->prev=p;
		}
		else
		{
			p->prev=used_usrmem_new->prev;
			p->next=used_usrmem_new;
			used_usrmem_new->prev=p;
			p->prev->next=p;
			used_usrmem_new=p;
		}
	}
	exit_spinlock(&page_alloc_gate);

	/* ꡼Ƥback up */
	if(used&&(buckup_used_page(address)==-1))return NULL;

	/* ڡơ֥륢ɥ쥹󥯤˲ä */
	if((ptadd=kmalloc(sizeof(PAGE_TBL_ADD)))==NULL)
	{
		unlink_page(address);
		return NULL;
	}
	ptadd->page_table=page_tbl;
	ptadd->proc=get_current_task();
	ptadd->next=p->page_tbl_add;
	p->page_tbl_add=ptadd;

	return address;
}


/*
 * ʪ꡼ڡλȥȤ䤹
 * parameters : ʪɥ쥹
 */
void link_page(void *add)
{
	PHYS_PAGE *p;


	p=get_physpage_from_addr(add);

	enter_spinlock(&page_alloc_gate);
	{
		if(++p->ref_count==2)
		{
			/* Used link */
			p->prev->next=p->next;
			p->next->prev=p->prev;
			if(used_usrmem_new==p)used_usrmem_new=p->next;
		}
	}
	exit_spinlock(&page_alloc_gate);
}


/*
 * ȥȤ򸺤餷ʪ꡼ڡ롣
 * parameters : ʪɥ쥹
 */
void unlink_page(void *add)
{
	PROC *proc;
	PHYS_PAGE *p;
	PAGE_TBL_ADD *q=NULL,**r;


	p=get_physpage_from_addr(add);

	enter_spinlock(&page_alloc_gate);
	{
		switch(--p->ref_count)
		{
			case -1:			/* ˻ȤƤʤޤϳԲĤΥڡ */
				p->ref_count=0;
				break;
			case 0:
				/* Used link */
				p->prev->next=p->next;
				p->next->prev=p->prev;
				if(used_usrmem_new==p)used_usrmem_new=p->next;

				if(add<(void*)KERNEL_DATA_END)
				{
					p->next=free_mem_top.next;
					p->prev=&free_mem_top;
					free_mem_top.next=p;
					p->next->prev=p;
				}
				else
				{
					p->prev=free_mem_end.prev;
					p->next=&free_mem_end;
					free_mem_end.prev=p;
					p->prev->next=p;
				}

				p->heap_num=0;
				q=p->page_tbl_add;
				p->page_tbl_add=NULL;

				break;
			case 1:
				/* used link˲ä롣 */
				if(add<(void*)KERNEL_DATA_END)
				{
					p->prev=&used_mem_top;
					p->next=used_mem_top.next;
					used_mem_top.next=p;
					p->next->prev=p;
				}
				else
				{
					p->prev=used_usrmem_new->prev;
					p->next=used_usrmem_new;
					used_usrmem_new->prev=p;
					p->prev->next=p;
					used_usrmem_new=p;
				}
			default:
				/* Page table address link */
				proc=cputask[get_current_cpu()].current_task;
				for(q=p->page_tbl_add,r=&p->page_tbl_add;q!=NULL;r=&q->next,q=q->next)
					if(q->proc==proc)
					{
						*r=q->next;
						break;
					}
		}
	}
	exit_spinlock(&page_alloc_gate);

	kfree(q);
}


/*
 * 2Ѿ襵Ȥ˥ڡ꡼ʬ䤹
 * ϥڡ
 * parameters : Size by byte
 * return : address
 */
void *kmalloc(size_t size)
{
	char *addr=NULL;
	int i;


	if((size==0)||(size>PAGE_SIZE))return NULL;		/* Require size is over */

	for(i=1;size>heap[i].size;++i);					/* Require size=heap[i].size */

	enter_spinlock(&heap[i].gate);
	{
		if(heap[i].free==&guard[i])
		{
			if((heap[i].free=(FREE*)alloc_kernel_page())==NULL)goto OUT;

			/*
			 * Ȥaddress狼褦ˤ
			 */
			get_physpage_from_addr((void*)heap[i].free)->heap_num=i;

			heap[i].free->prev=&guard[i];
			heap[i].free->next=&guard[i];
			guard[i].prev=heap[i].free;
			guard[i].next=heap[i].free;
			heap[i].free->last=(char*)heap[i].free+PAGE_SIZE;
		}

		addr=(char*)heap[i].free->last-heap[i].size;

		if(heap[i].free==(FREE*)addr)
		{
			heap[i].free=((FREE*)addr)->next;
			((FREE*)addr)->prev->next=((FREE*)addr)->next;
			((FREE*)addr)->next->prev=((FREE*)addr)->prev;
		}
		else heap[i].free->last=addr;
	}
OUT:
	exit_spinlock(&heap[i].gate);

	return addr;
}


/*
 * ꡼
 * parameters : Address
 */
void kfree(void *ptr)
{
	uint i;
	FREE *p,*end;


	if(ptr==NULL)return;

	if((i=(int)get_physpage_from_addr(ptr)->heap_num)==0)return;

	enter_spinlock(&heap[i].gate);
	{
		/* Free linkϾ */
		for(p=heap[i].free;p!=&guard[i];p=p->next)
			if(p>(FREE*)ptr)break;

		/* Link */
		p->prev->next=(FREE*)ptr;
		((FREE*)ptr)->prev=p->prev;
		((FREE*)ptr)->next=p;
		((FREE*)ptr)->last=(char*)ptr+heap[i].size;
		p->prev=(FREE*)ptr;

		/* ɥ쥹³ƤХ꡼Ĥʤ */
		end=((FREE*)ptr)->prev;
		do
		{
			p=p->prev;

			if(p->last==(char*)p->next)
			{
				p->last=p->next->last;
				p->next=p->next->next;
			}

			/* ꡼PAGE_SIZEʤڡ */
			if(!((uint)p&PAGE_BOUND)&&(p->last>=(char*)p+PAGE_SIZE))
			{
				if(p->last>(char*)p+PAGE_SIZE)
				{
					p->prev->next=(FREE*)((char*)p+PAGE_SIZE);
					p->prev->next->next=p->next;
					p->prev->next->prev=p->prev;
					p->prev->next->last=p->last;
					p->next->prev=p->prev->next;
				}
				else
				{
					p->prev->next=p->next;
					p->next->prev=p->prev;
				}
				unlink_page(p);
				break;
			}

		}while(p!=end);

		/* Free memory link Ƭ */
		heap[i].free=guard[i].next;
	}
	exit_spinlock(&heap[i].gate);
}


/***********************************************************************************
 *
 * ڡ󥰴ؿ
 *
 * ڡȤξ
 * ȥȤǤ뤳
 *
 ***********************************************************************************/


/*
 * ͥڡơ֥ꤹ
 * return : Page directory or NULL
 */
uint *init_idle_page()
{
	void *stack;
	uint *idle_pagedir,*pagetable;
	uint i;


	/* ͥڡǥ쥯ȥ */
	if((idle_pagedir=(uint*)alloc_kernel_page())==NULL)return NULL;
	memset(idle_pagedir,0,PAGE_SIZE);
	for(i=0;i<KERNEL_STACK_BEG/PAGEDIR_ALLOC_SIZE;++i)
		idle_pagedir[i]=i*PAGEDIR_ALLOC_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M;

	/* ͥ륹åڡƤ */
	if((pagetable=(uint*)alloc_kernel_page())==NULL)return NULL;
	memset(pagetable,0,PAGE_SIZE);
	idle_pagedir[KERNEL_STACK_BEG/PAGEDIR_ALLOC_SIZE]=(uint)pagetable|PAGE_PRESEN|PAGE_RW;
	if((stack=alloc_kernel_page())==NULL)return NULL;
	pagetable[1023]=(uint)stack|PAGE_PRESEN|PAGE_RW;

	/* ꡼ޥåץIOڡѥǥ쥯ȥ */
	for(i=IOMAP_BEG/PAGEDIR_ALLOC_SIZE;i<1024;++i)
	   	idle_pagedir[i]=i*PAGEDIR_ALLOC_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M|PAGE_CASH_DISABLE;

	/* ڡ󥰳 */
	asm volatile(
			"movl	%%eax,%%cr3\n"			/* Set page directory address */
			"movl	$0x10,%%eax\n"
			"movl	%%eax,%%cr4\n"			/* 4Mڡĥ */
			"movl	%%cr0,%%eax\n"
			"orl	$0x80010000,%%eax\n"	/* Enable paging,Enable wp(ѡХν񤭹ݸ) */
			"movl	%%eax,%%cr0\n"
			"jmp	1f\n"
		"1:"
		::"a"(idle_pagedir)
	);

	return idle_pagedir;
}


/*
 * ڡ󥰤ǤΥڡƤ¸ν
 * Ȥκ255
 * parameters : ¸ǥХ̾
 * return : 0 or Error number
 */
int init_page_backstore(char *path)
{
	enum{BYTE_BIT=8};

	int i,last;
	PHYS_PAGE *p,*q,*r,*beg,*befo;


	/* ǥХ饵 */
	page_store_size=0x4000000;

	/* ȥѥơ֥Ϣ³ΰǳƤʲԲġ */
	last=ROUNDUP(page_store_size/PAGE_SIZE,PAGE_SIZE)/PAGE_SIZE;
	for(p=free_mem_top.next,befo=NULL;;befo=r)
	{
		beg=p;
		if(p==NULL)return -ENOMEM;
		for(i=0,q=p;p==q;r=p,p=p->next,++q)
			if(++i==last)goto EXIT1;
	}
EXIT1:
	if(befo==NULL)free_mem_top.next=p->next;
	else befo->next=p->next;
	page_store_ref_table=get_addr_from_physpage(beg);
	memset(page_store_ref_table,0,last*PAGE_SIZE);

	/* ѥơ֥Ϣ³ΰǳƤʲԲġ */
	last=ROUNDUP(page_store_size/PAGE_SIZE/BYTE_BIT,PAGE_SIZE)/PAGE_SIZE;
	for(p=free_mem_top.next,befo=NULL;;befo=r)
	{
		beg=p;
		if(p==NULL)return -ENOMEM;
		for(i=0,q=p;p==q;r=p,p=p->next,++q)
			if(++i==last)goto EXIT2;
	}
EXIT2:
	if(befo==NULL)free_mem_top.next=p->next;
	else befo->next=p->next;
	page_store_use_table=get_addr_from_physpage(beg);
	memset(page_store_use_table,0,last*PAGE_SIZE);

	return 0;
}


/*
 * Except of page fault
 * parameters : Exception frame
 */
void page_fault(EXCEPT_FRAME frame)
{

}


/*
 * Buck up used page into page store device
 * parameters : physical address
 * returns : 0 or Error number
 */
int buckup_used_page(void *addr)
{
	PHYS_PAGE *phys_page;
	PAGE_TBL_ADD *p,*beg;
	int store_num;
	int cpu;
	int i,j,last;


	phys_page=get_physpage_from_addr(addr);
	cpu=get_current_cpu();

	if((beg=phys_page->page_tbl_add)==NULL)return -ENOMEM;
	p=beg;
	do
	{
		/* page tableԺߤ */
		enter_spinlock(&p->proc->pagedir_gate);
		{
			*p->page_table&=~PAGE_PRESEN;
		}
		exit_spinlock(&p->proc->pagedir_gate);

		/* process¹ʤpage tableTBLեå夹 */
		if((p->proc->cpu!=cpu)&&(cputask[p->proc->cpu].current_task==p->proc))
			issue_interrupt_to_cpu(p->proc->cpu,FLASH_PAGEDIR_VECT);
	}while((p=p->next)!=beg);

	/* Search store space from page_store_use_table */
	last=page_store_size/PAGE_SIZE/INT_BIT;
	enter_spinlock(&page_sotre_gate);
	{
		for(i=unuse_store_table;page_store_use_table[i]!=~0;)
		{
			if(++i>=last)i=0;
			if(i==unuse_store_table)
			{
				exit_spinlock(&page_sotre_gate);
				return -ENOMEM;
			}
		}
		for(j=0;page_store_use_table[i]&(1<<j);++j);
		page_store_use_table[i]|=(1<<j);
		store_num=i*INT_BIT+j;

		unuse_store_table=i;
	}
	exit_spinlock(&page_sotre_gate);

	/* Store page to store device */
	/* ??????????????????????????? */

	return 0;
}


/*
 * Set pagetable
 * parameters : Load page address,Sorce page address,Page flag,Load process
 * return : 0 or Error number
 */
int load_user_page(void *dist,int flag,PROC *proc)
{
	void *page;
	uint *pagetable;


	enter_spinlock(&proc->pagedir_gate);
	{
		pagetable=(uint*)proc->pagedir[(uint)dist/PAGEDIR_ALLOC_SIZE];

	    if(pagetable==0)
	    {
	    	/* page tableƤ */
	    	if((pagetable=(uint*)alloc_kernel_page())==NULL)goto ERROR;
	    	memset(pagetable,0,PAGE_SIZE);
	    	proc->pagedir[(uint)dist/PAGEDIR_ALLOC_SIZE]=(uint)pagetable|PAGE_PRESEN|PAGE_USER|PAGE_RW;
	    }
	    else pagetable=(uint*)((uint)pagetable&PAGE_ROUNDDOWN);

		/* pageƤ */
		if((page=alloc_user_page(&pagetable[((uint)dist&(PAGEDIR_ALLOC_SIZE-1))/PAGE_SIZE]))==NULL)goto ERROR;
		pagetable[((uint)dist&(PAGEDIR_ALLOC_SIZE-1))/PAGE_SIZE]=(uint)page|PAGE_PRESEN|PAGE_USER|flag;
	}
	exit_spinlock(&proc->pagedir_gate);

	return 0;

ERROR:
	exit_spinlock(&proc->pagedir_gate);

	return -ENOMEM;
}


/*
 * page table
 * text sectionstackʳdata section롣user stack1pageĤƳ롣
 * parameters : process
 */
void free_user_page(PROC *proc)
{
	uint *page;
	int i,j;


	enter_spinlock(&proc->pagedir_gate);
	{
		/* user stackκǽpageĤƳ */
		page=(uint*)(proc->pagedir[USER_STACK_BEG/PAGEDIR_ALLOC_SIZE]&PAGE_ROUNDDOWN);
	    for(j=0;j<PAGE_SIZE/sizeof(uint)-1;++j)
	    {
	    	if(page[j]==0)continue;
	    	else if(page[j]&PAGE_PRESEN)
	    		unlink_page((void*)page[j]);
			else
			{
				if(--page_store_ref_table[page[j]>>1]==0)
					clear_page_store_use(page[j]>>1);
			}

			page[j]=0;
		}

		/* Ĥuser page򤹤٤Ƴ */
		for(i=USER_BEG/PAGEDIR_ALLOC_SIZE;i<USER_STACK_BEG/PAGEDIR_ALLOC_SIZE;++i)
	    	if(proc->pagedir[i]&PAGE_PRESEN)
	    	{
	    		page=(uint*)(proc->pagedir[i]&PAGE_ROUNDDOWN);
	    		for(j=0;j<PAGE_SIZE/sizeof(uint);++j)
	    		{
	    			if(page[j]==0)continue;
	    			else if(page[j]&PAGE_PRESEN)unlink_page((void*)page[j]);
					else
					{
						if(--page_store_ref_table[page[j]>>1]==0)
							clear_page_store_use(page[j]>>1);
					}
				}

				/* page table */
				unlink_page(page);

				/* page direstory0ꥢ */
				proc->pagedir[i]=0;
			}
	}
	exit_spinlock(&proc->pagedir_gate);
}


/***********************************************************************************
 *
 * ƥॳѴؿ
 *
 ***********************************************************************************/


/*
 * forkˤ꡼ƥȤ򥳥ԡ
 * page directorypage tableΥԡҥץåݥ󥿤Υɥ쥹
 * parameters : Destination page directory,Return stack offset
 * return : New Page directory or NULL
 */
uint *fork_page(PROC *org,PROC *proc,void **stack)
{
	uint *dir,*org_page,*page;
	int i,j;


	/* Page directory򥳥ԡ */
	if((dir=(uint*)alloc_kernel_page())==NULL)return NULL;
	memcpy(dir,org->pagedir,PAGE_SIZE);

	/* Kernel stackƤ */
	if((page=(uint*)alloc_kernel_page())==NULL)goto ERROR1;

	dir[KERNEL_STACK_BEG/PAGEDIR_ALLOC_SIZE]=(uint)page|PAGE_PRESEN|PAGE_RW;
	org_page=(uint*)(org->pagedir[KERNEL_STACK_BEG/PAGEDIR_ALLOC_SIZE]&PAGE_ROUNDDOWN);
	if((*stack=alloc_kernel_page())==NULL)goto ERROR2;
	memcpy(*stack,(void*)(org_page[1023]&PAGE_ROUNDDOWN),PAGE_SIZE);
	page[1023]=(uint)*stack|PAGE_PRESEN|PAGE_RW;
	memset(page,0,1023*sizeof(uint));

	/* Userΰ򥳥ԡ饤Ȥꤹ */
	for(i=USER_BEG/PAGEDIR_ALLOC_SIZE;i<USER_END/PAGEDIR_ALLOC_SIZE;++i)
		if(dir[i]!=0)
		{
			org_page=(uint*)(dir[i]&PAGE_ROUNDDOWN);
			enter_spinlock(&org->pagedir_gate);
			{
				clear_rwflag(org_page);
			}
			exit_spinlock(&org->pagedir_gate);

			for(j=0;j<PAGE_NUM;++j)
			{
				if(org_page[j]&PAGE_PRESEN)link_page((void*)org_page[j]);
				else if(org_page[j]!=0)
					/* Increase reference count of Swap table */
					++page_store_ref_table[org_page[j]>>1];
			}
		}

	return dir;


ERROR2:
	unlink_page((void*)page[1023]);
	unlink_page(page);
ERROR1:
	unlink_page(dir);

	return NULL;
}
