/*
 * fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ե륷ƥ
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"mm.h"
#include"proc.h"
#include"fs.h"


enum{
	VDIR_MAX_NAME_SIZE=127,	/* ̥ե륷ƥκ̾ */
};


/* ̥ե륷ƥǥ쥯ȥ */
typedef struct VDIR{
	ushort ref_count;				/* ȥ */
	ushort din;						/* device inode index */
	uint dir_blk;					/* ե륷ƥΥǥ쥯ȥ֥å */
	struct VDIR *next;				/* ƱΡ */
	struct VDIR *prev;				/* ƱΡ */
	struct VDIR *low_next;			/* ΥΡ */
	struct VDIR *high_prev;			/* ΥΡ */
	char name[VDIR_MAX_NAME_SIZE];
}VDIR;

/* ޥȥե륷ƥ।ǥå */
typedef struct{
	ushort fs_num;			/* ե륷ƥʥС */
	ushort ref_count;		/* ȥ */
}MOUNT_FS;

/* եǥץ */
typedef struct{
	ushort ref_count;	/* ȥ */
	ushort din;			/* device inode number */
	uint block;			/* inode֥å */
	size_t offset;		/* ɤ߽񤭳ϥեå */
}F_DSC;

/* ץѥե빽¤ */
typedef struct{
	F_DSC *fd[MAX_FILE_OPEN];
	VDIR *current_dir;
}FILE_STRUCT;


static FS *fs_info[MAX_REGIST_FS];
static MOUNT_FS mount_fs[MAX_DEVICE_OPEN];
static char _root[sizeof(VDIR)-VDIR_MAX_NAME_SIZE+sizeof(int)];
static VDIR *root=(VDIR*)_root;


static VDIR *search_vdir(const char*,VDIR*);
static VDIR *get_vdir(const char*,VDIR*);
static void del_up_vdir(VDIR*);


/************************************************************************************
 *
 * misc functions
 *
 ************************************************************************************/

/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string
 * return : =Υѥ or ԰=NULL
 */
extern inline const char *cmp_path(const char *path1,const char *path2)
{
	while(*path1!='\0')
		if(*path1++!=*path2++)return NULL;

	if(*path2=='\0')return path2;
	if(*path2=='/')return ++path2;

	return NULL;
}


/*
 * ѥ'/'ޤ'\0'ޤǥԡơ'\0'ղä롣
 * parameters : Destination string,Sorce string
 */
extern inline const char *cpy_path(const char *path,char *str)
{
	while((*str=*path++)!='\0')
		if(*str++=='/')
		{
			*(str-1)='\0';
			return path;
		}

	return path-1;
}


/************************************************************************************
 *
 * 
 *
 ************************************************************************************/

/*
 * Init filesystem
 */
void init_fs()
{
	memset(fs_info,0,sizeof(FS*)*MAX_REGIST_FS);
	memset(mount_fs,0,sizeof(MOUNT_FS)*MAX_DEVICE_OPEN);
	memset(_root,0,sizeof(VDIR)-VDIR_MAX_NAME_SIZE+sizeof(int));
}


/************************************************************************************
 *
 * file system functions
 *
 ************************************************************************************/

/*
 * Register filesystem
 * parameters : Filesystem struct pinter
 * return : 0 or Error=-1
 */
int regist_fs(FS *fs)
{
	int i;


	for(i=0;i<MAX_REGIST_FS;++i)
		if(fs_info[i]==NULL)
		{
			fs_info[i]=fs;
			return 0;
		}

	return -1;
}


/*
 * Search file system
 * parameters : file system name
 * return : file system number or noshing=-1
 */
int search_fs(const char *name)
{
	int i;


	for(i=0;fs_info[i]!=NULL;++i)
		if(strcmp(fs_info[i]->name,name)==0)return i;

	return -1;
}


/*
 * forkˡեطι¤Τƥץ饳ԡ롣
 * parameters : file descriptor pointer,current directory pointer
 * return : 0 or error=-1
 */
int cpy_file_struct(PROC *parent,PROC *child)
{
	if((child->file_struct=kmalloc(sizeof(FILE_STRUCT)))==NULL)return -1;
	memcpy(((FILE_STRUCT*)parent->file_struct)->fd,((FILE_STRUCT*)child->file_struct)->fd,sizeof(F_DSC*)*MAX_FILE_OPEN);
	((FILE_STRUCT*)child->file_struct)->current_dir=((FILE_STRUCT*)parent->file_struct)->current_dir;

	return 0;
}


/************************************************************************************
 *
 * ե륷ƥشؿ
 * 	ޥȻȥȥǥ쥯ȥѹˡ̥ǥ쥯ȥ롣
 *
 ************************************************************************************/

/*
 * ѥ̾Υǥ쥯ȥõ
 * parameters : path,parent vdir
 * return : directory address
 */
VDIR *search_vdir(const char *path,VDIR *vdir)
{
	const char *c;
	VDIR *p,*q;


	for(p=q=vdir->low_next;p!=NULL;p=q)
	{
		if((c=cmp_path(".",path))!=NULL);		/* '.'ξ硣 */
		else if((c=cmp_path("..",path))!=NULL)	/* '..'ξ硣 */
			q=p->high_prev;
		else
		{
			for(q=p;;)
			{
				if((c=cmp_path(p->name,path))!=NULL)break;
				if((p=p->next)==q)return NULL;
			}
			q=p->low_next;
		}

		if(*(path=c)=='\0')return p;
	}

	return NULL;
}


/*
 * ѥ̾Υǥ쥯ȥΥݥ󥿤֤
 * parameters : path,parent directory
 * return : directory pointer or error=NULL
 */
VDIR *get_vdir(const char *path,VDIR *parent)
{
	char str[VDIR_MAX_NAME_SIZE+1];
	const char *c;
	uint block;
	VDIR *p,*q;


	for(p=parent;*path!='\0';)
	{
		/* '.'ξ硣 */
		if((c=cmp_path(".",path))!=NULL)path=c;

		/* '..'ξ硣 */
		else if((c=cmp_path("..",path))!=NULL)
		{
			q=p->high_prev;

			/* ȥǥ쥯ȥ꤬ȤƤʤС롣 */
			if((p->ref_count==0)&&(p->low_next==NULL))
			{
				p->next->prev=p->prev;
				p->prev->next=p->next;
				if(q->low_next==p)q->low_next=NULL;
				kfree(p);
			}

			if(q==NULL)return NULL;
			p=q;
			path=c;
		}

		/* ̥ǥ쥯ȥ꤬ʤ硢˥ǥ쥯ȥ롣 */
		else if(p->low_next==NULL)
		{
			/* ǥ쥯ȥκ */
			cpy_path(path,str);
			if((block=fs_info[mount_fs[p->din].fs_num]->opendir(str,p->din,p->dir_blk))==0)
			{
				del_up_vdir(p);
				return NULL;
			}
			if((q=(VDIR*)kmalloc(sizeof(VDIR)-VDIR_MAX_NAME_SIZE+strlen(str)+1))==NULL)
			{
				del_up_vdir(p);
				return NULL;
			}
			p->low_next=q;
			q->ref_count=0;
			q->din=p->din;
			q->dir_blk=block;
			q->next=q;
			q->prev=q;
			q->low_next=NULL;
			q->high_prev=p;
			path=cpy_path(path,q->name);
			p=q;
		}

		else
		{
			for(q=p=p->low_next;;)
			{
				if((c=cmp_path(p->name,path))!=NULL)
				{
					path=c;
					break;
				}
				if((p=p->next)==q)
				{
					/* ǥ쥯ȥκ */
					cpy_path(path,str);
					if((block=fs_info[mount_fs[p->din].fs_num]->opendir(str,q->high_prev->din,q->high_prev->dir_blk))==0)return NULL;
					if((q=(VDIR*)kmalloc(sizeof(VDIR)-VDIR_MAX_NAME_SIZE+strlen(str)+1))==NULL)return NULL;
					q->din=p->high_prev->din;
					q->ref_count=0;
					q->dir_blk=block;
					q->next=p->next;
					q->prev=p;
					p->next=q;
					q->next->prev=q;
					q->low_next=NULL;
					q->high_prev=p->high_prev;
					path=cpy_path(path,q->name);
					p=q;

					break;
				}
			}
		}
	}

	return p;
}


/*
 * ǥ쥯ȥäƺ롣
 * parameters : directory
 */
void del_up_vdir(VDIR *vdir)
{
	VDIR *p,*q;


	for(p=vdir;p!=NULL;)
	{
		/* ȤƤʤĲ̥ǥ쥯ȥ꤬ʤк롣 */
		if((p->ref_count==0)&&(p->low_next==NULL))
		{
			p->next->prev=p->prev;
			p->prev->next=p->next;
			q=p->high_prev;
			if(q->low_next==p)q->low_next=p->next;
			if(q->low_next==p)q->low_next=NULL;
			kfree(p);
			p=q;
		}
		else break;
	}
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

int sys_mount(const char *device,const char *fs_name,const char *path)
{
	enum{DEV_NAME_SIZE=5};		/* "/dev/"Υ */

	int fs;
	int din;
	uint root_blk;
	VDIR *vdir;


	/* Search file system number */
	if((fs=search_fs(fs_name))==-1)return -1;

	/* ǥХץ */
	if(cmp_path("/dev/",device)==NULL)return -1;
	if((din=(int)fs_info[0]->open(device+DEV_NAME_SIZE,NULL,0))==-1)return -1;

	/* ǥХ˥ޥȤƤ뤫 */
	if(mount_fs[din].ref_count>0)goto ERR;

	/* ޥȴؿƤӽФ */
	if((root_blk=fs_info[fs]->mount(din))==-1)goto ERR;

	/* ե륷ƥؤϿ롣 */
	if(*path=='/')
	{
		if((vdir=get_vdir(path+1,root))==NULL)goto ERR;
	}
	else
		if((vdir=get_vdir(path,((FILE_STRUCT*)get_current_task()->file_struct)->current_dir))==NULL)goto ERR;
	if(vdir->ref_count>0)goto ERR2;
	vdir->din=din;
	vdir->dir_blk=root_blk;
	vdir->ref_count=1;

	return 0;

ERR2:
	del_up_vdir(vdir);
ERR:
	fs_info[0]->close(din);

	return -1;
}

int sys_umount(const char *path)
{
	int fs;
	VDIR *vdir;


	/* ǥ쥯ȥõ */
	if(*path=='/')
	{
		if((vdir=search_vdir(path+1,root))==NULL)return -1;
	}
	else
		if((vdir=search_vdir(path,((FILE_STRUCT*)get_current_task()->file_struct)->current_dir))==NULL)return -1;

	if(vdir->ref_count>1)return -1;

	/* ޥȴؿƤӽФ */
	fs=mount_fs[vdir->din].fs_num;
	if(fs_info[fs]->umount(vdir->din)==-1)return -1;

	mount_fs[vdir->din].ref_count=0;
	vdir->ref_count=0;
	del_up_vdir(vdir);

	return 0;
}

/*
 * ѥƬ'/'̤openޥɤϤ
 */
int sys_open(const char *path)
{
	PROC *proc;

	proc=get_current_task();

	return 0;
}

int sys_read()
{
	return 0;
}

int sys_write()
{
	return 0;
}

int sys_lseek()
{
	return 0;
}

int sys_rename()
{
	return 0;
}

int sys_creat()
{
	return 0;
}

int sys_unlink()
{
	return 0;
}

int sys_lock()
{
	return 0;
}

int chdir()
{
	return 0;
}
