/*
 * device.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef device_h
#define device_h


#include"types.h"


#ifndef ASM_FILE


/* ʪǥХȤ */
typedef struct{
	const char *name;					/* Device name */
	int secter_size;					/* Secter size */
	uint begin_blk;						/* Begin block number */
	uint last_blk;						/* Last block number */
	int (*open)();						/* parameters : device name */
	int (*read)(void*,size_t,size_t);	/* parameters : Buffer,transfer blocks,Begin block number */
	int (*write)(void*,size_t,size_t);	/* parameters : Buffer,transfer blocks,Begin block number */
	int (*ioctl)(int,void*);			/* parameters : Comand,Parameters */
}DEV_INFO;


/* ǥХȤ */
typedef struct{
	uchar pt_num;		/* Partition number */
	uchar pt_prn;		/* Partition presence flag */
	uchar pt_type;		/* Partition type */
	uchar ref_count;	/* Reference count */
	DEV_INFO *dev;		/* Device infomation pointer */
	uint begin_blk;		/* Begin block number */
	uint blocks;		/* Number of blocks */
}DEV_INODE;


extern DEV_INODE dinode[];


extern int init_device();
extern int regist_device(DEV_INFO*);
extern int delete_device(const char*);


#endif


#endif
