/*
 * error.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include"types.h"
#include"lib.h"
#include"errno.h"


const char *error_str[]={
	NULL,
	"EAGAIN",
	"EDEADLK",
	"ENOLCK",
	"ENOTTY",
	"EPERM",
	"EPIPE",
	"EDOM",
	"ERANGE",
 	"ENOMEM",
	"EFAULT",
 	"EINTR",
	"EINVAL",
	"E2BIG",
	"ENOSYS",
	"ECHILD",
	"ESRCH",
	"EACCES",
	"ENOTEMPTY",
	"ENOEXEC",
	"EBADF",
	"EBUSY",
	"EEXIST",
	"EFBIG",
	"EISDIR",
	"ENOTDIR",
	"EMFILE",
	"EMLINK",
	"ENAMETOOLONG",
	"ENFILE",
	"ENOENT",
	"EROFS",
	"ESPIPE",
	"EXDEV",
	"EIO",
	"ENODEV",
	"ENXIO",
	"ENOSPC",
	"EDBUSY",
	"EDERRE",
	"ENOMEDIUM",
	"EMDEV",
	"ENOTIMER",
	"ETIMEOUT"
};


/*
 * parameters : error number
 * return : error number
 */
int print_error(int errno,char *func)
{
	printk("Error occurred! address : %x, function name : %s, error : %s\n",*(&errno-1),func,error_str[errno]);

	return -errno;
}
