/*
 * fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ե륷ƥ̥쥤
 */


#include"types.h"
#include"lib.h"
#include"mm.h"
#include"proc.h"
#include"fs.h"


enum{
	MAX_REGIST_FS=16,		/* ե륷ƥϿ */
};


FS *fs_info[MAX_REGIST_FS];
static char _root[sizeof(VDIR)-VDIR_MAX_NAME_SIZE+sizeof(int)];
static VDIR *root=(VDIR*)_root;


static int mount_vdir(const char*,int,int);


/************************************************************************************
 *
 * Inline function
 *
 ************************************************************************************/


/*
 * Search file system
 * parameters : file system name
 * return : file system number or noshing=-1
 */
extern inline int search_fs(const char *name)
{
	int i;


	for(i=0;fs_info[i]!=NULL;++i)
		if(strcmp(fs_info[i]->name,name)==0)return i;

	return -1;
}


/*
 * get virtual directory
 * parameters : path name
 * return : virtual directory or error=NULL
 */
extern inline VDIR *get_vdir(const char *path,VDIR *vdir)
{
	for(vdir=vdir->low_next;vdir!=NULL;vdir=vdir->same_next)
		if(cmp_path(path,vdir->name)==0)return vdir;

	return NULL;
}


/************************************************************************************
 *
 * Misc function
 *
 ************************************************************************************/


/*
 * Register filesystem
 * parameters : Filesystem struct pinter
 * return : 0 or Error=-1
 */
int regist_fs(FS *fs)
{
	int i;


	for(i=0;i<MAX_REGIST_FS;++i)
		if(fs_info[i]==NULL)
		{
			fs_info[i]=fs;
			return 0;
		}

	return -1;
}


/*
 * Check Mount file system
 * ѥե륷ƥΥ롼ȤΥѥѤ롣
 * parameters : path
 * return : file system number or error=-1
 */
int check_fs(const char *path)
{
	return 0;
}


/************************************************************************************
 *
 * 
 *
 ************************************************************************************/


/*
 * Init filesystem
 */
void init_fs()
{
	int i;


	for(i=0;i<MAX_REGIST_FS;++i)fs_info[i]=NULL;
}


/************************************************************************************
 *
 * Virtual file System
 *
 ************************************************************************************/


/*
 * Set root virtual directory
 */
int mount_root_fs(const char *device,const char *fs_name)
{
	return 0;
}


/*
 * Mount directory
 */
int mount_vdir(const char *path,int fs,int din)
{
	return 0;
}


/*
 * Unmount directory
 */
int umount_vdir(const char *path,int fs,int din)
{
	return 0;
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/


int sys_mount(const char *device,const char *fs_name,const char *path)
{
	enum{DEV_NAME_SIZE=5};		/* "/dev/"Υ */

	int fs;
	int din;


	/* Search file system number */
	if((fs=search_fs(fs_name))==-1)return -1;

	/* ǥХץ */
	if(cmp_path("/dev/",device)==-1)return -1;
	if((din=(int)fs_info[0]->open(device+DEV_NAME_SIZE,NULL,0))==-1)return -1;

	/* ۥե륷ƥۤ롣 */
	if(mount_vdir(path,fs,din)==-1)goto ERR;

	return 0;

ERR:
	fs_info[fs]->umount(din);
	fs_info[0]->close((void*)din);

	return -1;
}

int sys_umount(const char *path)
{
	return 0;
}

/*
 * ѥƬ'/'̤openޥɤϤ
 */
int sys_open(const char *path)
{
	PROC *proc;

	proc=get_current_task();

	return 0;
}

int sys_read()
{
	return 0;
}

int sys_write()
{
	return 0;
}

int sys_lseek()
{
	return 0;
}

int sys_rename()
{
	return 0;
}

int sys_creat()
{
	return 0;
}

int sys_unlink()
{
	return 0;
}

int sys_lock()
{
	return 0;
}
