/*
 * utime.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>

#include<errno.h>
#include<unistd.h>
#include<sys/time.h>
#include<utime.h>


extern int chattr(const char*,int,struct utimbuf*);


int utime(const char *filename, struct utimbuf *buf)
{
	return chattr(filename,CHATTR_UTIME,buf);
}


int utimes(const char *path, const struct timeval *times)
{
	struct utimbuf buf;


	buf.actime=times[0].tv_sec;
	buf.modtime=times[1].tv_sec;

	return utime(path,&buf);
}


int lutimes(const char *path, const struct timeval *times)
{
	return utimes(path,times);
}
