/*
 * strtol.c
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<ctype.h>
#include<limits.h>


long int strtol(const char *nptr, char **endptr, int base)
{
	int sign;
	int value,digit;


	/* γǧ */
	if((base>36)||(base<0)||(base==1))
	{
		errno=EINVAL;
		return 0;
	}

	/* ۥ磻ȥڡν */
	for(;isspace(*nptr);++nptr);

	/* γǧ */
	if(*nptr=='+')
	{
		sign=1;
		++nptr;
	}
	else if(*nptr=='-')
	{
		sign=-1;
		++nptr;
	}
	else sign=1;

	/* 0ξ硣 */
	
	if(*nptr=='0')
	{
		if((*(nptr+1)=='x')||(*(nptr+1)=='X'))
		{
			if(base==0)base=16;
			nptr+=2;
		}
		else
		{
			if(base==0)base=8;
			++nptr;
		}
	}
	else if(base==0)base=10;

	/* Ѵ */
	value=0;
	for(;isalnum(*nptr);++nptr)
	{
		if(isupper(*nptr))digit=*nptr-'A'+10;
		else if(islower(*nptr))digit=*nptr-'a'+10;
		else if(isdigit(*nptr))digit=*nptr-'0';
		else break;

		if(digit>=base)break;
		value*=base;
		value+=digit;
	}

	if(endptr!=NULL)*endptr=(char*)nptr;

	return value*sign;
}
